/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.LUCS_KDD;

import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.LUCS_KDD.TotalSupportTree;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.FPgrowth.myDataset;

public class FPtree
extends TotalSupportTree {
    protected FPtreeNode rootNode = new FPtreeNode();
    protected FPgrowthHeaderTable[] headerTable = new FPgrowthHeaderTable[this.numOneItemSets + 1];
    private static FPgrowthSupportedSets startTempSets = null;
    private int tempIndex = 0;

    public FPtree(myDataset ds, double sup, double conf) {
        super(ds, sup, conf);
        for (int index = 1; index < this.headerTable.length; ++index) {
            this.headerTable[index] = new FPgrowthHeaderTable((short)index);
        }
    }

    public void createFPtree() {
        int index;
        this.headerTable = new FPgrowthHeaderTable[this.numOneItemSets + 1];
        for (index = 1; index < this.headerTable.length; ++index) {
            this.headerTable[index] = new FPgrowthHeaderTable((short)index);
        }
        for (index = 0; index < this.dataArray.length; ++index) {
            if (this.dataArray[index] == null) continue;
            this.addToFPtree(this.rootNode, 0, this.dataArray[index], 1, this.headerTable);
        }
    }

    private void addToFPtree(FPtreeNode ref, int place, short[] itemSet, int support, FPgrowthHeaderTable[] headerRef) {
        if (place < itemSet.length && !this.addToFPtree1(ref, place, itemSet, support, headerRef)) {
            this.addToFPtree2(ref, place, itemSet, support, headerRef);
        }
    }

    private boolean addToFPtree1(FPtreeNode ref, int place, short[] itemSet, int support, FPgrowthHeaderTable[] headerRef) {
        if (ref.childRefs != null) {
            for (int index = 0; index < ref.childRefs.length; ++index) {
                if (itemSet[place] == ref.childRefs[index].node.itemName) {
                    ref.childRefs[index].node.itemCount = ref.childRefs[index].node.itemCount + support;
                    ++this.numUpdates;
                    this.addToFPtree(ref.childRefs[index], place + 1, itemSet, support, headerRef);
                    return true;
                }
                if (itemSet[place] >= ref.childRefs[index].node.itemName) continue;
                return false;
            }
        }
        return false;
    }

    private void addToFPtree2(FPtreeNode ref, int place, short[] itemSet, int support, FPgrowthHeaderTable[] headerRef) {
        FPgrowthItemPrefixSubtreeNode newPrefixNode = new FPgrowthItemPrefixSubtreeNode(itemSet[place], support, ref.node);
        FPtreeNode newFPtreeNode = new FPtreeNode(newPrefixNode);
        this.addRefToFPgrowthHeaderTable(itemSet[place], newPrefixNode, headerRef);
        FPtreeNode.access$002(ref, this.reallocFPtreeChildRefs(ref.childRefs, newFPtreeNode));
        this.addRestOfitemSet(ref.childRefs[this.tempIndex], newPrefixNode, place + 1, itemSet, support, headerRef);
    }

    private void addRestOfitemSet(FPtreeNode ref, FPgrowthItemPrefixSubtreeNode backRef, int place, short[] itemSet, int support, FPgrowthHeaderTable[] headerRef) {
        if (place < itemSet.length) {
            FPgrowthItemPrefixSubtreeNode newPrefixNode = new FPgrowthItemPrefixSubtreeNode(itemSet[place], support, backRef);
            FPtreeNode newFPtreeNode = new FPtreeNode(newPrefixNode);
            this.addRefToFPgrowthHeaderTable(itemSet[place], newPrefixNode, headerRef);
            FPtreeNode.access$002(ref, this.reallocFPtreeChildRefs(ref.childRefs, newFPtreeNode));
            this.addRestOfitemSet(ref.childRefs[this.tempIndex], newPrefixNode, place + 1, itemSet, support, headerRef);
        }
    }

    private void addRefToFPgrowthHeaderTable(short columnNumber, FPgrowthItemPrefixSubtreeNode newNode, FPgrowthHeaderTable[] headerRef) {
        for (int index = 1; index < headerRef.length; ++index) {
            if (columnNumber != headerRef[index].itemName) continue;
            FPgrowthItemPrefixSubtreeNode tempRef = headerRef[index].nodeLink;
            headerRef[index].nodeLink = newNode;
            newNode.nodeLink = tempRef;
            break;
        }
    }

    public void startMining() {
        this.startMining(this.headerTable, null);
        this.generateARs();
    }

    private void startMining(FPgrowthHeaderTable[] tableRef, short[] itemSetSofar) {
        int headerTableEnd = tableRef.length - 1;
        Object countArray = null;
        Object localHeaderTable = null;
        for (int index = headerTableEnd; index >= 1; --index) {
            if (tableRef[index].nodeLink == null) continue;
            this.startMining(tableRef[index].nodeLink, tableRef[index].itemName, itemSetSofar);
        }
    }

    protected void startMining(FPgrowthItemPrefixSubtreeNode nodeLink, short itemName, short[] itemSetSofar) {
        FPgrowthColumnCounts[] countArray;
        FPgrowthHeaderTable[] localHeaderTable;
        int support = this.genSupHeadTabItem(nodeLink);
        short[] newCodeSofar = this.realloc2(itemSetSofar, itemName);
        this.addToTtree(newCodeSofar, support);
        startTempSets = null;
        this.generateAncestorCodes(nodeLink);
        if (startTempSets != null && (localHeaderTable = this.createLocalHeaderTable(countArray = this.countFPgrowthSingles())) != null) {
            this.pruneAncestorCodes(countArray);
            FPtreeNode localRoot = this.generateLocalFPtree(localHeaderTable);
            this.startMining(localHeaderTable, newCodeSofar);
        }
    }

    private int genSupHeadTabItem(FPgrowthItemPrefixSubtreeNode nodeLink) {
        int counter = 0;
        while (nodeLink != null) {
            counter += nodeLink.itemCount;
            ++this.numUpdates;
            nodeLink = nodeLink.nodeLink;
        }
        return counter;
    }

    private void generateAncestorCodes(FPgrowthItemPrefixSubtreeNode ref) {
        short[] ancestorCode = null;
        while (ref != null) {
            int support = ref.itemCount;
            ancestorCode = this.getAncestorCode(ref.parentRef);
            if (ancestorCode != null) {
                startTempSets = new FPgrowthSupportedSets(ancestorCode, support, startTempSets);
            }
            ref = ref.nodeLink;
        }
    }

    private short[] getAncestorCode(FPgrowthItemPrefixSubtreeNode ref) {
        short[] itemSet = null;
        if (ref == null) {
            return null;
        }
        while (ref != null) {
            itemSet = this.realloc2(itemSet, ref.itemName);
            ref = ref.parentRef;
        }
        return itemSet;
    }

    private void pruneAncestorCodes(FPgrowthColumnCounts[] countArray) {
        FPgrowthSupportedSets ref = startTempSets;
        while (ref != null) {
            for (int index = 0; index < ref.itemSet.length; ++index) {
                if (!((double)countArray[ref.itemSet[index]].support < this.minSupport)) continue;
                FPgrowthSupportedSets.access$802(ref, this.removeElementN(ref.itemSet, index));
            }
            ref = ref.nodeLink;
        }
    }

    private FPgrowthColumnCounts[] countFPgrowthSingles() {
        int index;
        short place = 0;
        FPgrowthSupportedSets nodeLink = startTempSets;
        FPgrowthColumnCounts[] countArray = new FPgrowthColumnCounts[this.numOneItemSets + 1];
        for (index = 1; index < this.numOneItemSets + 1; ++index) {
            countArray[index] = new FPgrowthColumnCounts(index);
        }
        while (nodeLink != null) {
            for (index = 0; index < nodeLink.itemSet.length; ++index) {
                place = nodeLink.itemSet[index];
                countArray[place].support = countArray[place].support + nodeLink.support;
                ++this.numUpdates;
            }
            nodeLink = nodeLink.nodeLink;
        }
        return countArray;
    }

    private FPgrowthHeaderTable[] createLocalHeaderTable(FPgrowthColumnCounts[] countArray) {
        FPgrowthHeaderTable[] localHeaderTable = this.localHeadTabUnordered(countArray);
        return localHeaderTable;
    }

    private FPgrowthHeaderTable[] localHeadTabUnordered(FPgrowthColumnCounts[] countArray) {
        int counter = 1;
        for (int index = 1; index < countArray.length; ++index) {
            if (!((double)countArray[index].support >= this.minSupport)) continue;
            ++counter;
        }
        if (counter == 1) {
            return null;
        }
        FPgrowthHeaderTable[] localHeaderTable = new FPgrowthHeaderTable[counter];
        int place = 1;
        for (int index = 1; index < countArray.length; ++index) {
            if (!((double)countArray[index].support >= this.minSupport)) continue;
            localHeaderTable[place] = new FPgrowthHeaderTable(countArray[index].columnNum);
            ++place;
        }
        return localHeaderTable;
    }

    private FPtreeNode generateLocalFPtree(FPgrowthHeaderTable[] tableRef) {
        FPgrowthSupportedSets ref = startTempSets;
        FPtreeNode localRoot = new FPtreeNode();
        while (ref != null) {
            if (ref.itemSet != null) {
                this.addToFPtree(localRoot, 0, ref.itemSet, ref.support, tableRef);
            }
            ref = ref.nodeLink;
        }
        return localRoot;
    }

    private FPtreeNode[] reallocFPtreeChildRefs(FPtreeNode[] oldArray, FPtreeNode newNode) {
        if (oldArray == null) {
            FPtreeNode[] newArray = new FPtreeNode[]{newNode};
            this.tempIndex = 0;
            return newArray;
        }
        int oldArrayLength = oldArray.length;
        FPtreeNode[] newArray = new FPtreeNode[oldArrayLength + 1];
        for (int index1 = 0; index1 < oldArrayLength; ++index1) {
            if (newNode.node.itemName < oldArray[index1].node.itemName) {
                newArray[index1] = newNode;
                for (int index2 = index1; index2 < oldArrayLength; ++index2) {
                    newArray[index2 + 1] = oldArray[index2];
                }
                this.tempIndex = index1;
                return newArray;
            }
            newArray[index1] = oldArray[index1];
        }
        newArray[oldArrayLength] = newNode;
        this.tempIndex = oldArrayLength;
        return newArray;
    }

    private class FPgrowthColumnCounts {
        private short columnNum;
        private int support = 0;

        private FPgrowthColumnCounts(int column) {
            this.columnNum = (short)column;
        }

        private FPgrowthColumnCounts(int column, int sup) {
            this.columnNum = (short)column;
            this.support = sup;
        }
    }

    private class FPgrowthSupportedSets {
        private short[] itemSet = null;
        private int support;
        private FPgrowthSupportedSets nodeLink = null;

        private FPgrowthSupportedSets(short[] newitemSet, int newSupport, FPgrowthSupportedSets newNodeLink) {
            this.itemSet = newitemSet;
            this.support = newSupport;
            this.nodeLink = newNodeLink;
        }

        static /* synthetic */ short[] access$802(FPgrowthSupportedSets x0, short[] x1) {
            x0.itemSet = x1;
            return x1;
        }
    }

    protected class FPgrowthHeaderTable {
        protected short itemName;
        protected FPgrowthItemPrefixSubtreeNode nodeLink = null;

        protected FPgrowthHeaderTable(short columnNum) {
            this.itemName = columnNum;
        }
    }

    private class FPgrowthItemPrefixSubtreeNode {
        private short itemName;
        private int itemCount;
        private FPgrowthItemPrefixSubtreeNode parentRef = null;
        private FPgrowthItemPrefixSubtreeNode nodeLink = null;

        private FPgrowthItemPrefixSubtreeNode() {
        }

        private FPgrowthItemPrefixSubtreeNode(short name, int support, FPgrowthItemPrefixSubtreeNode backRef) {
            this.itemName = name;
            this.itemCount = support;
            this.parentRef = backRef;
        }
    }

    protected class FPtreeNode {
        private FPgrowthItemPrefixSubtreeNode node = null;
        private FPtreeNode[] childRefs = null;

        protected FPtreeNode() {
        }

        protected FPtreeNode(FPgrowthItemPrefixSubtreeNode newNode) {
            this.node = newNode;
        }

        static /* synthetic */ FPtreeNode[] access$002(FPtreeNode x0, FPtreeNode[] x1) {
            x0.childRefs = x1;
            return x1;
        }
    }
}

