/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.mutators.structural;

import java.util.ArrayList;
import java.util.Hashtable;
import keel.Algorithms.Neural_Networks.NNEP_Common.NeuralNetIndividual;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.NeuralNetMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.structural.ExpNeuronStructuralMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.structural.INeuronStructuralMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.structural.LinearNeuronStructuralMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.mutators.structural.SigmNeuronStructuralMutator;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ExpNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuralNet;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.InputNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinearNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.Link;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedNeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.SigmNeuron;
import net.sf.jclec.IConfigure;
import net.sf.jclec.fitness.SimpleValueFitness;
import net.sf.jclec.util.range.Interval;
import org.apache.commons.configuration.Configuration;

public class StructuralMutator<I extends NeuralNetIndividual>
extends NeuralNetMutator<I>
implements IConfigure {
    private static final long serialVersionUID = -7550526084120396151L;
    protected double temperExponent;
    protected int minNeuronsAdd;
    protected int maxNeuronsAdd;
    protected int minNeuronsDel;
    protected int maxNeuronsDel;
    protected int minLinksAdd;
    protected int maxLinksAdd;
    protected int minLinksDel;
    protected int maxLinksDel;
    protected double significativeWeigth;
    protected boolean nOfLinksRelative;
    protected int hiddenLinksPercentage;
    protected int outputLinksPercentage;
    protected Hashtable<String, INeuronStructuralMutator> neuronStructuralMutators = new Hashtable();

    public double getTemperExponent() {
        return this.temperExponent;
    }

    public void setTemperExponent(double temperExponent) {
        this.temperExponent = temperExponent;
    }

    public double getSignificativeWeigth() {
        return this.significativeWeigth;
    }

    public void setSignificativeWeigth(double significativeWeigth) {
        this.significativeWeigth = significativeWeigth;
    }

    public int getMaxLinksAdd() {
        return this.maxLinksAdd;
    }

    public void setMaxLinksAdd(int maxLinksAdd) {
        this.maxLinksAdd = maxLinksAdd;
    }

    public int getMaxLinksDel() {
        return this.maxLinksDel;
    }

    public void setMaxLinksDel(int maxLinksDel) {
        this.maxLinksDel = maxLinksDel;
    }

    public int getMaxNeuronsAdd() {
        return this.maxNeuronsAdd;
    }

    public void setMaxNeuronsAdd(int maxNeuronsAdd) {
        this.maxNeuronsAdd = maxNeuronsAdd;
    }

    public int getMaxNeuronsDel() {
        return this.maxNeuronsDel;
    }

    public void setMaxNeuronsDel(int maxNeuronsDel) {
        this.maxNeuronsDel = maxNeuronsDel;
    }

    public int getMinLinksAdd() {
        return this.minLinksAdd;
    }

    public void setMinLinksAdd(int minLinksAdd) {
        this.minLinksAdd = minLinksAdd;
    }

    public int getMinLinksDel() {
        return this.minLinksDel;
    }

    public void setMinLinksDel(int minLinksDel) {
        this.minLinksDel = minLinksDel;
    }

    public int getMinNeuronsAdd() {
        return this.minNeuronsAdd;
    }

    public void setMinNeuronsAdd(int minNeuronsAdd) {
        this.minNeuronsAdd = minNeuronsAdd;
    }

    public int getMinNeuronsDel() {
        return this.minNeuronsDel;
    }

    public void setMinNeuronsDel(int minNeuronsDel) {
        this.minNeuronsDel = minNeuronsDel;
    }

    @Override
    public void mutateNext() {
        NeuralNetIndividual nnind = (NeuralNetIndividual)this.parentsBuffer.get(this.parentsCounter);
        INeuralNet neuralNet = (INeuralNet)nnind.getGenotype();
        double fitness = ((SimpleValueFitness)nnind.getFitness()).getValue();
        double temper = Math.pow(1.0 - fitness, this.temperExponent);
        boolean mutated = false;
        boolean initial = true;
        int mutation = 0;
        while (!mutated) {
            int j;
            int j2;
            int i;
            int i2;
            if (initial && this.randgen.raw() < temper || !initial && mutation == 1) {
                int neuronsToAdd = (int)((double)this.minNeuronsAdd + this.randgen.raw() * temper * (double)(this.maxNeuronsAdd - this.minNeuronsAdd));
                for (i2 = 0; i2 < neuronsToAdd; ++i2) {
                    if (this.ANMutation(neuralNet)) {
                        mutated = true;
                        continue;
                    }
                    i2 = neuronsToAdd;
                }
            }
            if (initial && this.randgen.raw() < temper || !initial && mutation == 2) {
                int neuronsToDel = (int)((double)this.minNeuronsDel + this.randgen.raw() * temper * (double)(this.maxNeuronsDel - this.minNeuronsDel));
                for (i2 = 0; i2 < neuronsToDel; ++i2) {
                    if (this.DNMutation(neuralNet)) {
                        mutated = true;
                        continue;
                    }
                    i2 = neuronsToDel;
                }
            }
            if (initial && this.randgen.raw() < temper || !initial && mutation == 3) {
                int linksToAdd;
                if (this.nOfLinksRelative) {
                    for (i = 0; i < neuralNet.getNofhlayers(); ++i) {
                        int linksToAdd2 = this.randgen.choose(1, (int)((double)this.hiddenLinksPercentage / 100.0 * (double)neuralNet.getHlayer(i).getNoflinks() + 1.0));
                        for (j2 = 0; j2 < linksToAdd2; ++j2) {
                            if (this.ALMutation(neuralNet, i)) {
                                mutated = true;
                                continue;
                            }
                            j2 = linksToAdd2;
                        }
                    }
                    linksToAdd = this.randgen.choose(1, (int)((double)this.outputLinksPercentage / 100.0 * (double)neuralNet.getOutputLayer().getNoflinks() + 1.0));
                    for (j = 0; j < linksToAdd; ++j) {
                        if (this.ALMutation(neuralNet, neuralNet.getNofhlayers())) {
                            mutated = true;
                            continue;
                        }
                        j = linksToAdd;
                    }
                } else {
                    linksToAdd = (int)((double)this.minLinksAdd + this.randgen.raw() * temper * (double)(this.maxLinksAdd - this.minLinksAdd));
                    for (i2 = 0; i2 < linksToAdd; ++i2) {
                        if (this.ALMutation(neuralNet, -1)) {
                            mutated = true;
                            continue;
                        }
                        i2 = linksToAdd;
                    }
                }
            }
            if (initial && this.randgen.raw() < temper || !initial && mutation == 4) {
                int linksToDel;
                if (this.nOfLinksRelative) {
                    for (i = 0; i < neuralNet.getNofhlayers(); ++i) {
                        int linksToDel2 = this.randgen.choose(1, (int)((double)this.hiddenLinksPercentage / 100.0 * (double)neuralNet.getHlayer(i).getNoflinks() + 1.0));
                        for (j2 = 0; j2 < linksToDel2; ++j2) {
                            if (this.DLMutation(neuralNet, i)) {
                                mutated = true;
                                continue;
                            }
                            j2 = linksToDel2;
                        }
                    }
                    linksToDel = this.randgen.choose(1, (int)((double)this.outputLinksPercentage / 100.0 * (double)neuralNet.getOutputLayer().getNoflinks() + 1.0));
                    for (j = 0; j < linksToDel; ++j) {
                        if (this.DLMutation(neuralNet, neuralNet.getNofhlayers())) {
                            mutated = true;
                            continue;
                        }
                        j = linksToDel;
                    }
                } else {
                    linksToDel = (int)((double)this.minLinksDel + this.randgen.raw() * temper * (double)(this.maxLinksDel - this.minLinksDel));
                    for (i2 = 0; i2 < linksToDel; ++i2) {
                        if (this.DLMutation(neuralNet, -1)) {
                            mutated = true;
                            continue;
                        }
                        i2 = linksToDel;
                    }
                }
            }
            if ((initial && this.randgen.raw() < temper || !initial && mutation == 5) && this.UNMutation(neuralNet)) {
                mutated = true;
            }
            if (mutated) continue;
            initial = false;
            mutation = this.randgen.choose(1, 6);
        }
        nnind.setFitness(null);
        ((INeuralNet)nnind.getGenotype()).keepRelevantLinks(this.significativeWeigth);
        this.sonsBuffer.add(nnind);
    }

    @Override
    public void configure(Configuration settings) {
        this.temperExponent = settings.getDouble("temperature-exponent[@value]", 1.0);
        this.significativeWeigth = settings.getDouble("significative-weigth[@value]", 1.0E-7);
        this.minNeuronsAdd = settings.getInt("neurons-ranges.added[@min]", 1);
        this.maxNeuronsAdd = settings.getInt("neurons-ranges.added[@max]", 2);
        this.minNeuronsDel = settings.getInt("neurons-ranges.deleted[@min]", 1);
        this.maxNeuronsDel = settings.getInt("neurons-ranges.deleted[@max]", 2);
        this.nOfLinksRelative = settings.getBoolean("links-ranges[@relative]", false);
        if (!this.nOfLinksRelative) {
            this.minLinksAdd = settings.getInt("links-ranges.added[@min]", 1);
            this.maxLinksAdd = settings.getInt("links-ranges.added[@max]", 6);
            this.minLinksDel = settings.getInt("links-ranges.deleted[@min]", 1);
            this.maxLinksDel = settings.getInt("links-ranges.deleted[@max]", 6);
        } else {
            this.hiddenLinksPercentage = settings.getInt("links-ranges.percentages[@hidden]", 30);
            this.outputLinksPercentage = settings.getInt("links-ranges.percentages[@output]", 5);
        }
    }

    private INeuronStructuralMutator addNeuronStructuralMutator(LinkedNeuron neuron) {
        if (neuron instanceof SigmNeuron) {
            SigmNeuronStructuralMutator neuronStructuralMutator = new SigmNeuronStructuralMutator();
            neuronStructuralMutator.setRandgen(this.randgen);
            neuronStructuralMutator.setSignificativeWeigth(this.significativeWeigth);
            this.neuronStructuralMutators.put(neuron.getClass().getCanonicalName(), neuronStructuralMutator);
            return neuronStructuralMutator;
        }
        if (neuron instanceof LinearNeuron) {
            LinearNeuronStructuralMutator neuronStructuralMutator = new LinearNeuronStructuralMutator();
            neuronStructuralMutator.setRandgen(this.randgen);
            neuronStructuralMutator.setSignificativeWeigth(this.significativeWeigth);
            this.neuronStructuralMutators.put(neuron.getClass().getCanonicalName(), neuronStructuralMutator);
            return neuronStructuralMutator;
        }
        if (neuron instanceof ExpNeuron) {
            ExpNeuronStructuralMutator neuronStructuralMutator = new ExpNeuronStructuralMutator();
            neuronStructuralMutator.setRandgen(this.randgen);
            neuronStructuralMutator.setSignificativeWeigth(this.significativeWeigth);
            this.neuronStructuralMutators.put(neuron.getClass().getCanonicalName(), neuronStructuralMutator);
            return neuronStructuralMutator;
        }
        return null;
    }

    private boolean ANMutation(INeuralNet neuralNet) {
        if (neuralNet.neuronsFull()) {
            return false;
        }
        int noflayer = 0;
        if (neuralNet.getNofhlayers() > 1) {
            while (neuralNet.getHlayer(noflayer = this.randgen.choose(0, neuralNet.getNofhlayers())).neuronsFull()) {
            }
        }
        LinkedLayer layer = neuralNet.getHlayer(noflayer);
        ILayer<InputNeuron> previousLayer = noflayer == 0 ? neuralNet.getInputLayer() : neuralNet.getHlayer(noflayer - 1);
        LinkedLayer nextLayer = noflayer == neuralNet.getNofhlayers() - 1 ? neuralNet.getOutputLayer() : neuralNet.getHlayer(noflayer + 1);
        LinkedNeuron newNeuron = layer.obtainNewNeuron();
        Interval weightRange = this.species.getHiddenLayerWeightRange(noflayer, 0);
        newNeuron.setWeightRange(weightRange);
        INeuronStructuralMutator neuronStructuralMutator = this.neuronStructuralMutators.get(newNeuron.getClass().getCanonicalName());
        if (neuronStructuralMutator == null) {
            neuronStructuralMutator = this.addNeuronStructuralMutator(newNeuron);
        }
        if (neuronStructuralMutator != null) {
            neuronStructuralMutator.addNeuron(newNeuron, layer, previousLayer, nextLayer);
            return true;
        }
        return false;
    }

    private boolean DNMutation(INeuralNet neuralNet) {
        LinkedLayer layer;
        if (neuralNet.neuronsEmpty()) {
            return false;
        }
        int noflayer = 0;
        if (neuralNet.getNofhlayers() > 1) {
            while (neuralNet.getHlayer(noflayer = this.randgen.choose(0, neuralNet.getNofhlayers())).neuronsEmpty()) {
            }
        }
        if ((layer = neuralNet.getHlayer(noflayer)).getNofneurons() == layer.getMinnofneurons()) {
            return false;
        }
        int selectedNeuron = this.randgen.choose(0, layer.getNofneurons());
        LinkedLayer nextLayer = noflayer == neuralNet.getNofhlayers() - 1 ? neuralNet.getOutputLayer() : neuralNet.getHlayer(noflayer + 1);
        for (int i = 0; i < nextLayer.getNofneurons(); ++i) {
            LinkedNeuron nextNeuron = nextLayer.getNeuron(i);
            Link[] nextLinks = nextNeuron.getLinks();
            if (nextLinks[selectedNeuron].isBroken() || (nextNeuron.isBiased() || nextNeuron.getNoflinks() > 1) && (!nextNeuron.isBiased() || nextNeuron.getNoflinks() > 2)) continue;
            return false;
        }
        INeuronStructuralMutator neuronStructuralMutator = this.neuronStructuralMutators.get(layer.getNeuron(selectedNeuron).getClass().getCanonicalName());
        if (neuronStructuralMutator == null) {
            neuronStructuralMutator = this.addNeuronStructuralMutator(layer.getNeuron(selectedNeuron));
        }
        if (neuronStructuralMutator != null) {
            neuronStructuralMutator.removeNeuron(layer, nextLayer, selectedNeuron);
            return true;
        }
        return false;
    }

    private boolean ALMutation(INeuralNet neuralNet, int selectedLayer) {
        int noflayer = 0;
        noflayer = selectedLayer != -1 ? selectedLayer : (neuralNet.getOutputLayer().getNofneurons() == 1 ? this.randgen.choose(0, neuralNet.getNofhlayers()) : this.randgen.choose(0, neuralNet.getNofhlayers() + 1));
        ILayer<InputNeuron> previousLayer = null;
        previousLayer = noflayer != 0 ? neuralNet.getHlayer(noflayer - 1) : neuralNet.getInputLayer();
        LinkedLayer layer = noflayer != neuralNet.getNofhlayers() ? neuralNet.getHlayer(noflayer) : neuralNet.getOutputLayer();
        int selectedNeuron = this.randgen.choose(0, layer.getNofneurons());
        int selectedOrigin = this.randgen.choose(0, previousLayer.getNofneurons());
        LinkedNeuron neuron = layer.getNeuron(selectedNeuron);
        INeuronStructuralMutator neuronStructuralMutator = this.neuronStructuralMutators.get(neuron.getClass().getCanonicalName());
        if (neuronStructuralMutator == null) {
            neuronStructuralMutator = this.addNeuronStructuralMutator(neuron);
        }
        if (neuronStructuralMutator != null) {
            return neuronStructuralMutator.addLink(neuron, layer, previousLayer, selectedNeuron, selectedOrigin);
        }
        return false;
    }

    private boolean DLMutation(INeuralNet neuralNet, int selectedLayer) {
        INeuronStructuralMutator neuronStructuralMutator;
        int noflayer = 0;
        noflayer = selectedLayer != -1 ? selectedLayer : (neuralNet.getOutputLayer().getNofneurons() == 1 ? this.randgen.choose(0, neuralNet.getNofhlayers()) : this.randgen.choose(0, neuralNet.getNofhlayers() + 1));
        LinkedLayer layer = noflayer != neuralNet.getNofhlayers() ? neuralNet.getHlayer(noflayer) : neuralNet.getOutputLayer();
        int selectedNeuron = this.randgen.choose(0, layer.getNofneurons());
        LinkedNeuron neuron = layer.getNeuron(selectedNeuron);
        ILayer<InputNeuron> previousLayer = null;
        previousLayer = noflayer != 0 ? neuralNet.getHlayer(noflayer - 1) : neuralNet.getInputLayer();
        int selectedOrigin = this.randgen.choose(0, previousLayer.getNofneurons());
        if (!neuron.isBiased() && neuron.getNoflinks() <= 1 || neuron.isBiased() && neuron.getNoflinks() <= 2) {
            return false;
        }
        if (noflayer != 0) {
            int outputLinks = 0;
            for (int i = 0; i < layer.getNofneurons(); ++i) {
                LinkedNeuron layerNeuron = layer.getNeuron(i);
                if (layerNeuron.getLinks()[selectedOrigin].isBroken()) continue;
                ++outputLinks;
            }
            if (outputLinks == 1) {
                return false;
            }
        }
        if ((neuronStructuralMutator = this.neuronStructuralMutators.get(neuron.getClass().getCanonicalName())) == null) {
            neuronStructuralMutator = this.addNeuronStructuralMutator(neuron);
        }
        if (neuronStructuralMutator != null) {
            return neuronStructuralMutator.removeLink(neuron, selectedOrigin);
        }
        return false;
    }

    private boolean UNMutation(INeuralNet neuralNet) {
        int secondNeuron;
        int firstNeuron;
        if (neuralNet.getNofhneurons() < 2) {
            return false;
        }
        int noflayer = 0;
        if (neuralNet.getNofhlayers() > 1) {
            int i = 0;
            while (i < neuralNet.getNofhlayers() && neuralNet.getHlayer(noflayer).getNofneurons() == neuralNet.getHlayer(noflayer).getMinnofneurons()) {
                noflayer = i++;
            }
        } else if (neuralNet.getHlayer(noflayer).getNofneurons() == neuralNet.getHlayer(noflayer).getMinnofneurons()) {
            return false;
        }
        LinkedLayer layer = neuralNet.getHlayer(noflayer);
        boolean exit = true;
        ArrayList neuronTypes = new ArrayList();
        for (int i = 0; i < layer.getNofneurons(); ++i) {
            Class<?> neuronType = layer.getNeuron(i).getClass();
            if (neuronTypes.contains(neuronType)) {
                exit = false;
                i = layer.getNofneurons();
                continue;
            }
            neuronTypes.add(neuronType);
        }
        if (exit) {
            return false;
        }
        while ((firstNeuron = this.randgen.choose(0, layer.getNofneurons())) == (secondNeuron = this.randgen.choose(0, layer.getNofneurons())) || !layer.getNeuron(firstNeuron).getClass().equals(layer.getNeuron(secondNeuron).getClass())) {
        }
        LinkedLayer nextLayer = noflayer == neuralNet.getNofhlayers() - 1 ? neuralNet.getOutputLayer() : neuralNet.getHlayer(noflayer + 1);
        LinkedNeuron firstLinkedNeuron = layer.getNeuron(firstNeuron);
        LinkedNeuron secondLinkedNeuron = layer.getNeuron(secondNeuron);
        INeuronStructuralMutator neuronStructuralMutator = this.neuronStructuralMutators.get(firstLinkedNeuron.getClass().getCanonicalName());
        if (neuronStructuralMutator == null) {
            neuronStructuralMutator = this.addNeuronStructuralMutator(firstLinkedNeuron);
        }
        if (neuronStructuralMutator != null) {
            neuronStructuralMutator.unitNeuronsWeights(firstLinkedNeuron, secondLinkedNeuron, layer, nextLayer, firstNeuron, secondNeuron);
            neuronStructuralMutator.removeNeuron(layer, nextLayer, secondNeuron);
            return true;
        }
        return false;
    }
}

