/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.Serializable;
import weka.core.Utils;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.NotPersistable;

public abstract class WekaAlgorithmWrapper
extends BaseStep
implements Serializable {
    private static final long serialVersionUID = -1013404060247467085L;
    protected String m_iconPath;
    protected String m_defaultPackageIconPath;
    protected String m_defaultIconPath;
    protected Object m_wrappedAlgorithm;

    @Override
    public String globalInfo() {
        if (this.getWrappedAlgorithm() != null) {
            return Utils.getGlobalInfo(this.getWrappedAlgorithm(), false);
        }
        return super.globalInfo();
    }

    @NotPersistable
    @ProgrammaticProperty
    public Object getWrappedAlgorithm() {
        return this.m_wrappedAlgorithm;
    }

    public void setWrappedAlgorithm(Object algo) {
        this.m_wrappedAlgorithm = algo;
        String className = algo.getClass().getCanonicalName();
        String name = className.substring(className.lastIndexOf(".") + 1);
        String packageName = className.substring(0, className.lastIndexOf("."));
        KFStep stepA = this.getClass().getAnnotation(KFStep.class);
        if (this.getName() == null || this.getName().length() == 0 || stepA != null && this.getName().equals(stepA.name())) {
            this.setName(name);
        }
        this.m_defaultPackageIconPath = "weka/gui/knowledgeflow/icons/" + packageName + ".gif";
        this.m_iconPath = "weka/gui/knowledgeflow/icons/" + name + ".gif";
    }

    public String getIconPath() {
        return this.m_iconPath;
    }

    public String getDefaultPackageLevelIconPath() {
        return this.m_defaultPackageIconPath;
    }

    public String getDefaultIconPath() {
        return this.m_defaultIconPath;
    }

    public abstract Class getWrappedAlgorithmClass();
}

