/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.HashSet;

public class Itemset
extends Association {
    private int[] items;
    private int currentItem;

    public Itemset() {
        this.currentItem = -1;
        this.precision = 1.0;
    }

    public Itemset(int n) {
        this.items = new int[1];
        this.items[0] = n;
        this.currentItem = n;
        this.precision = 1.0;
    }

    public Itemset(int[] nArray) {
        this.items = nArray;
        Arrays.sort(this.items);
        this.currentItem = -1;
        this.precision = nArray.length == 1 ? 1.0 : -1.0;
    }

    public Itemset(int[] nArray, double d) {
        this(nArray);
        this.precision = d;
    }

    public Itemset(Itemset itemset, int n) {
        if (itemset.size() == 0) {
            this.items = new int[1];
            this.items[0] = n;
            this.precision = 1.0;
        } else {
            this.items = new int[itemset.size() + 1];
            for (int i = 0; i < itemset.size(); ++i) {
                this.items[i] = itemset.get(i);
            }
            this.items[this.items.length - 1] = n;
            Arrays.sort(this.items);
            this.precision = -1.0;
        }
        this.currentItem = n;
    }

    public Itemset(Itemset itemset, int n, double d) {
        this(itemset, n);
        this.precision = d;
    }

    public boolean isEmpty() {
        return this.items == null;
    }

    public int size() {
        if (this.items == null) {
            return 0;
        }
        return this.items.length;
    }

    public int get(int n) {
        return this.items[n];
    }

    public int[] getItems() {
        return this.items;
    }

    public int getCurrentItem() {
        return this.currentItem;
    }

    public boolean contains(int n) {
        if (this.items == null) {
            return false;
        }
        return Arrays.binarySearch(this.items, n) >= 0;
    }

    public boolean contains(Itemset itemset) {
        int[] nArray = itemset.getItems();
        if (nArray.length > this.items.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (this.contains(nArray[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.items == null || this.items.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.items.length; ++i) {
            stringBuffer.append(this.items[i] + ", ");
        }
        return "{" + stringBuffer.substring(0, stringBuffer.length() - 2) + "}";
    }

    public boolean equals(Object object) {
        return Arrays.equals(this.items, ((Itemset)object).getItems());
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.items.length; ++i) {
            n = n * 31 + this.items[i];
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{1, 18, 3, 44, 5};
        int[] nArray2 = new int[]{1, 18, 3, 44};
        Itemset itemset = new Itemset(nArray);
        Itemset itemset2 = new Itemset(itemset, 11);
        Itemset itemset3 = new Itemset(nArray2);
        Itemset itemset4 = new Itemset(itemset3, 5);
        System.out.println("set1: " + itemset);
        System.out.println("set2: " + itemset2);
        System.out.println("set3: " + itemset4);
        System.out.println("set4: " + itemset3);
        System.out.println("size of set1: " + itemset.size());
        System.out.println("size of set2: " + itemset2.size());
        System.out.println("set1 contains 11? " + itemset.contains(11));
        System.out.println("set2 contains 11? " + itemset2.contains(11));
        System.out.println("set1 contains set4? " + itemset.contains(itemset3));
        System.out.println("set4 contains set1? " + itemset3.contains(itemset));
        System.out.println("set1 equals set2? " + itemset.contains(itemset2));
        System.out.println("set1 equals set3? " + itemset.contains(itemset4));
        System.out.println("set1 hash code? " + itemset.hashCode());
        System.out.println("set2 hash code? " + itemset2.hashCode());
        System.out.println("set3 hash code? " + itemset4.hashCode());
        HashSet<Itemset> hashSet = new HashSet<Itemset>();
        hashSet.add(itemset);
        System.out.println("contains set1? " + hashSet.contains(itemset));
        System.out.println("contains set2? " + hashSet.contains(itemset2));
        System.out.println("contains set3? " + hashSet.contains(itemset4));
    }
}

