## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = 'center'
)

## ----setup, warning=FALSE, message=FALSE--------------------------------------
# Primary Package #
library(invitroTKstats)
# Data Formatting Packages #
library(tidyverse)
# Data Plotting Package #
library(ggplot2)
library(gridExtra)
library(gridtext)

## ----example clint single, fig.width=5, fig.height=4--------------------------
# load data in 
level2.clint <- invitroTKstats::clint_L2

# keep only the verified data
verified_data_clint <- level2.clint[level2.clint$Verified == "Y", ]

id <- unique(verified_data_clint$DTXSID)[1]
plot_clint(verified_data_clint, id)

## ----example clint multiple, warning=FALSE, fig.width=7, fig.height=7---------
# plot all 3 chemicals in the dataset  
p <- list()
for (id in unique(verified_data_clint$DTXSID)) {
  p[[id]] <- plot_clint(verified_data_clint, id) + 
    theme(legend.title = element_text(size = 7),
          legend.text = element_text(size = 7),
          plot.title = element_text(size= 7))
}
do.call(grid.arrange, p)

## ----example fup_uc single, fig.width=5, fig.height=4-------------------------
# load in data
level2.uc <- invitroTKstats::fup_uc_L2

# keep only the verified data
verified_data_uc <- level2.uc[level2.uc$Verified == "Y", ]

id <- unique(verified_data_uc$DTXSID)[2]
plot_fup_uc(verified_data_uc, id)

## ----example fup_uc, fig.height=7, fig.width=7, warning = FALSE---------------
# plot all three chemicals 
p2 <- list()
for (id in unique(verified_data_uc$DTXSID)) {
  p2[[id]] <- plot_fup_uc(verified_data_uc, id) + 
    theme(legend.title = element_text(size = 7),
          legend.text = element_text(size = 7),
          plot.title = element_text(size= 7))
}

# remove the y-axis labels from all plots
p2 = p2 %>% map(~.x + labs(y=NULL))
# create an universal label
yleft = gridtext::richtext_grob("Mass Spec. Intensity / Fraction Unbound", rot=90)
grid.arrange(grobs=p2, ncol = 2, nrow = 2, left = yleft)

## ----fig.width=5, fig.height=4------------------------------------------------
dtxsid <- unique(verified_data_uc$DTXSID)[2]
p3 <- plot_fup_uc(verified_data_uc, dtxsid)
p3

## ----fig.width=5, fig.height=4------------------------------------------------
p3 <- plot_fup_uc(verified_data_uc, dtxsid) + facet_wrap(~Calibration)
p3

## ----fig.width=7, fig.height=7------------------------------------------------
p4 <- plot_fup_uc(verified_data_uc, dtxsid, compare = "cal")
p5 <- p4 + facet_wrap(~Sample.Type)

grid.arrange(p4, p5)

