/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.Iterator;

public class SelectiveFileLineIterator
implements Iterator<Instance> {
    BufferedReader reader = null;
    int index = -1;
    String currentLine = null;
    boolean hasNextUsed = false;
    String skipRegex;

    public SelectiveFileLineIterator(Reader reader, String skipRegex) {
        this.reader = new BufferedReader(reader);
        this.index = 0;
        this.skipRegex = skipRegex;
    }

    @Override
    public Instance next() {
        if (!this.hasNextUsed) {
            try {
                this.currentLine = this.reader.readLine();
                while (this.currentLine != null && this.currentLine.matches(this.skipRegex)) {
                    this.currentLine = this.reader.readLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hasNextUsed = false;
        }
        URI uri = null;
        try {
            uri = new URI("array:" + this.index++);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Instance(this.currentLine, null, uri, null);
    }

    @Override
    public boolean hasNext() {
        this.hasNextUsed = true;
        try {
            this.currentLine = this.reader.readLine();
            while (this.currentLine != null && this.currentLine.matches(this.skipRegex)) {
                this.currentLine = this.reader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.currentLine != null;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

