/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types.tests;

import cc.mallet.types.IndexedSparseVector;
import cc.mallet.types.SparseVector;
import cc.mallet.types.tests.TestSerializable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestIndexedSparseVector
extends TestCase {
    double[] dbl1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
    double[] dbl2 = new double[]{1.0, 1.5, 2.0, 1.0, 1.0};
    double[] dbl3 = new double[]{2.0, 2.5, 3.0, 4.7, 3.5, 3.6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    int[] idxs = new int[]{3, 5, 7, 13, 15};
    IndexedSparseVector s1 = new IndexedSparseVector(this.idxs, this.dbl1, this.dbl1.length, this.dbl1.length, true, true, true);
    IndexedSparseVector s2 = new IndexedSparseVector(this.idxs, this.dbl2, this.dbl2.length, this.dbl2.length, true, true, true);
    SparseVector d1 = new SparseVector(this.dbl3, true);
    private static int[] idx2 = new int[]{3, 7, 12, 15, 18};

    public TestIndexedSparseVector(String name) {
        super(name);
    }

    public void testLocation() {
        int curidx = 0;
        int max = this.idxs[this.idxs.length - 1];
        for (int idx = 0; idx < max; ++idx) {
            if (idx == this.idxs[curidx]) {
                TestIndexedSparseVector.assertEquals(this.dbl1[curidx], this.s1.value(idx), 1.0E-10);
                ++curidx;
                continue;
            }
            TestIndexedSparseVector.assertEquals(0.0, this.s1.value(idx), 1.0E-10);
        }
        TestIndexedSparseVector.assertEquals(0.0, this.s1.value(max + 1), 1.0E-10);
    }

    private void checkAnswer(IndexedSparseVector actual, double[] ans) {
        TestIndexedSparseVector.assertEquals("Wrong number of locations:", ans.length, actual.numLocations());
        for (int i = 0; i < actual.numLocations(); ++i) {
            TestIndexedSparseVector.assertEquals("Value incorrect at location " + i + ": ", ans[i], actual.valueAtLocation(i), 0.0);
        }
    }

    public void testPlusEquals() {
        IndexedSparseVector s = (IndexedSparseVector)this.s1.cloneMatrix();
        s.plusEqualsSparse(this.s2, 2.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.0, 7.0});
        IndexedSparseVector s2p = new IndexedSparseVector(new int[]{13}, new double[]{0.8});
        s.plusEqualsSparse(s2p, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.8, 7.0});
        IndexedSparseVector s3p = new IndexedSparseVector(new int[]{14}, new double[]{0.8});
        s.plusEqualsSparse(s3p, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.0, 6.8, 7.0});
        IndexedSparseVector s4 = new IndexedSparseVector(new int[]{7, 14, 15}, new double[]{0.2, 0.8, 1.2});
        s.plusEqualsSparse(s4, 1.0);
        this.checkAnswer(s, new double[]{3.0, 5.0, 7.2, 6.8, 8.2});
        IndexedSparseVector s5 = new IndexedSparseVector(new int[]{7}, new double[]{0.2});
        s5.plusEqualsSparse(this.s1);
        for (int i = 0; i < s5.numLocations(); ++i) {
            TestIndexedSparseVector.assertEquals(7, s5.indexAtLocation(i));
            TestIndexedSparseVector.assertEquals(3.2, s5.valueAtLocation(i), 0.0);
        }
        IndexedSparseVector s6 = new IndexedSparseVector(new int[]{7}, new double[]{0.2});
        s6.plusEqualsSparse(this.s1, 3.5);
        for (int i = 0; i < s6.numLocations(); ++i) {
            TestIndexedSparseVector.assertEquals(7, s6.indexAtLocation(i));
            TestIndexedSparseVector.assertEquals(10.7, s6.valueAtLocation(i), 0.0);
        }
    }

    public void testDotProduct() {
        IndexedSparseVector t1 = new IndexedSparseVector(new int[]{7}, new double[]{0.2});
        TestIndexedSparseVector.assertEquals(0.6, t1.dotProduct(this.s1), 1.0E-5);
        TestIndexedSparseVector.assertEquals(0.6, this.s1.dotProduct(t1), 1.0E-5);
        TestIndexedSparseVector.assertEquals(19.0, this.s1.dotProduct(this.s2), 1.0E-5);
        TestIndexedSparseVector.assertEquals(19.0, this.s2.dotProduct(this.s1), 1.0E-5);
        TestIndexedSparseVector.assertEquals(11.9, this.s1.dotProduct(this.d1), 1.0E-5);
        TestIndexedSparseVector.assertEquals(10.1, this.s2.dotProduct(this.d1), 1.0E-5);
    }

    public void testIncrementValue() {
        IndexedSparseVector s = (IndexedSparseVector)this.s1.cloneMatrix();
        s.incrementValue(5, 0.75);
        double[] ans = new double[]{1.0, 2.75, 3.0, 4.0, 5.0};
        for (int i = 0; i < s.numLocations(); ++i) {
            TestIndexedSparseVector.assertTrue(s.valueAtLocation(i) == ans[i]);
        }
    }

    public void testSetValue() {
        IndexedSparseVector s = (IndexedSparseVector)this.s1.cloneMatrix();
        s.setValue(5, 0.3);
        double[] ans = new double[]{1.0, 0.3, 3.0, 4.0, 5.0};
        for (int i = 0; i < s.numLocations(); ++i) {
            TestIndexedSparseVector.assertTrue(s.valueAtLocation(i) == ans[i]);
        }
    }

    public void testBinaryVector() {
        IndexedSparseVector binary1 = new IndexedSparseVector(this.idxs, null, this.idxs.length, this.idxs.length, false, false, false);
        IndexedSparseVector binary2 = new IndexedSparseVector(idx2, null, idx2.length, idx2.length, false, false, false);
        TestIndexedSparseVector.assertEquals(3.0, binary1.dotProduct(binary2), 1.0E-4);
        TestIndexedSparseVector.assertEquals(3.0, binary2.dotProduct(binary1), 1.0E-4);
        TestIndexedSparseVector.assertEquals(15.0, binary1.dotProduct(this.s1), 1.0E-4);
        TestIndexedSparseVector.assertEquals(15.0, this.s1.dotProduct(binary1), 1.0E-4);
        TestIndexedSparseVector.assertEquals(9.0, binary2.dotProduct(this.s1), 1.0E-4);
        TestIndexedSparseVector.assertEquals(9.0, this.s1.dotProduct(binary2), 1.0E-4);
        IndexedSparseVector dblVec = (IndexedSparseVector)this.s1.cloneMatrix();
        dblVec.plusEqualsSparse(binary1);
        this.checkAnswer(dblVec, new double[]{2.0, 3.0, 4.0, 5.0, 6.0});
        IndexedSparseVector dblVec2 = (IndexedSparseVector)this.s1.cloneMatrix();
        dblVec2.plusEqualsSparse(binary2);
        this.checkAnswer(dblVec2, new double[]{2.0, 2.0, 4.0, 4.0, 6.0});
    }

    public void testCloneMatrixZeroed() {
        IndexedSparseVector s = (IndexedSparseVector)this.s1.cloneMatrixZeroed();
        for (int i = 0; i < s.numLocations(); ++i) {
            TestIndexedSparseVector.assertTrue(s.valueAtLocation(i) == 0.0);
            TestIndexedSparseVector.assertTrue(s.indexAtLocation(i) == this.idxs[i]);
        }
    }

    public void testEmptyLocations() {
        IndexedSparseVector s = new IndexedSparseVector(new int[0], new double[0]);
        TestIndexedSparseVector.assertEquals(0.0, s.value(38), 1.0E-10);
        TestIndexedSparseVector.assertEquals(0.0, s.dotProduct(this.s1), 1.0E-10);
    }

    public void testSerializable() throws IOException, ClassNotFoundException {
        IndexedSparseVector s = (IndexedSparseVector)this.s1.cloneMatrix();
        IndexedSparseVector sPrime = (IndexedSparseVector)TestSerializable.cloneViaSerialization(s);
        TestIndexedSparseVector.assertEquals(s.numLocations(), sPrime.numLocations());
        TestIndexedSparseVector.assertTrue(Arrays.equals(s.getIndices(), sPrime.getIndices()));
        TestIndexedSparseVector.assertTrue(Arrays.equals(s.getValues(), sPrime.getValues()));
    }

    public void testSerializable2() throws IOException, ClassNotFoundException {
        SparseVector[][] vecs = new SparseVector[][]{{(SparseVector)this.s1.cloneMatrix(), (SparseVector)this.s1.cloneMatrix()}, {(SparseVector)this.s1.cloneMatrix()}};
        SparseVector[][] vecsPrime = (SparseVector[][])TestSerializable.cloneViaSerialization((Serializable)vecs);
        TestIndexedSparseVector.assertEquals(vecs.length, vecsPrime.length);
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestIndexedSparseVector.class);
    }

    @Override
    protected void setUp() {
    }

    public static void main(String[] args) {
        TestRunner.run(TestIndexedSparseVector.suite());
    }
}

