/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcgregor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregorChecks;
import org.openscience.cdk.smsd.algorithm.mcgregor.McgregorHelper;
import org.openscience.cdk.smsd.algorithm.mcgregor.QueryProcessor;
import org.openscience.cdk.smsd.algorithm.mcgregor.TargetProcessor;
import org.openscience.cdk.smsd.helper.BinaryTree;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public final class McGregor {
    private IAtomContainer source;
    private IAtomContainer target;
    private BinaryTree last = null;
    private BinaryTree first = null;
    private Stack<List<Integer>> bestArcs;
    private List<Integer> modifiedARCS;
    private int bestarcsleft;
    private int globalMCSSize;
    private List<List<Integer>> mappings;
    private static final String[] SIGNS = new String[]{"$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9", "$10", "$11", "$12", "$13", "$15", "$16", "$17", "$18", "$19", "$20", "$21", "$22", "$23", "$24", "$25", "$26", "$27", "$28", "$29", "$30", "$31", "$32", "$33", "$34", "$35", "$36", "$37", "$38", "$39", "$40", "$41", "$42", "$43", "$44", "$45", "$46", "$47", "$48", "$49", "$50", "$51", "$52", "$53", "$54", "$55"};
    private boolean newMatrix;
    private boolean bondMatch = false;

    public McGregor(IAtomContainer source, IAtomContainer target, List<List<Integer>> mappings, boolean shouldMatchBonds) {
        this.setBondMatch(shouldMatchBonds);
        this.source = source;
        this.target = target;
        this.mappings = mappings;
        this.bestarcsleft = 0;
        this.globalMCSSize = !mappings.isEmpty() ? mappings.get(0).size() : 0;
        this.modifiedARCS = new ArrayList<Integer>();
        this.bestArcs = new Stack();
        this.newMatrix = false;
    }

    public McGregor(IQueryAtomContainer source, IAtomContainer target, List<List<Integer>> mappings) {
        this.setBondMatch(true);
        this.source = source;
        this.target = target;
        this.mappings = mappings;
        this.bestarcsleft = 0;
        this.globalMCSSize = !mappings.isEmpty() ? mappings.get(0).size() : 0;
        this.modifiedARCS = new ArrayList<Integer>();
        this.bestArcs = new Stack();
        this.newMatrix = false;
    }

    public void startMcGregorIteration(int largestMappingSize, Map<Integer, Integer> presentMapping) throws IOException {
        this.globalMCSSize = largestMappingSize / 2;
        List<String> cTab1Copy = McGregorChecks.generateCTabCopy(this.source);
        List<String> cTab2Copy = McGregorChecks.generateCTabCopy(this.target);
        ArrayList<Integer> mappedAtoms = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> map : presentMapping.entrySet()) {
            mappedAtoms.add(map.getKey());
            mappedAtoms.add(map.getValue());
        }
        int mappingSize = presentMapping.size();
        List<Integer> iBondNeighborsA = new ArrayList<Integer>();
        List<String> cBondNeighborsA = new ArrayList<String>();
        ArrayList<Integer> iBondSetA = new ArrayList<Integer>();
        ArrayList<String> cBondSetA = new ArrayList<String>();
        List<Integer> iBondNeighborsB = new ArrayList<Integer>();
        ArrayList<Integer> iBondSetB = new ArrayList<Integer>();
        List<String> cBondNeighborsB = new ArrayList<String>();
        ArrayList<String> cBondSetB = new ArrayList<String>();
        List<Integer> unmappedAtomsMolA = McGregorChecks.markUnMappedAtoms(true, this.source, presentMapping);
        int counter = 0;
        int gSetBondNumA = 0;
        int gSetBondNumB = 0;
        int gNeighborBondnumA = 0;
        int gNeighborBondNumB = 0;
        QueryProcessor queryProcess = new QueryProcessor(cTab1Copy, cTab2Copy, SIGNS, gNeighborBondnumA, gSetBondNumA, iBondNeighborsA, cBondNeighborsA, mappingSize, iBondSetA, cBondSetA);
        if (!(this.source instanceof IQueryAtomContainer)) {
            queryProcess.process(this.source, this.target, unmappedAtomsMolA, mappedAtoms, counter);
        } else {
            queryProcess.process((IQueryAtomContainer)this.source, this.target, unmappedAtomsMolA, mappedAtoms, counter);
        }
        cTab1Copy = queryProcess.getCTab1();
        cTab2Copy = queryProcess.getCTab2();
        gSetBondNumA = queryProcess.getBondNumA();
        gNeighborBondnumA = queryProcess.getNeighborBondNumA();
        iBondNeighborsA = queryProcess.getIBondNeighboursA();
        cBondNeighborsA = queryProcess.getCBondNeighborsA();
        List<Integer> unmappedAtomsMolB = McGregorChecks.markUnMappedAtoms(false, this.target, presentMapping);
        TargetProcessor targetProcess = new TargetProcessor(cTab1Copy, cTab2Copy, SIGNS, gNeighborBondNumB, gSetBondNumB, iBondNeighborsB, cBondNeighborsB, gNeighborBondnumA, iBondNeighborsA, cBondNeighborsA);
        targetProcess.process(this.target, unmappedAtomsMolB, mappingSize, iBondSetB, cBondSetB, mappedAtoms, counter);
        cTab1Copy = targetProcess.getCTab1();
        cTab2Copy = targetProcess.getCTab2();
        gSetBondNumB = targetProcess.getBondNumB();
        gNeighborBondNumB = targetProcess.getNeighborBondNumB();
        iBondNeighborsB = targetProcess.getIBondNeighboursB();
        cBondNeighborsB = targetProcess.getCBondNeighborsB();
        boolean dummy = false;
        McgregorHelper mcGregorHelper = new McgregorHelper(dummy, presentMapping.size(), mappedAtoms, gNeighborBondnumA, gNeighborBondNumB, iBondNeighborsA, iBondNeighborsB, cBondNeighborsA, cBondNeighborsB, gSetBondNumA, gSetBondNumB, iBondSetA, iBondSetB, cBondSetA, cBondSetB);
        this.iterator(mcGregorHelper);
    }

    public void startMcGregorIteration(int largestMappingSize, List<Integer> cliqueVector, List<Integer> compGraphNodes) throws IOException {
        this.globalMCSSize = largestMappingSize / 2;
        List<String> cTab1Copy = McGregorChecks.generateCTabCopy(this.source);
        List<String> cTab2Copy = McGregorChecks.generateCTabCopy(this.target);
        ArrayList<Integer> mappedAtoms = new ArrayList<Integer>();
        int mappedAtomCount = 0;
        List<Integer> iBondNeighborAtomsA = new ArrayList<Integer>();
        List<String> cBondNeighborsA = new ArrayList<String>();
        ArrayList<Integer> iBondSetA = new ArrayList<Integer>();
        ArrayList<String> cBondSetA = new ArrayList<String>();
        List<Integer> iBondNeighborAtomsB = new ArrayList<Integer>();
        ArrayList<Integer> iBondSetB = new ArrayList<Integer>();
        List<String> cBondNeighborsB = new ArrayList<String>();
        ArrayList<String> cBondSetB = new ArrayList<String>();
        int cliqueSize = cliqueVector.size();
        int vecSize = compGraphNodes.size();
        for (Integer integer : cliqueVector) {
            int cliqueNumber = integer;
            for (int b = 0; b < vecSize; b += 3) {
                if (cliqueNumber != compGraphNodes.get(b + 2)) continue;
                mappedAtoms.add(compGraphNodes.get(b));
                mappedAtoms.add(compGraphNodes.get(b + 1));
                ++mappedAtomCount;
            }
        }
        List<Integer> unmappedAtomsMolA = McGregorChecks.markUnMappedAtoms(true, this.source, mappedAtoms, cliqueSize);
        int counter = 0;
        int setNumA = 0;
        int setNumB = 0;
        int localNeighborBondnumA = 0;
        int localNeighborBondNumB = 0;
        QueryProcessor queryProcess = new QueryProcessor(cTab1Copy, cTab2Copy, SIGNS, localNeighborBondnumA, setNumA, iBondNeighborAtomsA, cBondNeighborsA, cliqueSize, iBondSetA, cBondSetA);
        queryProcess.process(this.source, this.target, unmappedAtomsMolA, mappedAtoms, counter);
        cTab1Copy = queryProcess.getCTab1();
        cTab2Copy = queryProcess.getCTab2();
        setNumA = queryProcess.getBondNumA();
        localNeighborBondnumA = queryProcess.getNeighborBondNumA();
        iBondNeighborAtomsA = queryProcess.getIBondNeighboursA();
        cBondNeighborsA = queryProcess.getCBondNeighborsA();
        List<Integer> unmappedAtomsMolB = McGregorChecks.markUnMappedAtoms(false, this.target, mappedAtoms, cliqueSize);
        TargetProcessor targetProcess = new TargetProcessor(cTab1Copy, cTab2Copy, SIGNS, localNeighborBondNumB, setNumB, iBondNeighborAtomsB, cBondNeighborsB, localNeighborBondnumA, iBondNeighborAtomsA, cBondNeighborsA);
        targetProcess.process(this.target, unmappedAtomsMolB, cliqueSize, iBondSetB, cBondSetB, mappedAtoms, counter);
        cTab1Copy = targetProcess.getCTab1();
        cTab2Copy = targetProcess.getCTab2();
        setNumB = targetProcess.getBondNumB();
        localNeighborBondNumB = targetProcess.getNeighborBondNumB();
        iBondNeighborAtomsB = targetProcess.getIBondNeighboursB();
        cBondNeighborsB = targetProcess.getCBondNeighborsB();
        boolean dummy = false;
        McgregorHelper mcGregorHelper = new McgregorHelper(dummy, mappedAtomCount, mappedAtoms, localNeighborBondnumA, localNeighborBondNumB, iBondNeighborAtomsA, iBondNeighborAtomsB, cBondNeighborsA, cBondNeighborsB, setNumA, setNumB, iBondSetA, iBondSetB, cBondSetA, cBondSetB);
        this.iterator(mcGregorHelper);
    }

    private int iterator(McgregorHelper mcGregorHelper) throws IOException {
        boolean mappingCheckFlag = mcGregorHelper.isMappingCheckFlag();
        int mappedAtomCount = mcGregorHelper.getMappedAtomCount();
        ArrayList<Integer> mappedAtoms = new ArrayList<Integer>(mcGregorHelper.getMappedAtomsOrg());
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        boolean furtherMappingFlag = McGregorChecks.isFurtherMappingPossible(this.source, this.target, mcGregorHelper, this.isBondMatch());
        if (neighborBondNumA == 0 || neighborBondNumB == 0 || mappingCheckFlag || !furtherMappingFlag) {
            this.setFinalMappings(mappedAtoms, mappedAtomCount);
            return 0;
        }
        this.modifiedARCS.clear();
        int size = neighborBondNumA * neighborBondNumB;
        for (int i = 0; i < size; ++i) {
            this.modifiedARCS.add(i, 0);
        }
        this.setModifedArcs(mcGregorHelper);
        this.last = this.first = new BinaryTree(-1);
        this.last.setEqual(null);
        this.last.setNotEqual(null);
        this.bestarcsleft = 0;
        this.startsearch(mcGregorHelper);
        Stack<List<Integer>> bestArcsCopy = new Stack<List<Integer>>();
        bestArcsCopy.addAll(this.bestArcs);
        while (!this.bestArcs.empty()) {
            this.bestArcs.pop();
        }
        this.searchAndExtendMappings(bestArcsCopy, mcGregorHelper);
        return 0;
    }

    private void searchAndExtendMappings(Stack<List<Integer>> bestarcsCopy, McgregorHelper mcGregorHelper) throws IOException {
        int mappedAtomCount = mcGregorHelper.getMappedAtomCount();
        int setNumA = mcGregorHelper.getSetNumA();
        int setNumB = mcGregorHelper.getsetNumB();
        List<Integer> iBondSetA = mcGregorHelper.getIBondSetA();
        List<Integer> iBondSetB = mcGregorHelper.getIBondSetB();
        List<String> cBondSetA = mcGregorHelper.getCBondSetA();
        List<String> cBondSetB = mcGregorHelper.getCBondSetB();
        while (!bestarcsCopy.empty()) {
            ArrayList<Integer> mArcsVector = new ArrayList<Integer>((Collection)bestarcsCopy.peek());
            List<Integer> newMapping = this.findMcGregorMapping(mArcsVector, mcGregorHelper);
            int newMapingSize = newMapping.size() / 2;
            boolean noFurtherMappings = false;
            if (mappedAtomCount == newMapingSize) {
                noFurtherMappings = true;
            }
            List<Integer> newINeighborsA = new ArrayList<Integer>();
            List<Integer> newINeighborsB = new ArrayList<Integer>();
            List<String> newCNeighborsA = new ArrayList<String>();
            List<String> newCNeighborsB = new ArrayList<String>();
            ArrayList<Integer> newIBondSetA = new ArrayList<Integer>();
            ArrayList<Integer> newIBondSetB = new ArrayList<Integer>();
            ArrayList<String> newCBondSetA = new ArrayList<String>();
            ArrayList<String> newCBondSetB = new ArrayList<String>();
            List<String> cSetACopy = McGregorChecks.generateCSetCopy(setNumA, cBondSetA);
            List<String> cSetBCopy = McGregorChecks.generateCSetCopy(setNumB, cBondSetB);
            ArrayList<Integer> unmappedAtomsMolA = new ArrayList<Integer>();
            int unmappedNumA = 0;
            boolean atomAIsUnmapped = true;
            for (int a = 0; a < this.source.getAtomCount(); ++a) {
                for (int b = 0; b < newMapingSize; ++b) {
                    if (a != newMapping.get(b * 2 + 0)) continue;
                    atomAIsUnmapped = false;
                }
                if (atomAIsUnmapped) {
                    unmappedAtomsMolA.add(unmappedNumA++, a);
                }
                atomAIsUnmapped = true;
            }
            int counter = 0;
            int newSetBondNumA = 0;
            int newNeighborNumA = 0;
            QueryProcessor queryProcess = new QueryProcessor(cSetACopy, cSetBCopy, SIGNS, newNeighborNumA, newSetBondNumA, newINeighborsA, newCNeighborsA, newMapingSize, newIBondSetA, newCBondSetA);
            queryProcess.process(setNumA, setNumB, iBondSetA, iBondSetB, unmappedAtomsMolA, newMapping, counter);
            cSetACopy = queryProcess.getCTab1();
            cSetBCopy = queryProcess.getCTab2();
            newSetBondNumA = queryProcess.getBondNumA();
            newNeighborNumA = queryProcess.getNeighborBondNumA();
            newINeighborsA = queryProcess.getIBondNeighboursA();
            newCNeighborsA = queryProcess.getCBondNeighborsA();
            ArrayList<Integer> unmappedAtomsMolB = new ArrayList<Integer>();
            int unmappedNumB = 0;
            boolean atomBIsUnmapped = true;
            for (int a = 0; a < this.target.getAtomCount(); ++a) {
                for (int b = 0; b < newMapingSize; ++b) {
                    if (a != newMapping.get(b * 2 + 1)) continue;
                    atomBIsUnmapped = false;
                }
                if (atomBIsUnmapped) {
                    unmappedAtomsMolB.add(unmappedNumB++, a);
                }
                atomBIsUnmapped = true;
            }
            int newSetBondNumB = 0;
            int newNeighborNumB = 0;
            TargetProcessor targetProcess = new TargetProcessor(cSetACopy, cSetBCopy, SIGNS, newNeighborNumB, newSetBondNumB, newINeighborsB, newCNeighborsB, newNeighborNumA, newINeighborsA, newCNeighborsA);
            targetProcess.process(setNumB, unmappedAtomsMolB, newMapingSize, iBondSetB, cBondSetB, newMapping, counter, newIBondSetB, newCBondSetB);
            cSetACopy = targetProcess.getCTab1();
            cSetBCopy = targetProcess.getCTab2();
            newSetBondNumB = targetProcess.getBondNumB();
            newNeighborNumB = targetProcess.getNeighborBondNumB();
            newINeighborsB = targetProcess.getIBondNeighboursB();
            newCNeighborsB = targetProcess.getCBondNeighborsB();
            McgregorHelper newMH = new McgregorHelper(noFurtherMappings, newMapingSize, newMapping, newNeighborNumA, newNeighborNumB, newINeighborsA, newINeighborsB, newCNeighborsA, newCNeighborsB, newSetBondNumA, newSetBondNumB, newIBondSetA, newIBondSetB, newCBondSetA, newCBondSetB);
            this.iterator(newMH);
            bestarcsCopy.pop();
        }
    }

    private List<Integer> findMcGregorMapping(List<Integer> mArcs, McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        ArrayList<Integer> currentMapping = new ArrayList<Integer>(mcGregorHelper.getMappedAtomsOrg());
        ArrayList<Integer> additionalMapping = new ArrayList<Integer>();
        for (int x = 0; x < neighborBondNumA; ++x) {
            for (int y = 0; y < neighborBondNumB; ++y) {
                if (mArcs.get(x * neighborBondNumB + y) != 1) continue;
                this.extendMapping(x, y, mcGregorHelper, additionalMapping, currentMapping);
            }
        }
        int additionalMappingSize = additionalMapping.size();
        for (int a = 0; a < additionalMappingSize; a += 2) {
            currentMapping.add((Integer)additionalMapping.get(a + 0));
            currentMapping.add((Integer)additionalMapping.get(a + 1));
        }
        List<Integer> uniqueMapping = McGregorChecks.removeRecurringMappings(currentMapping);
        return uniqueMapping;
    }

    private void setModifedArcs(McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        List<Integer> iBondNeighborAtomsA = mcGregorHelper.getiBondNeighborAtomsA();
        List<Integer> iBondNeighborAtomsB = mcGregorHelper.getiBondNeighborAtomsB();
        List<String> cBondNeighborsA = mcGregorHelper.getcBondNeighborsA();
        List<String> cBondNeighborsB = mcGregorHelper.getcBondNeighborsB();
        for (int row = 0; row < neighborBondNumA; ++row) {
            for (int column = 0; column < neighborBondNumB; ++column) {
                IAtom p2B;
                String g2B;
                String g1B;
                String g2A;
                String g1A = cBondNeighborsA.get(row * 4 + 0);
                if (!this.matchGAtoms(g1A, g2A = cBondNeighborsA.get(row * 4 + 1), g1B = cBondNeighborsB.get(column * 4 + 0), g2B = cBondNeighborsB.get(column * 4 + 1))) continue;
                int indexI = iBondNeighborAtomsA.get(row * 3 + 0);
                int indexIPlus1 = iBondNeighborAtomsA.get(row * 3 + 1);
                IAtom r1A = this.source.getAtom(indexI);
                IAtom r2A = this.source.getAtom(indexIPlus1);
                IBond reactantBond = this.source.getBond(r1A, r2A);
                int indexJ = iBondNeighborAtomsB.get(column * 3 + 0);
                int indexJPlus1 = iBondNeighborAtomsB.get(column * 3 + 1);
                IAtom p1B = this.target.getAtom(indexJ);
                IBond productBond = this.target.getBond(p1B, p2B = this.target.getAtom(indexJPlus1));
                if (!McGregorChecks.isMatchFeasible(this.source, reactantBond, this.target, productBond, this.isBondMatch())) continue;
                this.modifiedARCS.set(row * neighborBondNumB + column, 1);
            }
        }
    }

    private void partsearch(int xstart, int ystart, List<Integer> tempMArcsOrg, McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        int xIndex = xstart;
        int yIndex = ystart;
        ArrayList<Integer> tempMArcs = new ArrayList<Integer>(tempMArcsOrg);
        if ((Integer)tempMArcs.get(xstart * neighborBondNumB + ystart) == 1) {
            McGregorChecks.removeRedundantArcs(xstart, ystart, tempMArcs, mcGregorHelper);
            int arcsleft = McGregorChecks.countArcsLeft(tempMArcs, neighborBondNumA, neighborBondNumB);
            if (arcsleft >= this.bestarcsleft) {
                this.setArcs(xIndex, yIndex, arcsleft, tempMArcs, mcGregorHelper);
            }
        } else {
            do {
                if (++yIndex != neighborBondNumB) continue;
                yIndex = 0;
                ++xIndex;
            } while (xIndex < neighborBondNumA && (Integer)tempMArcs.get(xIndex * neighborBondNumB + yIndex) != 1);
            if (xIndex < neighborBondNumA) {
                this.partsearch(xIndex, yIndex, tempMArcs, mcGregorHelper);
                tempMArcs.set(xIndex * neighborBondNumB + yIndex, 0);
                this.partsearch(xIndex, yIndex, tempMArcs, mcGregorHelper);
            } else {
                int arcsleft = McGregorChecks.countArcsLeft(tempMArcs, neighborBondNumA, neighborBondNumB);
                if (arcsleft >= this.bestarcsleft) {
                    this.popBestArcs(arcsleft);
                    if (this.checkmArcs(tempMArcs, neighborBondNumA, neighborBondNumB)) {
                        this.bestArcs.push(tempMArcs);
                    }
                }
            }
        }
    }

    private boolean checkmArcs(List<Integer> mArcsT, int neighborBondNumA, int neighborBondNumB) {
        int size = neighborBondNumA * neighborBondNumA;
        ArrayList<Integer> posNumList = new ArrayList<Integer>(size);
        for (int i = 0; i < posNumList.size(); ++i) {
            posNumList.add(i, 0);
        }
        int yCounter = 0;
        int countEntries = 0;
        for (int x = 0; x < neighborBondNumA * neighborBondNumB; ++x) {
            if (mArcsT.get(x) != 1) continue;
            posNumList.add(yCounter++, x);
            ++countEntries;
        }
        boolean flag = false;
        this.verifyNodes(posNumList, this.first, 0, countEntries);
        if (this.isNewMatrix()) {
            flag = true;
        }
        return flag;
    }

    private boolean verifyNodes(List<Integer> matrix, BinaryTree currentStructure, int index, int fieldLength) {
        if (index < fieldLength) {
            if (matrix.get(index).intValue() == currentStructure.getValue() && currentStructure.getEqual() != null) {
                this.setNewMatrix(false);
                this.verifyNodes(matrix, currentStructure.getEqual(), index + 1, fieldLength);
            }
            if (matrix.get(index).intValue() != currentStructure.getValue()) {
                if (currentStructure.getNotEqual() != null) {
                    this.verifyNodes(matrix, currentStructure.getNotEqual(), index, fieldLength);
                }
                if (currentStructure.getNotEqual() == null) {
                    currentStructure.setNotEqual(new BinaryTree(matrix.get(index)));
                    currentStructure.getNotEqual().setNotEqual(null);
                    int yIndex = 0;
                    BinaryTree lastOne = currentStructure.getNotEqual();
                    while (yIndex + index + 1 < fieldLength) {
                        lastOne.setEqual(new BinaryTree(matrix.get(yIndex + index + 1)));
                        lastOne = lastOne.getEqual();
                        lastOne.setNotEqual(null);
                        ++yIndex;
                    }
                    lastOne.setEqual(null);
                    this.setNewMatrix(true);
                }
            }
        }
        return true;
    }

    private void startsearch(McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        int size = neighborBondNumA * neighborBondNumB;
        ArrayList<Integer> fixArcs = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            fixArcs.add(i, 0);
        }
        int xIndex = 0;
        int yIndex = 0;
        while (xIndex < neighborBondNumA && this.modifiedARCS.get(xIndex * neighborBondNumB + yIndex) != 1) {
            if (++yIndex != neighborBondNumB) continue;
            yIndex = 0;
            ++xIndex;
        }
        if (xIndex == neighborBondNumA) {
            yIndex = neighborBondNumB - 1;
            --xIndex;
        }
        if (this.modifiedARCS.get(xIndex * neighborBondNumB + yIndex) == 0) {
            this.partsearch(xIndex, yIndex, this.modifiedARCS, mcGregorHelper);
        }
        if (this.modifiedARCS.get(xIndex * neighborBondNumB + yIndex) != 0) {
            this.partsearch(xIndex, yIndex, this.modifiedARCS, mcGregorHelper);
            this.modifiedARCS.set(xIndex * neighborBondNumB + yIndex, 0);
            this.partsearch(xIndex, yIndex, this.modifiedARCS, mcGregorHelper);
        }
    }

    public List<List<Integer>> getMappings() {
        return this.mappings;
    }

    public int getMCSSize() {
        return this.globalMCSSize;
    }

    private void setFinalMappings(List<Integer> mappedAtoms, int mappedAtomCount) {
        try {
            if (mappedAtomCount >= this.globalMCSSize) {
                if (mappedAtomCount > this.globalMCSSize) {
                    this.globalMCSSize = mappedAtomCount;
                    this.mappings.clear();
                }
                this.mappings.add(mappedAtoms);
            }
        }
        catch (Exception ex) {
            LoggingToolFactory.createLoggingTool(McGregor.class).warn((Object)"Unexpected Error:", new Object[]{ex});
        }
    }

    private void setArcs(int xIndex, int yIndex, int arcsleft, List<Integer> tempMArcs, McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        do {
            if (++yIndex != neighborBondNumB) continue;
            yIndex = 0;
            ++xIndex;
        } while (xIndex < neighborBondNumA && tempMArcs.get(xIndex * neighborBondNumB + yIndex) != 1);
        if (xIndex < neighborBondNumA) {
            this.partsearch(xIndex, yIndex, tempMArcs, mcGregorHelper);
            tempMArcs.set(xIndex * neighborBondNumB + yIndex, 0);
            this.partsearch(xIndex, yIndex, tempMArcs, mcGregorHelper);
        } else {
            this.popBestArcs(arcsleft);
            if (this.checkmArcs(tempMArcs, neighborBondNumA, neighborBondNumB)) {
                this.bestArcs.push(tempMArcs);
            }
        }
    }

    private void popBestArcs(int arcsleft) {
        if (arcsleft > this.bestarcsleft) {
            McGregorChecks.removeTreeStructure(this.first);
            this.first = this.last = new BinaryTree(-1);
            this.last.setEqual(null);
            this.last.setNotEqual(null);
            while (!this.bestArcs.empty()) {
                this.bestArcs.pop();
            }
        }
        this.bestarcsleft = arcsleft;
    }

    private void extendMapping(int xIndex, int yIndex, McgregorHelper mcGregorHelper, List<Integer> additionalMapping, List<Integer> currentMapping) {
        IAtom p2B;
        IAtom p1B;
        IBond productBond;
        IAtom r2A;
        int atom1MoleculeA = mcGregorHelper.getiBondNeighborAtomsA().get(xIndex * 3 + 0);
        int atom2MoleculeA = mcGregorHelper.getiBondNeighborAtomsA().get(xIndex * 3 + 1);
        int atom1MoleculeB = mcGregorHelper.getiBondNeighborAtomsB().get(yIndex * 3 + 0);
        int atom2MoleculeB = mcGregorHelper.getiBondNeighborAtomsB().get(yIndex * 3 + 1);
        IAtom r1A = this.source.getAtom(atom1MoleculeA);
        IBond reactantBond = this.source.getBond(r1A, r2A = this.source.getAtom(atom2MoleculeA));
        if (McGregorChecks.isMatchFeasible(this.source, reactantBond, this.target, productBond = this.target.getBond(p1B = this.target.getAtom(atom1MoleculeB), p2B = this.target.getAtom(atom2MoleculeB)), this.isBondMatch())) {
            for (int indexZ = 0; indexZ < mcGregorHelper.getMappedAtomCount(); ++indexZ) {
                int mappedAtom1 = currentMapping.get(indexZ * 2 + 0);
                int mappedAtom2 = currentMapping.get(indexZ * 2 + 1);
                if (mappedAtom1 == atom1MoleculeA && mappedAtom2 == atom1MoleculeB) {
                    additionalMapping.add(atom2MoleculeA);
                    additionalMapping.add(atom2MoleculeB);
                    continue;
                }
                if (mappedAtom1 == atom1MoleculeA && mappedAtom2 == atom2MoleculeB) {
                    additionalMapping.add(atom2MoleculeA);
                    additionalMapping.add(atom1MoleculeB);
                    continue;
                }
                if (mappedAtom1 == atom2MoleculeA && mappedAtom2 == atom1MoleculeB) {
                    additionalMapping.add(atom1MoleculeA);
                    additionalMapping.add(atom2MoleculeB);
                    continue;
                }
                if (mappedAtom1 != atom2MoleculeA || mappedAtom2 != atom2MoleculeB) continue;
                additionalMapping.add(atom1MoleculeA);
                additionalMapping.add(atom1MoleculeB);
            }
        }
    }

    private boolean matchGAtoms(String g1A, String g2A, String g1B, String g2B) {
        return g1A.compareToIgnoreCase(g1B) == 0 && g2A.compareToIgnoreCase(g2B) == 0 || g1A.compareToIgnoreCase(g2B) == 0 && g2A.compareToIgnoreCase(g1B) == 0;
    }

    public boolean isNewMatrix() {
        return this.newMatrix;
    }

    public void setNewMatrix(boolean newMatrix) {
        this.newMatrix = newMatrix;
    }

    private boolean isBondMatch() {
        return this.bondMatch;
    }

    private void setBondMatch(boolean bondMatch) {
        this.bondMatch = bondMatch;
    }
}

