/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainBest;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainLast;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class RoundRobin
extends AbstractStrategy<IntVar>
implements IMonitorRestart {
    final VariableSelector<IntVar>[] variableSelectors;
    int currentCombination;
    final IntValueSelector[] valueSelectors;
    Function<IntVar, OptionalInt> solutionFirst = v -> OptionalInt.empty();
    Function<IntVar, OptionalInt> bestFirst = v -> OptionalInt.empty();
    final List<int[]> combinations;

    public RoundRobin(IntVar[] variables, VariableSelector<IntVar>[] variableSelectors, IntValueSelector[] valueSelectors, boolean solutionSaving, boolean bestUntilFirstSolution) {
        super((Variable[])variables);
        this.variableSelectors = variableSelectors;
        this.valueSelectors = valueSelectors;
        this.currentCombination = 0;
        if (solutionSaving) {
            Solution solution = ((IntVar[])this.vars)[0].getModel().getSolver().defaultSolution();
            this.solutionFirst = new IntDomainLast(solution, valueSelectors[0], null);
        }
        if (bestUntilFirstSolution) {
            this.bestFirst = new IntDomainBest(valueSelectors[0], v -> variables[0].getModel().getSolver().getSolutionCount() == 0L);
        }
        this.combinations = new ArrayList<int[]>();
        for (int i = 0; i < variableSelectors.length; ++i) {
            int j = 0;
            while (j < valueSelectors.length) {
                this.combinations.add(new int[]{i, j++});
            }
        }
    }

    @Override
    public boolean init() {
        Solver solver = ((IntVar[])this.vars)[0].getModel().getSolver();
        if (!solver.getSearchMonitors().contains(this)) {
            solver.plugMonitor(this);
        }
        boolean init = true;
        for (VariableSelector<IntVar> vs : this.variableSelectors) {
            init &= vs.init();
        }
        return init;
    }

    @Override
    public void remove() {
        for (VariableSelector<IntVar> vs : this.variableSelectors) {
            vs.remove();
        }
        Solver solver = ((IntVar[])this.vars)[0].getModel().getSolver();
        if (solver.getSearchMonitors().contains(this)) {
            solver.unplugMonitor(this);
        }
    }

    @Override
    public Decision<IntVar> getDecision() {
        IntVar variable = (IntVar)this.variableSelectors[this.combinations.get(this.currentCombination)[0]].getVariable((IntVar[])this.vars);
        return this.computeDecision(variable);
    }

    @Override
    public Decision<IntVar> computeDecision(IntVar variable) {
        if (variable == null || variable.isInstantiated()) {
            return null;
        }
        OptionalInt opt = this.bestFirst.apply(variable);
        if (!opt.isPresent()) {
            opt = this.solutionFirst.apply(variable);
        }
        if (!opt.isPresent()) {
            opt = OptionalInt.of(this.valueSelectors[this.combinations.get(this.currentCombination)[1]].selectValue(variable));
        }
        return variable.getModel().getSolver().getDecisionPath().makeIntDecision(variable, DecisionOperatorFactory.makeIntEq(), opt.getAsInt());
    }

    @Override
    public void afterRestart() {
        this.currentCombination = (this.currentCombination + 1) % this.combinations.size();
    }
}

