/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.arima.ILinearProcess;
import jdplus.toolkit.base.core.arima.Spectrum;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.ForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalForeFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;

public final class LinearProcess
implements ILinearProcess {
    private final RationalFilter rf;
    private final double var;
    private volatile AutoCovarianceFunction acf;
    private volatile Spectrum spectrum;

    public LinearProcess(RationalFilter rf, double var) {
        this.rf = rf;
        this.var = var;
    }

    public LinearProcess doStationary() {
        RationalForeFilter rf;
        ForeFilter fdenom;
        ForeFilter.StationaryTransformation fst;
        BackFilter.StationaryTransformation bst = new BackFilter.StationaryTransformation();
        RationalBackFilter rb = this.rf.getRationalBackFilter();
        BackFilter bdenom = rb.getDenominator();
        if (bst.transform(bdenom)) {
            bdenom = bst.stationaryFilter;
        }
        if ((fst = new ForeFilter.StationaryTransformation()).transform(fdenom = (rf = this.rf.getRationalForeFilter()).getDenominator())) {
            fdenom = fst.stationaryFilter;
        }
        RationalFilter stfilter = RationalFilter.of(this.rf.getNumerator(), bdenom, fdenom);
        return new LinearProcess(stfilter, this.var);
    }

    @Override
    public RationalFilter getFilter() {
        return this.rf;
    }

    @Override
    public double getInnovationVariance() {
        return this.var;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public boolean isNull() {
        return this.var == 0.0;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutoCovarianceFunction getAutoCovarianceFunction() {
        AutoCovarianceFunction tmp = this.acf;
        if (tmp == null) {
            LinearProcess linearProcess = this;
            synchronized (linearProcess) {
                tmp = this.acf;
                if (tmp == null) {
                    RationalFilter f = this.getFilter();
                    Polynomial n = Polynomial.ofInternal(f.getNumerator().weightsToArray());
                    Polynomial bd = f.getRationalBackFilter().getDenominator().asPolynomial();
                    Polynomial fd = f.getRationalForeFilter().getDenominator().asPolynomial();
                    this.acf = tmp = new AutoCovarianceFunction(n, bd.times(fd), this.getInnovationVariance());
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spectrum getSpectrum() {
        Spectrum tmp = this.spectrum;
        if (tmp == null) {
            LinearProcess linearProcess = this;
            synchronized (linearProcess) {
                tmp = this.spectrum;
                if (tmp == null) {
                    RationalFilter rf = this.getFilter();
                    this.spectrum = tmp = new Spectrum(SymmetricFilter.convolutionOf(rf.getNumerator()).times(this.getInnovationVariance()), SymmetricFilter.convolutionOf(rf.getDenominator()));
                }
            }
        }
        return tmp;
    }
}

