/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class MatrixWindow {
    private final FastMatrix cur;

    public static MatrixWindow of(FastMatrix m) {
        return new MatrixWindow(m.getStorage(), m.getColumnIncrement(), m.getStartPosition(), m.getRowsCount(), m.getColumnsCount());
    }

    MatrixWindow(double[] x, int lda, int start, int nrows, int ncols) {
        this.cur = new FastMatrix(x, lda, start, nrows, ncols);
    }

    public FastMatrix get() {
        return this.cur;
    }

    public FastMatrix move(int dr, int dc) {
        this.cur.start += dr + dc * this.cur.getColumnIncrement();
        return this.cur;
    }

    public FastMatrix bshrink() {
        this.cur.start += this.cur.getColumnIncrement() + 1;
        --this.cur.nrows;
        --this.cur.ncols;
        return this.cur;
    }

    public FastMatrix bvshrink() {
        ++this.cur.start;
        --this.cur.nrows;
        return this.cur;
    }

    public FastMatrix bhshrink() {
        this.cur.start += this.cur.getColumnIncrement();
        --this.cur.ncols;
        return this.cur;
    }

    public FastMatrix eshrink() {
        --this.cur.nrows;
        --this.cur.ncols;
        return this.cur;
    }

    public FastMatrix evshrink() {
        --this.cur.nrows;
        return this.cur;
    }

    public FastMatrix ehshrink() {
        --this.cur.ncols;
        return this.cur;
    }

    public FastMatrix next(int nr, int nc) {
        this.cur.start += this.cur.nrows + this.cur.ncols * this.cur.getColumnIncrement();
        this.cur.nrows = nr;
        this.cur.ncols = nc;
        return this.cur;
    }

    public FastMatrix next() {
        this.cur.start += this.cur.nrows + this.cur.ncols * this.cur.getColumnIncrement();
        return this.cur;
    }

    public FastMatrix hnext(int nc) {
        this.cur.start += this.cur.ncols * this.cur.getColumnIncrement();
        this.cur.ncols = nc;
        return this.cur;
    }

    public FastMatrix hnext() {
        this.cur.start += this.cur.ncols * this.cur.getColumnIncrement();
        return this.cur;
    }

    public FastMatrix vnext(int nr) {
        this.cur.start += this.cur.nrows;
        this.cur.nrows = nr;
        return this.cur;
    }

    public FastMatrix vnext() {
        this.cur.start += this.cur.nrows;
        return this.cur;
    }

    public FastMatrix previous(int nr, int nc) {
        this.cur.start -= nr + nc * this.cur.getColumnIncrement();
        this.cur.nrows = nr;
        this.cur.ncols = nc;
        return this.cur;
    }

    public FastMatrix previous() {
        this.cur.start -= this.cur.nrows + this.cur.ncols * this.cur.getColumnIncrement();
        return this.cur;
    }

    public FastMatrix hprevious(int nc) {
        this.cur.start -= nc * this.cur.getColumnIncrement();
        this.cur.ncols = nc;
        return this.cur;
    }

    public FastMatrix hprevious() {
        this.cur.start -= this.cur.nrows;
        return this.cur;
    }

    public FastMatrix vprevious(int nr) {
        this.cur.start -= nr;
        this.cur.nrows = nr;
        return this.cur;
    }

    public FastMatrix vprevious() {
        this.cur.start -= this.cur.nrows;
        return this.cur;
    }
}

