/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.EntropyDiscretizer;
import org.vikamine.kernel.data.discretization.SupervisedBinaryDiscretizer;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class FayyadIraniDiscretizer
extends SupervisedBinaryDiscretizer {
    private static final String NAME = "Fayyad Irani Discretizer";

    private static double cieAddand(int sizeCut, double size, double entropy) {
        double weight = (double)sizeCut / size;
        return weight * entropy;
    }

    private static double classInformationEntropy(int sizeLowerCut, int sizeUpperCut, double sizePartition, double entropyLower, double entropyUpper) {
        return FayyadIraniDiscretizer.cieAddand(sizeLowerCut, sizePartition, entropyLower) + FayyadIraniDiscretizer.cieAddand(sizeUpperCut, sizePartition, entropyUpper);
    }

    public FayyadIraniDiscretizer() {
    }

    public FayyadIraniDiscretizer(SGTarget target) {
        super(target);
    }

    public FayyadIraniDiscretizer(DataView population, NumericAttribute na, SGTarget target) {
        super(target);
        this.setPopulation(population);
        this.setAttribute(na);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    SupervisedBinaryDiscretizer.BinaryPartition makeBinaryPartition(SupervisedBinaryDiscretizer.InstanceBlock firstBlock, SupervisedBinaryDiscretizer.InstanceBlock lastBlock) {
        return new FIDBinaryPartition(firstBlock, lastBlock);
    }

    private static final class FIDBinaryPartition
    extends SupervisedBinaryDiscretizer.BinaryPartition {
        private int sizeLowerCut;
        private int sizeUpperCut;
        private double entropyLower;
        private double entropyUpper;
        private double classInformationEntropy;
        private final int classCount;
        private int classCountLower;
        private int classCountUpper;

        private static int classCount(int negatives, int positives) {
            int count = 0;
            if (negatives > 0) {
                ++count;
            }
            if (positives > 0) {
                ++count;
            }
            return count;
        }

        private static int classCount(SupervisedBinaryDiscretizer.InstanceBlock lastBlock) {
            return FIDBinaryPartition.classCount(lastBlock.cumsumNegatives, lastBlock.cumsumPositives);
        }

        private static double entropy(SupervisedBinaryDiscretizer.InstanceBlock lastBlock) {
            return EntropyDiscretizer.entropy(lastBlock.cumsumNegatives, lastBlock.cumsumPositives, FIDBinaryPartition.size(lastBlock));
        }

        private FIDBinaryPartition(SupervisedBinaryDiscretizer.InstanceBlock firstBlock, SupervisedBinaryDiscretizer.InstanceBlock lastBlock) {
            this(firstBlock, null, lastBlock, FIDBinaryPartition.classCount(lastBlock), (double)FIDBinaryPartition.size(lastBlock), FIDBinaryPartition.entropy(lastBlock));
        }

        private FIDBinaryPartition(SupervisedBinaryDiscretizer.InstanceBlock firstBlock, SupervisedBinaryDiscretizer.BoundaryPoint upperBoundary, SupervisedBinaryDiscretizer.InstanceBlock lastBlock, int classCount, double size, double entropy) {
            this.cutPoint = firstBlock.upperBoundary;
            this.classCount = classCount;
            if (this.findBestCutPoint(null, upperBoundary, size, lastBlock) && this.testAccepted(entropy, size)) {
                this.isAccepted = true;
                this.lowerPartition = new FIDBinaryPartition(firstBlock, this.cutPoint, lastBlock, this.classCountLower, (double)this.sizeLowerCut, this.entropyLower);
                this.upperPartition = new FIDBinaryPartition(this.cutPoint, upperBoundary, lastBlock, this.classCountUpper, (double)this.sizeUpperCut, this.entropyUpper);
            }
        }

        private FIDBinaryPartition(SupervisedBinaryDiscretizer.BoundaryPoint lowerBoundary, SupervisedBinaryDiscretizer.BoundaryPoint upperBoundary, SupervisedBinaryDiscretizer.InstanceBlock lastBlock, int classCount, double size, double entropy) {
            this.cutPoint = lowerBoundary.nextCutPoint();
            this.classCount = classCount;
            if (this.findBestCutPoint(lowerBoundary, upperBoundary, size, lastBlock) && this.testAccepted(entropy, size)) {
                this.isAccepted = true;
                this.lowerPartition = new FIDBinaryPartition(lowerBoundary, this.cutPoint, lastBlock, this.classCountLower, (double)this.sizeLowerCut, this.entropyLower);
                this.upperPartition = new FIDBinaryPartition(this.cutPoint, upperBoundary, lastBlock, this.classCountUpper, (double)this.sizeUpperCut, this.entropyUpper);
            }
        }

        private boolean findBestCutPoint(SupervisedBinaryDiscretizer.BoundaryPoint lowerBoundary, SupervisedBinaryDiscretizer.BoundaryPoint upperBoundary, double size, SupervisedBinaryDiscretizer.InstanceBlock lastBlock) {
            boolean found = false;
            this.classInformationEntropy = Double.MAX_VALUE;
            SupervisedBinaryDiscretizer.BoundaryPoint cutPoint = this.cutPoint;
            while (cutPoint != upperBoundary) {
                double entropyUpper;
                double entropyLower;
                int positivesUpper;
                int negativesUpper;
                int sizeUpperCut;
                int positivesLower;
                int negativesLower = cutPoint.sumNegativesLowerCut(lowerBoundary);
                int sizeLowerCut = negativesLower + (positivesLower = cutPoint.sumPositivesLowerCut(lowerBoundary));
                double classInformationEntropy = FayyadIraniDiscretizer.classInformationEntropy(sizeLowerCut, sizeUpperCut = (negativesUpper = cutPoint.sumNegativesUpperCut(upperBoundary, lastBlock)) + (positivesUpper = cutPoint.sumPositivesUpperCut(upperBoundary, lastBlock)), size, entropyLower = EntropyDiscretizer.entropy(negativesLower, positivesLower, sizeLowerCut), entropyUpper = EntropyDiscretizer.entropy(negativesUpper, positivesUpper, sizeUpperCut));
                if (classInformationEntropy < this.classInformationEntropy) {
                    this.cutPoint = cutPoint;
                    this.entropyLower = entropyLower;
                    this.entropyUpper = entropyUpper;
                    this.sizeLowerCut = sizeLowerCut;
                    this.sizeUpperCut = sizeUpperCut;
                    this.classCountLower = FIDBinaryPartition.classCount(negativesLower, positivesLower);
                    this.classCountUpper = FIDBinaryPartition.classCount(negativesUpper, positivesUpper);
                    this.classInformationEntropy = classInformationEntropy;
                    found = true;
                }
                cutPoint = cutPoint.nextCutPoint();
            }
            return found;
        }

        private boolean testAccepted(double entropy, double size) {
            double delta;
            double gain = entropy - this.classInformationEntropy;
            double logN1 = Math.log(size - 1.0) / EntropyDiscretizer.LOG2;
            double condition = (logN1 + (delta = this.delta(entropy))) / size;
            return gain > condition;
        }

        private double delta(double entropy) {
            return Math.log(Math.pow(3.0, this.classCount) - 2.0) / EntropyDiscretizer.LOG2 - ((double)this.classCount * entropy - (double)this.classCountLower * this.entropyLower - (double)this.classCountUpper * this.entropyUpper);
        }
    }
}

