/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceInformation;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.Range;
import com.yahoo.labs.samoa.instances.SparseInstance;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArffLoader {
    protected InstanceInformation instanceInformation;
    protected InstancesHeader streamHeader;
    protected StreamTokenizer streamTokenizer;
    protected Range range;
    protected List<Attribute> auxAttributes;

    public ArffLoader(Reader reader, int size, int classAttribute) {
        this(reader);
        if (classAttribute < 0) {
            this.instanceInformation.setClassIndex(this.instanceInformation.numAttributes() - 1);
        } else if (classAttribute > 0) {
            this.instanceInformation.setClassIndex(classAttribute - 1);
        }
    }

    public ArffLoader(Reader reader) {
        this(reader, null);
    }

    public ArffLoader(Reader reader, Range range) {
        this.range = range;
        BufferedReader br = new BufferedReader(reader);
        this.streamTokenizer = new StreamTokenizer(br);
        this.streamTokenizer.resetSyntax();
        this.streamTokenizer.whitespaceChars(0, 32);
        this.streamTokenizer.wordChars(33, 255);
        this.streamTokenizer.whitespaceChars(44, 44);
        this.streamTokenizer.commentChar(37);
        this.streamTokenizer.quoteChar(34);
        this.streamTokenizer.quoteChar(39);
        this.streamTokenizer.ordinaryChar(123);
        this.streamTokenizer.ordinaryChar(125);
        this.streamTokenizer.eolIsSignificant(true);
        this.instanceInformation = this.getHeader();
        if (range != null) {
            this.instanceInformation.setRangeOutputIndices(range);
        }
    }

    public InstanceInformation getStructure() {
        return this.instanceInformation;
    }

    public Instance readInstance() {
        while (this.streamTokenizer.ttype == 10) {
            try {
                this.streamTokenizer.nextToken();
            }
            catch (IOException ex) {
                Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.streamTokenizer.ttype == 123) {
            return this.readInstanceSparse();
        }
        return this.readInstanceDense();
    }

    public Instance readInstanceDense() {
        Instance instance = this.newDenseInstance(this.instanceInformation.numAttributes());
        int numAttribute = 0;
        try {
            while (numAttribute == 0 && this.streamTokenizer.ttype != -1) {
                while (this.streamTokenizer.ttype != 10 && this.streamTokenizer.ttype != -1) {
                    if (this.streamTokenizer.ttype == -2) {
                        this.setValue(instance, numAttribute, this.streamTokenizer.nval, true);
                        ++numAttribute;
                    } else if (this.streamTokenizer.sval != null && (this.streamTokenizer.ttype == -3 || this.streamTokenizer.ttype == 34 || this.streamTokenizer.ttype == 39)) {
                        boolean isNumeric = this.instanceInformation.attribute(numAttribute).isNumeric();
                        double value = "?".equals(this.streamTokenizer.sval) ? Double.NaN : (isNumeric ? Double.valueOf(this.streamTokenizer.sval) : (double)this.instanceInformation.attribute(numAttribute).indexOfValue(this.streamTokenizer.sval));
                        this.setValue(instance, numAttribute, value, isNumeric);
                        ++numAttribute;
                    }
                    this.streamTokenizer.nextToken();
                }
                this.streamTokenizer.nextToken();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return numAttribute > 0 ? instance : null;
    }

    protected void setValue(Instance instance, int numAttribute, double value, boolean isNumber) {
        double valueAttribute = isNumber && this.instanceInformation.attribute((int)numAttribute).isNominal ? (double)this.instanceInformation.attribute(numAttribute).indexOfValue(Double.toString(value)) : value;
        if (this.instanceInformation.classIndex() == numAttribute) {
            this.setClassValue(instance, valueAttribute);
        } else {
            instance.setValue(numAttribute, valueAttribute);
        }
    }

    private Instance readInstanceSparse() {
        Instance instance = this.newSparseInstance(1.0);
        ArrayList<Double> attributeValues = new ArrayList<Double>();
        ArrayList<Integer> indexValues = new ArrayList<Integer>();
        try {
            this.streamTokenizer.nextToken();
            while (this.streamTokenizer.ttype != 10 && this.streamTokenizer.ttype != -1) {
                while (this.streamTokenizer.ttype != 125) {
                    int numAttribute = this.streamTokenizer.ttype == -2 ? (int)this.streamTokenizer.nval : Integer.parseInt(this.streamTokenizer.sval);
                    this.streamTokenizer.nextToken();
                    if (this.streamTokenizer.ttype == -2) {
                        this.setSparseValue(instance, indexValues, attributeValues, numAttribute, this.streamTokenizer.nval, true);
                    } else if (this.streamTokenizer.sval != null && (this.streamTokenizer.ttype == -3 || this.streamTokenizer.ttype == 34)) {
                        if (this.auxAttributes.get(numAttribute).isNumeric()) {
                            this.setSparseValue(instance, indexValues, attributeValues, numAttribute, Double.valueOf(this.streamTokenizer.sval), true);
                        } else {
                            this.setSparseValue(instance, indexValues, attributeValues, numAttribute, this.instanceInformation.attribute(numAttribute).indexOfValue(this.streamTokenizer.sval), false);
                        }
                    }
                    this.streamTokenizer.nextToken();
                }
                this.streamTokenizer.nextToken();
            }
            this.streamTokenizer.nextToken();
        }
        catch (IOException ex) {
            Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        int[] arrayIndexValues = new int[attributeValues.size()];
        double[] arrayAttributeValues = new double[attributeValues.size()];
        for (int i = 0; i < arrayIndexValues.length; ++i) {
            arrayIndexValues[i] = (Integer)indexValues.get(i);
            arrayAttributeValues[i] = (Double)attributeValues.get(i);
        }
        instance.addSparseValues(arrayIndexValues, arrayAttributeValues, this.instanceInformation.numAttributes());
        return instance;
    }

    private void setSparseValue(Instance instance, List<Integer> indexValues, List<Double> attributeValues, int numAttribute, double value, boolean isNumber) {
        double valueAttribute = isNumber && this.instanceInformation.attribute((int)numAttribute).isNominal ? (double)this.instanceInformation.attribute(numAttribute).indexOfValue(Double.toString(value)) : value;
        indexValues.add(numAttribute);
        attributeValues.add(valueAttribute);
    }

    private Instance readDenseInstanceSparse() {
        Instance instance = this.newDenseInstance(this.instanceInformation.numAttributes());
        try {
            this.streamTokenizer.nextToken();
            while (this.streamTokenizer.ttype != 10 && this.streamTokenizer.ttype != -1) {
                while (this.streamTokenizer.ttype != 125) {
                    int numAttribute = (int)this.streamTokenizer.nval;
                    this.streamTokenizer.nextToken();
                    if (this.streamTokenizer.ttype == -2) {
                        this.setValue(instance, numAttribute, this.streamTokenizer.nval, true);
                    } else if (this.streamTokenizer.sval != null && (this.streamTokenizer.ttype == -3 || this.streamTokenizer.ttype == 34)) {
                        if (this.auxAttributes.get(numAttribute).isNumeric()) {
                            this.setValue(instance, numAttribute, Double.valueOf(this.streamTokenizer.sval), true);
                        } else {
                            this.setValue(instance, numAttribute, this.instanceInformation.attribute(numAttribute).indexOfValue(this.streamTokenizer.sval), false);
                        }
                    }
                    this.streamTokenizer.nextToken();
                }
                this.streamTokenizer.nextToken();
            }
            this.streamTokenizer.nextToken();
        }
        catch (IOException ex) {
            Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return instance;
    }

    private InstanceInformation getHeader() {
        String relation = "file stream";
        this.auxAttributes = new ArrayList<Attribute>();
        int numAttributes = 0;
        try {
            this.streamTokenizer.nextToken();
            while (this.streamTokenizer.ttype != -1) {
                if (this.streamTokenizer.ttype == -3 && this.streamTokenizer.sval.startsWith("@")) {
                    String token = this.streamTokenizer.sval.toUpperCase();
                    if (token.startsWith("@RELATION")) {
                        this.streamTokenizer.nextToken();
                        relation = this.streamTokenizer.sval;
                    } else if (token.startsWith("@ATTRIBUTE")) {
                        this.streamTokenizer.nextToken();
                        String name = this.streamTokenizer.sval;
                        if (name == null) {
                            name = Double.toString(this.streamTokenizer.nval);
                        }
                        this.streamTokenizer.nextToken();
                        String type = this.streamTokenizer.sval;
                        if (this.streamTokenizer.ttype == 123) {
                            this.streamTokenizer.nextToken();
                            ArrayList<String> attributeLabels = new ArrayList<String>();
                            while (this.streamTokenizer.ttype != 125) {
                                if (this.streamTokenizer.sval != null) {
                                    attributeLabels.add(this.streamTokenizer.sval);
                                } else {
                                    attributeLabels.add(Double.toString(this.streamTokenizer.nval));
                                }
                                this.streamTokenizer.nextToken();
                            }
                            this.auxAttributes.add(new Attribute(name, attributeLabels));
                            ++numAttributes;
                        } else {
                            this.auxAttributes.add(new Attribute(name));
                            ++numAttributes;
                        }
                    } else if (token.startsWith("@DATA")) {
                        this.streamTokenizer.nextToken();
                        break;
                    }
                }
                this.streamTokenizer.nextToken();
            }
            if (this.range != null) {
                this.range.setUpper(numAttributes);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ArffLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new InstanceInformation(relation, this.auxAttributes);
    }

    protected Instance newSparseInstance(double d, double[] res) {
        SparseInstance inst = new SparseInstance(d, res);
        return inst;
    }

    protected Instance newSparseInstance(double d) {
        SparseInstance inst = new SparseInstance(d);
        return inst;
    }

    protected Instance newDenseInstance(int numberAttributes) {
        DenseInstance inst = new DenseInstance((double)numberAttributes);
        return inst;
    }

    private void setClassValue(Instance instance, double valueAttribute) {
        instance.setValue(this.instanceInformation.classIndex(), valueAttribute);
    }
}

