/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees.iadem;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.github.javacliparser.MultiChoiceOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.MultiClassClassifier;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.conditionaltests.NominalAttributeBinaryTest;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.classifiers.trees.iadem.IademAttributeSplitSuggestion;
import moa.classifiers.trees.iadem.IademCommonProcedures;
import moa.classifiers.trees.iadem.IademException;
import moa.classifiers.trees.iadem.IademNominalAttributeBinaryTest;
import moa.classifiers.trees.iadem.IademNominalAttributeMultiwayTest;
import moa.classifiers.trees.iadem.IademNumericAttributeBinaryTest;
import moa.classifiers.trees.iadem.IademNumericAttributeObserver;
import moa.classifiers.trees.iadem.IademSplitCriterion;
import moa.classifiers.trees.iadem.IademVFMLNumericAttributeClassObserver;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.Utils;
import moa.options.ClassOption;

public class Iadem2
extends AbstractClassifier
implements MultiClassClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption numericEstimatorOption = new ClassOption("numericEstimator", 'z', "Numeric estimator to use.", IademNumericAttributeObserver.class, "IademGaussianNumericAttributeClassObserver");
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'n', "The number of instances the tree should observe between splitting attempts.", 100, 1, Integer.MAX_VALUE);
    public MultiChoiceOption splitCriterionOption = new MultiChoiceOption("splitCriterion", 's', "Split criterion to use.", new String[]{"entropy", "entropy_logVar", "entropy_logVar+Peso", "entropy_Peso", "beta1", "gamma1", "beta2", "gamma2", "beta4", "gamma4"}, new String[]{"entropy", "entropy_logVar", "entropy_logVar+Peso", "entropy_Peso", "beta1", "gamma1", "beta2", "gamma2", "beta4", "gamma4"}, 0);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "The allowable error in split decision, values closer to 0 will take longer to decide.", 0.01, 0.0, 1.0);
    public MultiChoiceOption splitTestsOption = new MultiChoiceOption("splitChoice", 'i', "Methods for splitting leaf nodes.", new String[]{"onlyBinarySplit", "onlyMultiwaySplit", "bestSplit"}, new String[]{"onlyBinary", "onlyMultiway", "bestSplit"}, 2);
    public MultiChoiceOption leafPredictionOption = new MultiChoiceOption("leafPrediction", 'b', "Leaf prediction to use.", new String[]{"MC", "NB", "NBKirkby", "WeightedVote"}, new String[]{"MC: Majority class.", "NB: Na\u00efve Bayes.", "NBKirkby.", "WeightedVote: Weighted vote between NB and MC."}, 1);
    public ClassOption driftDetectionMethodOption = new ClassOption("driftDetectionMethod", 'd', "Drift detection method to use.", AbstractChangeDetector.class, "HDDM_A_Test");
    public FloatOption attributeDiferentiation = new FloatOption("attritubeDiferentiation", 'a', "Attribute differenciation", 0.1, 0.0, 1.0);
    public final int naiveBayesLimit = 0;
    public final double percentInCommon = 0.75;
    protected int numberOfInstancesProcessed = 0;
    public static final double ERROR_MARGIN = 1.0E-9;
    protected Node treeRoot;
    protected AbstractChangeDetector estimator;
    public int numberOfNodes = 1;
    public int numberOfLeaves = 1;

    @Override
    public boolean isRandomizable() {
        return false;
    }

    @Override
    public void resetLearningImpl() {
        this.numberOfInstancesProcessed = 0;
        this.treeRoot = null;
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        if (this.treeRoot == null) {
            IademCommonProcedures.setConfidence(this.splitConfidenceOption.getValue());
            this.estimator = (AbstractChangeDetector)((AbstractChangeDetector)this.getPreparedClassOption(this.driftDetectionMethodOption)).copy();
            this.createRoot(inst);
        }
        try {
            this.learnFromInstance(inst);
        }
        catch (IademException ex) {
            Logger.getLogger(Iadem2.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected IademNumericAttributeObserver newNumericClassObserver() {
        IademNumericAttributeObserver numericClassObserver = (IademNumericAttributeObserver)this.getPreparedClassOption(this.numericEstimatorOption);
        return (IademNumericAttributeObserver)numericClassObserver.copy();
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("tree size (nodes)", this.getNumberOfNodes()), new Measurement("tree size (leaves)", this.getNumberOfLeaves())};
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        if (this.treeRoot == null) {
            DoubleVector classVotes = new DoubleVector();
            double estimation = 1.0 / (double)inst.classAttribute().numValues();
            for (int i = 0; i < inst.classAttribute().numValues(); ++i) {
                classVotes.addToValue(i, estimation);
            }
            return classVotes.getArrayCopy();
        }
        DoubleVector predicciones = new DoubleVector(this.treeRoot.getClassVotes(inst));
        return predicciones.getArrayCopy();
    }

    public AbstractChangeDetector newEstimator() {
        return (AbstractChangeDetector)this.estimator.copy();
    }

    public void createRoot(Instance instance) {
        double[] arrayCounter = new double[instance.numClasses()];
        Arrays.fill(arrayCounter, 0.0);
        this.treeRoot = this.newLeafNode(null, 0L, 0L, arrayCounter, instance);
    }

    public int getMaxNumberOfBins() {
        return (int)this.newNumericClassObserver().getMaxOfValues();
    }

    public IademNumericAttributeObserver getNumericAttObserver() {
        return this.newNumericClassObserver();
    }

    public long getNumberOfInstancesProcessed() {
        return this.numberOfInstancesProcessed;
    }

    public LeafNode newLeafNode(Node parent, long instTreeCountSinceVirtual, long instNodeCountSinceVirtual, double[] classDist, Instance instance) {
        switch (this.leafPredictionOption.getChosenIndex()) {
            case 0: {
                return new LeafNode(this, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, classDist, this.newNumericClassObserver(), this.splitTestsOption.getChosenIndex() == 2, this.splitTestsOption.getChosenIndex() == 0, instance);
            }
            case 1: {
                return new LeafNodeNB(this, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, classDist, this.newNumericClassObserver(), this.naiveBayesLimit, this.splitTestsOption.getChosenIndex() == 2, this.splitTestsOption.getChosenIndex() == 0, instance);
            }
            case 2: {
                return new LeafNodeNBKirkby(this, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, classDist, this.newNumericClassObserver(), this.naiveBayesLimit, this.splitTestsOption.getChosenIndex() == 2, this.splitTestsOption.getChosenIndex() == 0, (AbstractChangeDetector)((AbstractChangeDetector)this.getPreparedClassOption(this.driftDetectionMethodOption)).copy(), instance);
            }
        }
        return new LeafNodeWeightedVote(this, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, classDist, this.newNumericClassObserver(), this.naiveBayesLimit, this.splitTestsOption.getChosenIndex() == 2, this.splitTestsOption.getChosenIndex() == 0, (AbstractChangeDetector)((AbstractChangeDetector)this.getPreparedClassOption(this.driftDetectionMethodOption)).copy(), instance);
    }

    public double getAttributeDifferentiation() {
        return this.attributeDiferentiation.getValue();
    }

    public IademSplitCriterion getMeasure() throws IademException {
        return new IademSplitCriterion(this.splitCriterionOption.getChosenLabel());
    }

    public void setTreeRoot(Node newRoot) {
        this.treeRoot = newRoot;
    }

    public void learnFromInstance(Instance instance) throws IademException {
        ++this.numberOfInstancesProcessed;
        this.treeRoot.learnFromInstance(instance);
    }

    public Node getTreeRoot() {
        return this.treeRoot;
    }

    public double[] getClassVotes(Instance instance) {
        return this.treeRoot.getClassVotes(instance);
    }

    public double getPercentInCommon() {
        return this.percentInCommon;
    }

    public int getValuesOfNominalAttributes(int attIndex, Instance instance) {
        return instance.attribute(attIndex).numValues();
    }

    public int getNaiveBayesLimit() {
        return this.naiveBayesLimit;
    }

    public boolean isOnlyMultiwayTest() {
        return this.splitTestsOption.getChosenIndex() == 2;
    }

    public boolean isOnlyBinaryTest() {
        return this.splitTestsOption.getChosenIndex() == 0;
    }

    public void incrNumberOfInstancesProcessed() {
        ++this.numberOfInstancesProcessed;
    }

    public void getNumberOfNodes(int[] count) {
        this.treeRoot.getNumberOfNodes(count);
    }

    public void newSplit(int numOfLeaves) {
        this.numberOfLeaves += numOfLeaves - 1;
        this.numberOfNodes += numOfLeaves;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setNumberOfNodes(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public int getNumberOfLeaves() {
        return this.numberOfLeaves;
    }

    public void setNumberOfLeaves(int numberOfLeaves) {
        this.numberOfLeaves = numberOfLeaves;
    }

    public class SplitNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public InstanceConditionalTest splitTest;
        public AutoExpandVector<Node> children;

        public SplitNode(Iadem2 tree, Node parent, Node[] children, double[] initialClassCount, InstanceConditionalTest splitTest) {
            super(tree, parent, initialClassCount);
            this.children = new AutoExpandVector();
            this.splitTest = splitTest;
            this.setChildren(children);
        }

        public InstanceConditionalTest getSplitTest() {
            return this.splitTest;
        }

        public void setChild(Node child, int index) {
            if (this.splitTest.maxBranches() >= 0 && index >= this.splitTest.maxBranches()) {
                throw new IndexOutOfBoundsException();
            }
            this.children.set(index, child);
        }

        @Override
        public int getSubtreeNodeCount() {
            int count = 1;
            for (Node currentChild : this.children) {
                count += currentChild.getSubtreeNodeCount();
            }
            return count;
        }

        @Override
        public ArrayList<LeafNode> getLeaves() {
            ArrayList<LeafNode> leaves = new ArrayList<LeafNode>();
            for (Node currentChild : this.children) {
                leaves.addAll(currentChild.getLeaves());
            }
            return leaves;
        }

        public void changeChildren(Node oldChild, Node newChild) {
            boolean found = false;
            for (int pos = 0; !found && pos < this.children.size(); ++pos) {
                if (!this.children.get(pos).equals(oldChild)) continue;
                found = true;
                this.children.set(pos, newChild);
            }
        }

        public int instanceChildIndex(Instance inst) {
            return this.splitTest.branchForInstance(inst);
        }

        public Node getChild(int index) {
            return this.children.get(index);
        }

        public final void setChildren(Node[] children) {
            this.children.clear();
            if (children != null) {
                this.children.addAll((Collection<Node>)Arrays.asList(children));
            }
        }

        public void setChild(AutoExpandVector<Node> children) {
            this.children.clear();
            this.children.addAll((Collection<Node>)children);
        }

        @Override
        public Node learnFromInstance(Instance inst) {
            Node child;
            int childIndex = this.instanceChildIndex(inst);
            if (childIndex >= 0 && (child = this.getChild(childIndex)) != null) {
                return child.learnFromInstance(inst);
            }
            return null;
        }

        @Override
        public double[] getClassVotes(Instance inst) {
            int childIndex = this.instanceChildIndex(inst);
            if (childIndex >= 0) {
                Node currentChild = this.getChild(childIndex);
                return currentChild.getClassVotes(inst);
            }
            return this.classValueDist.getArrayCopy();
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        public void removeChild(Node child) {
            this.children.remove(child);
        }

        public void addChild(Node child) {
            this.children.add(child);
        }

        @Override
        public void getNumberOfNodes(int[] count) {
            count[0] = count[0] + 1;
            for (Node child : this.children) {
                child.getNumberOfNodes(count);
            }
        }
    }

    public class NumericVirtualNode
    extends VirtualNode {
        private static final long serialVersionUID = 1L;
        private static final int MAX_BINS_EQUAL_WIDTH = 10;
        protected IademNumericAttributeObserver numericAttClassObserver;
        protected double bestCutPoint;

        public NumericVirtualNode(Iadem2 tree, Node parent, int attIndex, IademNumericAttributeObserver numericAttClassObs) {
            super(tree, parent, attIndex);
            int numIntervalos = this.tree.getMaxNumberOfBins();
            this.numericAttClassObserver = (IademNumericAttributeObserver)numericAttClassObs.copy();
            this.numericAttClassObserver.setMaxBins(numIntervalos);
            this.bestCutPoint = 0.0;
        }

        public IademNumericAttributeObserver getNumericAttClassObserver() {
            return this.numericAttClassObserver;
        }

        @Override
        public Node learnFromInstance(Instance instance) {
            this.numericAttClassObserver.addValue(instance.value(this.attIndex), (int)instance.value(instance.classIndex()), instance.weight());
            this.classValueDist.addToValue((int)instance.value(instance.classIndex()), instance.weight());
            this.heuristicMeasureUpdated = false;
            return this;
        }

        long arrSum(long[] arr) {
            long count = 0L;
            for (int i = 0; i < arr.length; ++i) {
                count += arr[i];
            }
            return count;
        }

        @Override
        public SplitNode getNewSplitNode(long newTotal, Node parent, IademAttributeSplitSuggestion bestSuggestion, Instance instance) {
            double[] cut = new double[]{this.bestCutPoint};
            Node[] children = new Node[2];
            long[] newClassVotesAndTotal = this.numericAttClassObserver.getLeftClassDist(this.bestCutPoint);
            long totalLeft = this.arrSum(newClassVotesAndTotal);
            long total = this.numericAttClassObserver.getValueCount();
            long[] classVotesTotal = this.numericAttClassObserver.getClassDist();
            boolean equalsPassesTest = true;
            if (this.numericAttClassObserver instanceof IademVFMLNumericAttributeClassObserver) {
                equalsPassesTest = false;
            }
            SplitNode splitNode = new SplitNode(this.tree, parent, null, ((LeafNode)this.parent).getMajorityClassVotes(instance), new IademNumericAttributeBinaryTest(this.attIndex, cut[0], equalsPassesTest));
            long newTotalLeft = totalLeft;
            long newTotalRight = total - newTotalLeft;
            double[] newClassVotesLeft = new double[instance.attribute(instance.classIndex()).numValues()];
            double[] newClassVotesRight = new double[instance.attribute(instance.classIndex()).numValues()];
            Arrays.fill(newClassVotesLeft, 0.0);
            Arrays.fill(newClassVotesRight, 0.0);
            for (int i = 0; i < newClassVotesAndTotal.length; ++i) {
                newClassVotesLeft[i] = newClassVotesAndTotal[i];
                newClassVotesRight[i] = (double)classVotesTotal[i] - newClassVotesLeft[i];
            }
            splitNode.setChildren(null);
            children[0] = this.tree.newLeafNode(splitNode, newTotal, newTotalLeft, newClassVotesLeft, instance);
            children[1] = this.tree.newLeafNode(splitNode, newTotal, newTotalRight, newClassVotesRight, instance);
            splitNode.setChildren(children);
            return splitNode;
        }

        @Override
        public void updateHeuristicMeasure(Instance instance) throws IademException {
            if (!this.heuristicMeasureUpdated) {
                if (this.numericAttClassObserver.getNumberOfCutPoints() < 2L) {
                    this.bestSplitSuggestion = null;
                } else {
                    IademSplitCriterion measure = ((LeafNode)this.parent).getTree().getMeasure();
                    int numberOfClasses = instance.attribute(instance.classIndex()).numValues();
                    int numberOfSplits = 2;
                    int numberOfCuts = (int)this.numericAttClassObserver.getNumberOfCutPoints();
                    double[] measureLower = new double[numberOfCuts];
                    double[] measureUpper = new double[numberOfCuts];
                    double[][][] classVotesPerCutAndSplit_lower = new double[numberOfCuts][numberOfSplits][numberOfClasses];
                    double[][][] classVotesPerCutAndSplit_upper = new double[numberOfCuts][numberOfSplits][numberOfClasses];
                    double[][] totalPerCutAndSplit = new double[numberOfCuts][numberOfSplits];
                    this.computeClassVoteBounds(classVotesPerCutAndSplit_lower, classVotesPerCutAndSplit_upper, totalPerCutAndSplit, true);
                    for (int k = 0; k < numberOfCuts; ++k) {
                        int i;
                        double[] countPerSplit_lower = new double[numberOfSplits];
                        double[] availableErrorPerSplit = new double[numberOfSplits];
                        Arrays.fill(countPerSplit_lower, 0.0);
                        for (int i2 = 0; i2 < numberOfSplits; ++i2) {
                            for (int j = 0; j < numberOfClasses; ++j) {
                                int n = i2;
                                countPerSplit_lower[n] = countPerSplit_lower[n] + classVotesPerCutAndSplit_lower[k][i2][j];
                            }
                            availableErrorPerSplit[i2] = 1.0 - countPerSplit_lower[i2];
                            if (!(availableErrorPerSplit[i2] < 0.0)) continue;
                            if (Math.abs(availableErrorPerSplit[i2]) < 1.0E-9) {
                                availableErrorPerSplit[i2] = 0.0;
                                continue;
                            }
                            throw new IademException("NumericVirtualNode", "updateHeuristicMeasure", "Problems when calculating measures");
                        }
                        double[] measurePerSplit_upper = new double[numberOfSplits];
                        double[] splitLevels = new double[numberOfSplits];
                        for (i = 0; i < numberOfSplits; ++i) {
                            ArrayList<Double> lot = new ArrayList<Double>();
                            lot.add(0.0);
                            lot.add(1.0);
                            ArrayList<Integer> hole = new ArrayList<Integer>();
                            hole.add(0);
                            for (int j = 0; j < numberOfClasses; ++j) {
                                IademCommonProcedures.insertLotsHoles(lot, hole, classVotesPerCutAndSplit_lower[k][i][j], classVotesPerCutAndSplit_upper[k][i][j]);
                            }
                            splitLevels[i] = IademCommonProcedures.computeLevel(lot, hole, availableErrorPerSplit[i]);
                        }
                        for (i = 0; i < numberOfSplits; ++i) {
                            ArrayList<Double> vectorToMeasure = new ArrayList<Double>();
                            for (int j = 0; j < numberOfClasses; ++j) {
                                double tmpMeasureUpper = Math.max(splitLevels[i], classVotesPerCutAndSplit_lower[k][i][j]);
                                tmpMeasureUpper = Math.min(classVotesPerCutAndSplit_upper[k][i][j], tmpMeasureUpper);
                                vectorToMeasure.add(tmpMeasureUpper);
                            }
                            measurePerSplit_upper[i] = measure.doMeasure(vectorToMeasure);
                        }
                        double[] measurePerSplit_lower = new double[numberOfSplits];
                        for (int i3 = 0; i3 < numberOfSplits; ++i3) {
                            double availableProb = availableErrorPerSplit[i3];
                            ArrayList<Integer> decOrderClassVotes_upper = new ArrayList<Integer>();
                            ArrayList<Integer> unusedClasses = new ArrayList<Integer>();
                            for (int j = 0; j < numberOfClasses; ++j) {
                                unusedClasses.add(j);
                            }
                            double auxAvailable = availableErrorPerSplit[i3];
                            for (int j = 0; j < numberOfClasses; ++j) {
                                if (auxAvailable < 0.0) {
                                    if (Math.abs(auxAvailable) < 1.0E-9) {
                                        auxAvailable = 0.0;
                                    } else {
                                        throw new IademException("NodoVirtualContinuo", "actualizaMedida", "Problems calculating measure");
                                    }
                                }
                                int classIndex = this.getClassValueProbabilities(i3, unusedClasses, classVotesPerCutAndSplit_lower[k], classVotesPerCutAndSplit_upper[k], auxAvailable);
                                double probUpper = Math.min(classVotesPerCutAndSplit_upper[k][i3][classIndex], classVotesPerCutAndSplit_lower[k][i3][classIndex] + auxAvailable);
                                auxAvailable -= probUpper - classVotesPerCutAndSplit_lower[k][i3][classIndex];
                                unusedClasses.remove(new Integer(classIndex));
                                decOrderClassVotes_upper.add(new Integer(classIndex));
                            }
                            ArrayList<Double> vectorToMeasure = new ArrayList<Double>();
                            for (int j = 0; j < decOrderClassVotes_upper.size(); ++j) {
                                int classIndex = (Integer)decOrderClassVotes_upper.get(j);
                                if (availableProb < 0.0) {
                                    if (Math.abs(availableProb) < 1.0E-9) {
                                        availableProb = 0.0;
                                    } else {
                                        throw new IademException("NumericVirtualNode", "updateMeasure", "Problems when calculating measures");
                                    }
                                }
                                double probUpper = Math.min(classVotesPerCutAndSplit_upper[k][i3][classIndex], classVotesPerCutAndSplit_lower[k][i3][classIndex] + availableProb);
                                availableProb -= probUpper - classVotesPerCutAndSplit_lower[k][i3][classIndex];
                                vectorToMeasure.add(probUpper);
                            }
                            measurePerSplit_lower[i3] = measure.doMeasure(vectorToMeasure);
                        }
                        double dividendUpper = 0.0;
                        double dividendLower = 0.0;
                        double divisor = 0.0;
                        for (int i4 = 0; i4 < totalPerCutAndSplit[k].length; ++i4) {
                            dividendUpper += measurePerSplit_upper[i4] * totalPerCutAndSplit[k][i4];
                            dividendLower += measurePerSplit_lower[i4] * totalPerCutAndSplit[k][i4];
                            divisor += totalPerCutAndSplit[k][i4];
                        }
                        measureLower[k] = dividendLower / divisor;
                        measureUpper[k] = dividendUpper / divisor;
                    }
                    ArrayList<Integer> indMinSupMedida = new ArrayList<Integer>();
                    double minSupMedida = measureUpper[0];
                    indMinSupMedida.add(0);
                    for (int i = 1; i < measureUpper.length; ++i) {
                        if (measureUpper[i] < minSupMedida) {
                            minSupMedida = measureUpper[i];
                            indMinSupMedida.clear();
                            indMinSupMedida.add(i);
                            continue;
                        }
                        if (measureUpper[i] != minSupMedida) continue;
                        indMinSupMedida.add(i);
                    }
                    Iterator iterator = indMinSupMedida.iterator();
                    Integer element = (Integer)iterator.next();
                    int minMeasureLowerIndex = element;
                    double minMeasureLower = measureLower[element];
                    while (iterator.hasNext()) {
                        element = (Integer)iterator.next();
                        if (!(measureLower[element] < minMeasureLower)) continue;
                        minMeasureLower = measureLower[element];
                        minMeasureLowerIndex = element;
                    }
                    this.bestCutPoint = this.numericAttClassObserver.getCut(minMeasureLowerIndex);
                    boolean equalsPassesTest = true;
                    if (this.numericAttClassObserver instanceof IademVFMLNumericAttributeClassObserver) {
                        equalsPassesTest = false;
                    }
                    IademNumericAttributeBinaryTest test = new IademNumericAttributeBinaryTest(this.attIndex, this.bestCutPoint, equalsPassesTest);
                    this.bestSplitSuggestion = new IademAttributeSplitSuggestion(test, new double[0][0], minSupMedida, minMeasureLower);
                }
                this.heuristicMeasureUpdated = true;
            }
        }

        private void computeClassVoteBounds(double[][][] classVotesPerCutAndSplit_lower, double[][][] classVotesPerCutAndSplit_upper, double[][] totalPerCutAndSplit, boolean withIntervalEstimates) {
            this.numericAttClassObserver.computeClassDistProbabilities(classVotesPerCutAndSplit_lower, classVotesPerCutAndSplit_upper, totalPerCutAndSplit, withIntervalEstimates);
        }

        private int getClassValueProbabilities(int value, ArrayList<Integer> valueList, double[][] classValuePerSplitLower, double[][] classValuePerSplitUpper, double availableProb) {
            if (valueList.isEmpty()) {
                return -1;
            }
            int max = valueList.get(0);
            double max_up = Math.min(classValuePerSplitUpper[value][max], classValuePerSplitLower[value][max] + availableProb);
            for (int i = 1; i < valueList.size(); ++i) {
                int newValue = valueList.get(i);
                double newValue_up = Math.min(classValuePerSplitUpper[value][newValue], classValuePerSplitLower[value][newValue] + availableProb);
                if (!(newValue_up > max_up)) continue;
                max = newValue;
                max_up = newValue_up;
            }
            return max;
        }

        @Override
        public boolean hasInformation() {
            return this.numericAttClassObserver.getNumberOfCutPoints() > 1L;
        }

        private ArrayList<Double> getCuts() {
            return this.numericAttClassObserver.cutPointSuggestion(10);
        }

        @Override
        public double getPercent() {
            double total;
            long[] classVotesLeft = this.numericAttClassObserver.getLeftClassDist(this.bestCutPoint);
            double leftCount = this.arrSum(classVotesLeft);
            double leftPercent = leftCount / (total = (double)this.numericAttClassObserver.getValueCount());
            double rightPercent = 1.0 - leftPercent;
            if (rightPercent < leftPercent) {
                return rightPercent;
            }
            return leftPercent;
        }

        @Override
        public DoubleVector computeConditionalProbability(double value) {
            ArrayList<Double> cut = this.getCuts();
            return new DoubleVector(this.numericAttClassObserver.computeConditionalProb(cut, value));
        }

        @Override
        public void getNumberOfNodes(int[] count) {
            count[1] = count[1] + 1;
        }
    }

    public class NominalVirtualNode
    extends VirtualNode {
        private static final long serialVersionUID = 1L;
        protected AutoExpandVector<DoubleVector> nominalAttClassObserver;
        protected DoubleVector attValueDist;
        protected boolean onlyMultiwayTest;
        protected boolean onlyBinaryTest;

        public NominalVirtualNode(Iadem2 tree, Node parent, int attIndex, boolean onlyMultiwayTest, boolean onlyBinaryTest) {
            super(tree, parent, attIndex);
            this.nominalAttClassObserver = new AutoExpandVector();
            this.onlyMultiwayTest = false;
            this.onlyBinaryTest = false;
            this.attValueDist = new DoubleVector();
            this.onlyMultiwayTest = onlyMultiwayTest;
            this.onlyBinaryTest = onlyBinaryTest;
        }

        public AutoExpandVector<DoubleVector> getNominalAttClassObserver() {
            return this.nominalAttClassObserver;
        }

        @Override
        public Node learnFromInstance(Instance inst) {
            double attValue = inst.value(this.attIndex);
            if (!Utils.isMissingValue(attValue)) {
                int intAttValue = (int)attValue;
                this.attValueDist.addToValue(intAttValue, inst.weight());
                this.classValueDist.addToValue((int)inst.value(inst.classIndex()), inst.weight());
                DoubleVector valDist = this.nominalAttClassObserver.get(intAttValue);
                if (valDist == null) {
                    valDist = new DoubleVector();
                    this.nominalAttClassObserver.set(intAttValue, valDist);
                }
                int classValue = (int)inst.classValue();
                valDist.addToValue(classValue, inst.weight());
                this.heuristicMeasureUpdated = false;
            }
            return this;
        }

        @Override
        public SplitNode getNewSplitNode(long newTotal, Node parent, IademAttributeSplitSuggestion bestSuggestion, Instance instance) {
            Node[] children;
            SplitNode splitNode = new SplitNode(this.tree, parent, null, ((LeafNode)this.parent).getMajorityClassVotes(instance), bestSuggestion.splitTest);
            if (bestSuggestion.splitTest instanceof IademNominalAttributeMultiwayTest) {
                children = new Node[instance.attribute(this.attIndex).numValues()];
                for (int i = 0; i < children.length; ++i) {
                    long count = 0L;
                    double[] tmpClassDist = new double[instance.attribute(instance.classIndex()).numValues()];
                    Arrays.fill(tmpClassDist, 0.0);
                    for (int j = 0; j < tmpClassDist.length; ++j) {
                        double contadorAtributoClase;
                        DoubleVector classCount = this.nominalAttClassObserver.get(i);
                        tmpClassDist[j] = contadorAtributoClase = classCount != null ? classCount.getValue(j) : 0.0;
                        count = (long)((double)count + tmpClassDist[j]);
                    }
                    children[i] = this.tree.newLeafNode(splitNode, newTotal, count, tmpClassDist, instance);
                }
            } else {
                int i;
                children = new Node[2];
                IademNominalAttributeBinaryTest binarySplit = (IademNominalAttributeBinaryTest)bestSuggestion.splitTest;
                double[] tmpClassDist = new double[instance.attribute(instance.classIndex()).numValues()];
                double tmpCount = 0.0;
                Arrays.fill(tmpClassDist, 0.0);
                DoubleVector classDist = this.nominalAttClassObserver.get(binarySplit.getAttValue());
                if (classDist != null) {
                    for (i = 0; i < tmpClassDist.length; ++i) {
                        tmpClassDist[i] = classDist.getValue(i);
                        tmpCount += classDist.getValue(i);
                    }
                }
                children[0] = this.tree.newLeafNode(splitNode, newTotal, (int)tmpCount, tmpClassDist, instance);
                tmpCount = this.classValueDist.sumOfValues() - tmpCount;
                for (i = 0; i < tmpClassDist.length; ++i) {
                    tmpClassDist[i] = this.classValueDist.getValue(i) - tmpClassDist[i];
                }
                children[1] = this.tree.newLeafNode(splitNode, newTotal, (int)tmpCount, tmpClassDist, instance);
            }
            splitNode.setChildren(children);
            return splitNode;
        }

        protected boolean moreThanOneAttValueObserved() {
            int count = 0;
            for (DoubleVector tmpClassDist : this.nominalAttClassObserver) {
                if (tmpClassDist != null) {
                    ++count;
                }
                if (count <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public void updateHeuristicMeasure(Instance instance) throws IademException {
            if (this.moreThanOneAttValueObserved()) {
                if (!this.onlyBinaryTest) {
                    this.updateHeuristicMeasureMultiwayTest(instance);
                }
                if (!this.onlyMultiwayTest) {
                    this.updateHeuristicMeasureBinaryTest(instance);
                }
            } else {
                this.bestSplitSuggestion = null;
            }
            this.heuristicMeasureUpdated = true;
        }

        public void updateHeuristicMeasureBinaryTest(Instance instance) throws IademException {
            if (!this.heuristicMeasureUpdated) {
                IademSplitCriterion measure = this.tree.getMeasure();
                if (this.bestSplitSuggestion != null && this.bestSplitSuggestion.splitTest instanceof NominalAttributeBinaryTest) {
                    this.bestSplitSuggestion = null;
                }
                int numberOfSplits = 2;
                int numberOfTests = this.tree.getValuesOfNominalAttributes(this.attIndex, instance);
                int numberOfClasses = instance.attribute(instance.classIndex()).numValues();
                double[][][] classDistPerTestAndSplit_lower = new double[numberOfTests][numberOfSplits][numberOfClasses];
                double[][][] classDistPerTestAndSplit_upper = new double[numberOfTests][numberOfSplits][numberOfClasses];
                this.computeClassDistBinaryTest(classDistPerTestAndSplit_lower, classDistPerTestAndSplit_upper);
                for (int k = 0; k < numberOfTests; ++k) {
                    IademNominalAttributeBinaryTest test;
                    DoubleVector tmpClassDist;
                    int i;
                    double[] sumPerSplit_lower = new double[numberOfSplits];
                    double[] availableErrorPerSplit = new double[numberOfSplits];
                    Arrays.fill(sumPerSplit_lower, 0.0);
                    for (int i2 = 0; i2 < numberOfSplits; ++i2) {
                        for (int j = 0; j < numberOfClasses; ++j) {
                            int n = i2;
                            sumPerSplit_lower[n] = sumPerSplit_lower[n] + classDistPerTestAndSplit_lower[k][i2][j];
                        }
                        availableErrorPerSplit[i2] = 1.0 - sumPerSplit_lower[i2];
                        if (!(availableErrorPerSplit[i2] < 0.0)) continue;
                        if (Math.abs(availableErrorPerSplit[i2]) < 1.0E-9) {
                            availableErrorPerSplit[i2] = 0.0;
                            continue;
                        }
                        throw new IademException("NominalVirtualNode", "updateHeuristicMeasureBinaryTest", "Problems when calculating measures");
                    }
                    double[] measurePerSplit_upper = new double[numberOfSplits];
                    double[] valueLevels = new double[numberOfSplits];
                    for (i = 0; i < numberOfSplits; ++i) {
                        ArrayList<Double> lot = new ArrayList<Double>();
                        lot.add(0.0);
                        lot.add(1.0);
                        ArrayList<Integer> hole = new ArrayList<Integer>();
                        hole.add(0);
                        for (int j = 0; j < numberOfClasses; ++j) {
                            IademCommonProcedures.insertLotsHoles(lot, hole, classDistPerTestAndSplit_lower[k][i][j], classDistPerTestAndSplit_upper[k][i][j]);
                        }
                        valueLevels[i] = IademCommonProcedures.computeLevel(lot, hole, availableErrorPerSplit[i]);
                    }
                    for (i = 0; i < numberOfSplits; ++i) {
                        ArrayList<Double> vectorToMeasure = new ArrayList<Double>();
                        for (int j = 0; j < numberOfClasses; ++j) {
                            double measureProb_uppper = Math.max(valueLevels[i], classDistPerTestAndSplit_lower[k][i][j]);
                            measureProb_uppper = Math.min(classDistPerTestAndSplit_upper[k][i][j], measureProb_uppper);
                            vectorToMeasure.add(measureProb_uppper);
                        }
                        measurePerSplit_upper[i] = measure.doMeasure(vectorToMeasure);
                    }
                    double[] measurePerSplit_lower = new double[numberOfSplits];
                    for (int i3 = 0; i3 < numberOfSplits; ++i3) {
                        double tmpAvailable = availableErrorPerSplit[i3];
                        ArrayList<Integer> decOrderClassDist_upper = new ArrayList<Integer>();
                        ArrayList<Integer> unusedClasses = new ArrayList<Integer>();
                        for (int j = 0; j < numberOfClasses; ++j) {
                            unusedClasses.add(j);
                        }
                        double auxAvailable = availableErrorPerSplit[i3];
                        for (int j = 0; j < numberOfClasses; ++j) {
                            if (auxAvailable < 0.0) {
                                if (Math.abs(auxAvailable) < 1.0E-9) {
                                    auxAvailable = 0.0;
                                } else {
                                    throw new IademException("NominalVirtualNode", "updateHeuristicMeasureBinaryTest", "Problems when calculating measures");
                                }
                            }
                            int classIndex = this.getClassProbabilities(i3, unusedClasses, classDistPerTestAndSplit_lower[k], classDistPerTestAndSplit_upper[k], auxAvailable);
                            double probUp = Math.min(classDistPerTestAndSplit_upper[k][i3][classIndex], classDistPerTestAndSplit_lower[k][i3][classIndex] + auxAvailable);
                            auxAvailable -= probUp - classDistPerTestAndSplit_lower[k][i3][classIndex];
                            unusedClasses.remove(new Integer(classIndex));
                            decOrderClassDist_upper.add(new Integer(classIndex));
                        }
                        ArrayList<Double> vectorToMeasure = new ArrayList<Double>();
                        for (int j = 0; j < decOrderClassDist_upper.size(); ++j) {
                            int classIndex = (Integer)decOrderClassDist_upper.get(j);
                            if (tmpAvailable < 0.0) {
                                if (Math.abs(tmpAvailable) < 1.0E-9) {
                                    tmpAvailable = 0.0;
                                } else {
                                    throw new IademException("NominalVirtualNode", "updateHeuristicMeasureBinaryTest", "Problems when calculating measures");
                                }
                            }
                            double probUp = Math.min(classDistPerTestAndSplit_upper[k][i3][classIndex], classDistPerTestAndSplit_lower[k][i3][classIndex] + tmpAvailable);
                            tmpAvailable -= probUp - classDistPerTestAndSplit_lower[k][i3][classIndex];
                            vectorToMeasure.add(probUp);
                        }
                        measurePerSplit_lower[i3] = measure.doMeasure(vectorToMeasure);
                    }
                    double dividendUpper = 0.0;
                    double dividendLower = 0.0;
                    double leftDivUpper = measurePerSplit_upper[0] * this.attValueDist.getValue(k);
                    double leftDivLower = measurePerSplit_lower[0] * this.attValueDist.getValue(k);
                    double divisor = this.classValueDist.sumOfValues();
                    double rightTotal = divisor - this.attValueDist.getValue(k);
                    double rightDivUpper = measurePerSplit_upper[1] * rightTotal;
                    double rightDivLower = measurePerSplit_lower[1] * rightTotal;
                    dividendUpper = leftDivUpper + rightDivUpper;
                    dividendLower = leftDivLower + rightDivLower;
                    if (divisor == 0.0) continue;
                    double measureLower = dividendLower / divisor;
                    double measureUpper = dividendUpper / divisor;
                    if (this.bestSplitSuggestion == null) {
                        tmpClassDist = this.nominalAttClassObserver.get(k);
                        if (tmpClassDist == null) continue;
                        test = new IademNominalAttributeBinaryTest(this.attIndex, k);
                        this.bestSplitSuggestion = new IademAttributeSplitSuggestion(test, new double[0][0], measureUpper, measureLower);
                        continue;
                    }
                    if (this.onlyBinaryTest || !(measureUpper < this.bestSplitSuggestion.merit) && (measureUpper != this.bestSplitSuggestion.merit || !(measureLower < this.bestSplitSuggestion.getMeritLowerBound())) || (tmpClassDist = this.nominalAttClassObserver.get(k)) == null) continue;
                    test = new IademNominalAttributeBinaryTest(this.attIndex, k);
                    this.bestSplitSuggestion = new IademAttributeSplitSuggestion(test, new double[0][0], measureUpper, measureLower);
                }
            }
        }

        protected void computeClassDistBinaryTest(double[][][] classDistPerTestAndSplit_lower, double[][][] classDistPerTestAndSplit_upper) {
            int numberOfClasses = classDistPerTestAndSplit_lower[0][0].length;
            double leftTotal = this.classValueDist.sumOfValues();
            for (int currentAttIndex = 0; currentAttIndex < classDistPerTestAndSplit_lower.length; ++currentAttIndex) {
                for (int j = 0; j < numberOfClasses; ++j) {
                    double bound;
                    double estimator;
                    double attClassCounter;
                    DoubleVector classCounter = this.nominalAttClassObserver.get(currentAttIndex);
                    double d = attClassCounter = classCounter != null ? classCounter.getValue(j) : 0.0;
                    if (this.attValueDist.getValue(currentAttIndex) != 0.0) {
                        estimator = attClassCounter / this.attValueDist.getValue(currentAttIndex);
                        bound = IademCommonProcedures.getIADEM_HoeffdingBound(estimator, this.attValueDist.getValue(currentAttIndex));
                        classDistPerTestAndSplit_lower[currentAttIndex][0][j] = Math.max(0.0, estimator - bound);
                        classDistPerTestAndSplit_upper[currentAttIndex][0][j] = Math.min(1.0, estimator + bound);
                    } else {
                        classDistPerTestAndSplit_lower[currentAttIndex][0][j] = 0.0;
                        classDistPerTestAndSplit_upper[currentAttIndex][0][j] = 1.0;
                    }
                    attClassCounter = this.classValueDist.getValue(j) - attClassCounter;
                    double rightTotal = leftTotal - this.attValueDist.getValue(currentAttIndex);
                    if (rightTotal != 0.0) {
                        estimator = attClassCounter / rightTotal;
                        bound = IademCommonProcedures.getIADEM_HoeffdingBound(estimator, rightTotal);
                        classDistPerTestAndSplit_lower[currentAttIndex][1][j] = Math.max(0.0, estimator - bound);
                        classDistPerTestAndSplit_upper[currentAttIndex][1][j] = Math.min(1.0, estimator + bound);
                        continue;
                    }
                    classDistPerTestAndSplit_lower[currentAttIndex][1][j] = 0.0;
                    classDistPerTestAndSplit_upper[currentAttIndex][1][j] = 1.0;
                }
            }
        }

        public void updateHeuristicMeasureMultiwayTest(Instance instance) throws IademException {
            if (!this.heuristicMeasureUpdated) {
                int i;
                this.bestSplitSuggestion = null;
                IademSplitCriterion measure = this.tree.getMeasure();
                int numberOfValues = this.tree.getValuesOfNominalAttributes(this.attIndex, instance);
                int numberOfClasses = instance.attribute(instance.classIndex()).numValues();
                double[][] classDist_lower = new double[numberOfValues][numberOfClasses];
                double[][] classDist_upper = new double[numberOfValues][numberOfClasses];
                this.computeClassDistPerValue(classDist_lower, classDist_upper);
                double[] sumPerValue_lower = new double[numberOfValues];
                double[] availableErrorPerValue = new double[numberOfValues];
                Arrays.fill(sumPerValue_lower, 0.0);
                for (int i2 = 0; i2 < numberOfValues; ++i2) {
                    for (int j = 0; j < numberOfClasses; ++j) {
                        int n = i2;
                        sumPerValue_lower[n] = sumPerValue_lower[n] + classDist_lower[i2][j];
                    }
                    availableErrorPerValue[i2] = 1.0 - sumPerValue_lower[i2];
                    if (!(availableErrorPerValue[i2] < 0.0)) continue;
                    if (Math.abs(availableErrorPerValue[i2]) < 1.0E-9) {
                        availableErrorPerValue[i2] = 0.0;
                        continue;
                    }
                    throw new IademException("NominalVirtualNode", "updateHeuristicMeasureMultiwayTest", "Problems when calculating measures");
                }
                double[] measuerPerValue_upper = new double[numberOfValues];
                double[] valueLevels = new double[numberOfValues];
                for (i = 0; i < numberOfValues; ++i) {
                    ArrayList<Double> lot = new ArrayList<Double>();
                    lot.add(0.0);
                    lot.add(1.0);
                    ArrayList<Integer> hole = new ArrayList<Integer>();
                    hole.add(0);
                    for (int j = 0; j < numberOfClasses; ++j) {
                        IademCommonProcedures.insertLotsHoles(lot, hole, classDist_lower[i][j], classDist_upper[i][j]);
                    }
                    valueLevels[i] = IademCommonProcedures.computeLevel(lot, hole, availableErrorPerValue[i]);
                }
                for (i = 0; i < numberOfValues; ++i) {
                    ArrayList<Double> vectorToMeasure = new ArrayList<Double>();
                    for (int j = 0; j < numberOfClasses; ++j) {
                        double p_sup_medida = Math.max(valueLevels[i], classDist_lower[i][j]);
                        p_sup_medida = Math.min(classDist_upper[i][j], p_sup_medida);
                        vectorToMeasure.add(p_sup_medida);
                    }
                    measuerPerValue_upper[i] = measure.doMeasure(vectorToMeasure);
                }
                double[] measurePerValue_lower = new double[numberOfValues];
                for (int i3 = 0; i3 < numberOfValues; ++i3) {
                    double availableError = availableErrorPerValue[i3];
                    ArrayList<Integer> decOrderClassDist_upper = new ArrayList<Integer>();
                    ArrayList<Integer> unusedClasses = new ArrayList<Integer>();
                    for (int j = 0; j < numberOfClasses; ++j) {
                        unusedClasses.add(j);
                    }
                    double auxAvailable = availableErrorPerValue[i3];
                    for (int j = 0; j < numberOfClasses; ++j) {
                        if (auxAvailable < 0.0) {
                            if (Math.abs(auxAvailable) < 1.0E-9) {
                                auxAvailable = 0.0;
                            } else {
                                throw new IademException("NominalVirtualNode", "updateHeuristicMeasureMultiwayTest", "Problems when calculating measures");
                            }
                        }
                        int classID = this.getClassProbabilities(i3, unusedClasses, classDist_lower, classDist_upper, auxAvailable);
                        double probUp = Math.min(classDist_upper[i3][classID], classDist_lower[i3][classID] + auxAvailable);
                        auxAvailable -= probUp - classDist_lower[i3][classID];
                        unusedClasses.remove(new Integer(classID));
                        decOrderClassDist_upper.add(new Integer(classID));
                    }
                    ArrayList<Double> vectorToMeasure = new ArrayList<Double>();
                    for (int j = 0; j < decOrderClassDist_upper.size(); ++j) {
                        int classID = (Integer)decOrderClassDist_upper.get(j);
                        if (availableError < 0.0) {
                            if (Math.abs(availableError) < 1.0E-9) {
                                availableError = 0.0;
                            } else {
                                throw new IademException("NominalVirtualNode", "updateHeuristicMeasureMultiwayTest", "Problems when calculating measures");
                            }
                        }
                        double probUp = Math.min(classDist_upper[i3][classID], classDist_lower[i3][classID] + availableError);
                        availableError -= probUp - classDist_lower[i3][classID];
                        vectorToMeasure.add(probUp);
                    }
                    measurePerValue_lower[i3] = measure.doMeasure(vectorToMeasure);
                }
                double dividendUpper = 0.0;
                double dividendLower = 0.0;
                double divisor = 0.0;
                for (int i4 = 0; i4 < this.attValueDist.numValues(); ++i4) {
                    dividendUpper += measuerPerValue_upper[i4] * this.attValueDist.getValue(i4);
                    dividendLower += measurePerValue_lower[i4] * this.attValueDist.getValue(i4);
                    divisor += this.attValueDist.getValue(i4);
                }
                double measureLower = dividendLower / divisor;
                double measureUpper = dividendUpper / divisor;
                int maxBranches = instance.attribute(this.attIndex).numValues();
                IademNominalAttributeMultiwayTest test = new IademNominalAttributeMultiwayTest(this.attIndex, maxBranches);
                this.bestSplitSuggestion = new IademAttributeSplitSuggestion(test, new double[0][0], measureUpper, measureLower);
            }
        }

        private void computeClassDistPerValue(double[][] classDistLower, double[][] classDistUpper) {
            int numberOfValues = classDistLower.length;
            int numberOfClasses = classDistLower[0].length;
            for (int i = 0; i < numberOfValues; ++i) {
                for (int j = 0; j < numberOfClasses; ++j) {
                    if (this.attValueDist.getValue(i) == 0.0) {
                        classDistLower[i][j] = 0.0;
                        classDistUpper[i][j] = 1.0;
                        continue;
                    }
                    DoubleVector classCounter = this.nominalAttClassObserver.get(i);
                    double attValuePerClassCounter = classCounter != null ? classCounter.getValue(j) : 0.0;
                    double estimator = attValuePerClassCounter / this.attValueDist.getValue(i);
                    double classDistError = IademCommonProcedures.getIADEM_HoeffdingBound(estimator, this.attValueDist.getValue(i));
                    classDistLower[i][j] = Math.max(0.0, estimator - classDistError);
                    classDistUpper[i][j] = Math.min(1.0, estimator + classDistError);
                }
            }
        }

        private int getClassProbabilities(int attributeValue, ArrayList<Integer> attValueList, double[][] classDistPerValueLower, double[][] classDistPerValueUpper, double available) {
            if (attValueList.isEmpty()) {
                return -1;
            }
            int max = attValueList.get(0);
            double maxProbUp = Math.min(classDistPerValueUpper[attributeValue][max], classDistPerValueLower[attributeValue][max] + available);
            for (int i = 1; i < attValueList.size(); ++i) {
                int tmp = attValueList.get(i);
                double newProbUp = Math.min(classDistPerValueUpper[attributeValue][tmp], classDistPerValueLower[attributeValue][tmp] + available);
                if (!(newProbUp > maxProbUp)) continue;
                max = tmp;
                maxProbUp = newProbUp;
            }
            return max;
        }

        @Override
        public DoubleVector computeConditionalProbability(double valor) {
            int i;
            int numberOfValues = this.nominalAttClassObserver.size();
            DoubleVector conditionalProbability = new DoubleVector();
            DoubleVector sumsPerClass = new DoubleVector();
            for (i = 0; i < numberOfValues; ++i) {
                DoubleVector classCounter = this.nominalAttClassObserver.get(i);
                int numberOfClasses = classCounter != null ? classCounter.numValues() : 0;
                for (int j = 0; j < numberOfClasses; ++j) {
                    double attClassCounter = classCounter.getValue(j);
                    sumsPerClass.addToValue(j, attClassCounter);
                }
            }
            for (i = 0; i < sumsPerClass.numValues(); ++i) {
                if (sumsPerClass.getValue(i) == 0.0) continue;
                DoubleVector contadorClase = this.nominalAttClassObserver.get((int)valor);
                double attClassCounter = contadorClase != null ? contadorClase.getValue(i) : 0.0;
                conditionalProbability.setValue(i, attClassCounter / sumsPerClass.getValue(i));
            }
            return conditionalProbability;
        }

        @Override
        public double getPercent() {
            double counter = 0.0;
            double maxInstances = 0.0;
            for (int i = 0; i < this.attValueDist.numValues(); ++i) {
                counter += this.attValueDist.getValue(i);
                if (!(this.attValueDist.getValue(i) > maxInstances)) continue;
                maxInstances = this.attValueDist.getValue(i);
            }
            double maxPercent = maxInstances / counter;
            return maxPercent;
        }

        @Override
        public boolean hasInformation() {
            return true;
        }

        @Override
        public void getNumberOfNodes(int[] count) {
            count[1] = count[1] + 1;
        }
    }

    public abstract class VirtualNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected int attIndex;
        protected boolean heuristicMeasureUpdated;
        protected IademAttributeSplitSuggestion bestSplitSuggestion;

        public VirtualNode(Iadem2 tree, Node parent, int attIndex) {
            super(tree, parent, new double[0]);
            this.bestSplitSuggestion = null;
            this.attIndex = attIndex;
            this.heuristicMeasureUpdated = false;
        }

        public IademAttributeSplitSuggestion getBestSplitSuggestion() {
            return this.bestSplitSuggestion;
        }

        public int getAttIndex() {
            return this.attIndex;
        }

        @Override
        public int getSubtreeNodeCount() {
            return 0;
        }

        @Override
        public ArrayList<LeafNode> getLeaves() {
            return new ArrayList<LeafNode>();
        }

        public abstract SplitNode getNewSplitNode(long var1, Node var3, IademAttributeSplitSuggestion var4, Instance var5);

        public abstract void updateHeuristicMeasure(Instance var1) throws IademException;

        public abstract DoubleVector computeConditionalProbability(double var1);

        public abstract double getPercent();

        public abstract boolean hasInformation();

        public double getHeuristicMeasureUpper(Instance instance) throws IademException {
            if (!this.heuristicMeasureUpdated) {
                this.updateHeuristicMeasure(instance);
            }
            if (this.bestSplitSuggestion == null) {
                return -1.0;
            }
            return this.bestSplitSuggestion.merit;
        }

        public double getHeuristicMeasureLower(Instance instance) throws IademException {
            if (!this.heuristicMeasureUpdated) {
                this.updateHeuristicMeasure(instance);
            }
            if (this.bestSplitSuggestion == null) {
                return -1.0;
            }
            return this.bestSplitSuggestion.getMeritLowerBound();
        }

        @Override
        public double[] getClassVotes(Instance inst) {
            return this.classValueDist.getArrayCopy();
        }
    }

    public class LeafNodeWeightedVote
    extends LeafNodeNB {
        private static final long serialVersionUID = 1L;
        protected AbstractChangeDetector naiveBayesError;
        protected AbstractChangeDetector majorityClassError;

        public LeafNodeWeightedVote(Iadem2 tree, Node parent, long instancesProcessedByTheTree, long instancesProcessedByThisLeaf, double[] classDist, IademNumericAttributeObserver observadorContinuos, int naiveBayesLimit, boolean onlyMultiwayTest, boolean onlyBinaryTest, AbstractChangeDetector estimator, Instance instance) {
            super(tree, parent, instancesProcessedByTheTree, instancesProcessedByThisLeaf, classDist, observadorContinuos, naiveBayesLimit, onlyMultiwayTest, onlyBinaryTest, instance);
            this.naiveBayesError = (AbstractChangeDetector)estimator.copy();
            this.majorityClassError = (AbstractChangeDetector)estimator.copy();
        }

        @Override
        public double[] getClassVotes(Instance instance) {
            double NBweight = 1.0 - this.naiveBayesError.getEstimation();
            double MCweight = 1.0 - this.majorityClassError.getEstimation();
            double[] MC = this.getMajorityClassVotes(instance);
            double[] NB = this.getNaiveBayesPrediction(instance);
            double[] classVotes = new double[MC.length];
            for (int i = 0; i < MC.length; ++i) {
                classVotes[i] = MC[i] * MCweight + NB[i] * NBweight;
            }
            return classVotes;
        }

        @Override
        public Node learnFromInstance(Instance inst) {
            double[] classVotes = this.getMajorityClassVotes(inst);
            double error = Utils.maxIndex(classVotes) == (int)inst.classValue() ? 0.0 : 1.0;
            this.majorityClassError.input(error);
            classVotes = this.getNaiveBayesPrediction(inst);
            error = Utils.maxIndex(classVotes) == (int)inst.classValue() ? 0.0 : 1.0;
            this.naiveBayesError.input(error);
            return super.learnFromInstance(inst);
        }
    }

    public class LeafNodeNBKirkby
    extends LeafNodeNB {
        private static final long serialVersionUID = 1L;
        protected int naiveBayesError;
        protected int majorityClassError;

        public LeafNodeNBKirkby(Iadem2 tree, Node parent, long instancesProcessedByTheTree, long instancesProcessedByThisLeaf, double[] classDist, IademNumericAttributeObserver numericAttClassObserver, int naiveBayesLimit, boolean onlyMultiwayTest, boolean onlyBinaryTest, AbstractChangeDetector estimator, Instance instance) {
            super(tree, parent, instancesProcessedByTheTree, instancesProcessedByThisLeaf, classDist, numericAttClassObserver, naiveBayesLimit, onlyMultiwayTest, onlyBinaryTest, instance);
            this.naiveBayesError = 0;
            this.majorityClassError = 0;
        }

        @Override
        public double[] getClassVotes(Instance instance) {
            if (this.naiveBayesError > this.majorityClassError) {
                return this.getMajorityClassVotes(instance);
            }
            return this.getNaiveBayesPrediction(instance);
        }

        @Override
        public Node learnFromInstance(Instance inst) {
            double[] prediccion = this.getMajorityClassVotes(inst);
            double error = Utils.maxIndex(prediccion) == (int)inst.classValue() ? 0.0 : 1.0;
            this.majorityClassError = (int)((double)this.majorityClassError + error);
            prediccion = this.getNaiveBayesPrediction(inst);
            error = Utils.maxIndex(prediccion) == (int)inst.classValue() ? 0.0 : 1.0;
            this.naiveBayesError = (int)((double)this.naiveBayesError + error);
            return super.learnFromInstance(inst);
        }
    }

    public class LeafNodeNB
    extends LeafNode {
        private static final long serialVersionUID = 1L;
        protected int naiveBayesLimit;

        public LeafNodeNB(Iadem2 tree, Node parent, long instTreeCountSinceVirtual, long instNodeCountSinceVirtual, double[] initialClassVotes, IademNumericAttributeObserver numericAttClassObserver, int naiveBayesLimit, boolean onlyMultiwayTest, boolean onlyBinaryTest, Instance instance) {
            super(tree, parent, instTreeCountSinceVirtual, instNodeCountSinceVirtual, initialClassVotes, numericAttClassObserver, onlyMultiwayTest, onlyBinaryTest, instance);
            this.naiveBayesLimit = naiveBayesLimit;
        }

        @Override
        public double[] getClassVotes(Instance inst) {
            double[] classVotes = this.instNodeCountSinceVirtual == 0L || this.instNodeCountSinceReal < (long)this.naiveBayesLimit ? this.getMajorityClassVotes(inst) : this.getNaiveBayesPrediction(inst);
            return classVotes;
        }

        protected double[] getNaiveBayesPrediction(Instance obs) {
            int i;
            double[] classVotes = this.getMajorityClassVotes(obs);
            for (int i2 = 0; i2 < this.virtualChildren.size(); ++i2) {
                double valor;
                DoubleVector condProbabilities;
                VirtualNode currentVirtualNode = (VirtualNode)this.virtualChildren.get(i2);
                if (currentVirtualNode == null || !currentVirtualNode.hasInformation() || (condProbabilities = currentVirtualNode.computeConditionalProbability(valor = obs.value(i2))) == null) continue;
                for (int j = 0; j < classVotes.length; ++j) {
                    int n = j;
                    classVotes[n] = classVotes[n] * condProbabilities.getValue(j);
                }
            }
            double classVoteCount = 0.0;
            for (i = 0; i < classVotes.length; ++i) {
                classVoteCount += classVotes[i];
            }
            if (classVoteCount == 0.0) {
                for (i = 0; i < classVotes.length; ++i) {
                    classVotes[i] = 1.0 / (double)classVotes.length;
                }
            } else {
                i = 0;
                while (i < classVotes.length) {
                    int n = i++;
                    classVotes[n] = classVotes[n] / classVoteCount;
                }
            }
            return classVotes;
        }
    }

    public class LeafNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected long instNodeCountSinceVirtual;
        protected long instTreeCountSinceReal;
        protected long instNodeCountSinceReal;
        protected AutoExpandVector<VirtualNode> virtualChildren;
        protected boolean allAttUsed;
        protected double instSeenSinceLastSplitAttempt;
        protected boolean split;

        public LeafNode(Iadem2 tree, Node parent, long instTreeCountSinceVirtual, long instNodeCountSinceVirtual, double[] initialClassCount, IademNumericAttributeObserver numericAttClassObserver, boolean onlyMultiwayTest, boolean onlyBinaryTest, Instance instance) {
            super(tree, parent, initialClassCount);
            this.virtualChildren = new AutoExpandVector();
            this.instSeenSinceLastSplitAttempt = 0.0;
            this.instNodeCountSinceVirtual = instNodeCountSinceVirtual;
            this.instTreeCountSinceReal = 0L;
            this.instNodeCountSinceReal = 0L;
            this.split = true;
            this.createVirtualNodes(numericAttClassObserver, onlyMultiwayTest, onlyBinaryTest, instance);
        }

        public double getInstSeenSinceLastSplitAttempt() {
            return this.instSeenSinceLastSplitAttempt;
        }

        public void setInstSeenSinceLastSplitAttempt(double instSeenSinceLastSplitAttempt) {
            this.instSeenSinceLastSplitAttempt = instSeenSinceLastSplitAttempt;
        }

        public AutoExpandVector<VirtualNode> getVirtualChildren() {
            return this.virtualChildren;
        }

        public void setVirtualChildren(AutoExpandVector<VirtualNode> virtualChildren) {
            this.virtualChildren = virtualChildren;
        }

        protected void createVirtualNodes(IademNumericAttributeObserver numericObserver, boolean onlyMultiwayTest, boolean onlyBinaryTest, Instance instance) {
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (instance.classIndex() != i && instance.attribute(i).isNominal()) {
                    this.virtualChildren.set(i, new NominalVirtualNode(this.tree, this, i, onlyMultiwayTest, onlyBinaryTest));
                    continue;
                }
                if (instance.classIndex() != i && instance.attribute(i).isNumeric()) {
                    this.virtualChildren.set(i, new NumericVirtualNode(this.tree, this, i, numericObserver));
                    continue;
                }
                this.virtualChildren.set(i, null);
            }
        }

        protected ArrayList<Integer> nominalAttUsed(Instance instance) {
            SplitNode currentNode = (SplitNode)this.parent;
            ArrayList<Integer> nomAttUsed = new ArrayList<Integer>();
            while (currentNode != null) {
                if (instance.attribute(currentNode.splitTest.getAttsTestDependsOn()[0]).isNominal()) {
                    nomAttUsed.add(currentNode.splitTest.getAttsTestDependsOn()[0]);
                }
                currentNode = (SplitNode)currentNode.parent;
            }
            return nomAttUsed;
        }

        @Override
        public Iadem2 getTree() {
            return this.tree;
        }

        @Override
        public int getSubtreeNodeCount() {
            return 1;
        }

        @Override
        public ArrayList<LeafNode> getLeaves() {
            ArrayList<LeafNode> leaf = new ArrayList<LeafNode>();
            leaf.add(this);
            return leaf;
        }

        public boolean isAllAttUsed() {
            return this.allAttUsed;
        }

        public void attemptToSplit(Instance instance) {
            if (this.classValueDist.numNonZeroEntries() > 1 && this.hasInformationToSplit()) {
                try {
                    this.instSeenSinceLastSplitAttempt = 0.0;
                    IademAttributeSplitSuggestion bestSplitSuggestion = this.getBestSplitSuggestion(instance);
                    if (bestSplitSuggestion != null) {
                        this.doSplit(bestSplitSuggestion, instance);
                    }
                }
                catch (IademException ex) {
                    Logger.getLogger(LeafNode.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        public Node learnFromInstance(Instance inst) {
            this.instNodeCountSinceVirtual = (long)((double)this.instNodeCountSinceVirtual + inst.weight());
            this.classValueDist.addToValue((int)inst.value(inst.classIndex()), inst.weight());
            this.instNodeCountSinceReal = (long)((double)this.instNodeCountSinceReal + inst.weight());
            this.instSeenSinceLastSplitAttempt += inst.weight();
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                VirtualNode virtual = this.virtualChildren.get(i);
                if (virtual == null) continue;
                virtual.learnFromInstance(inst);
            }
            if (this.split) {
                this.attemptToSplit(inst);
            }
            return this;
        }

        protected IademAttributeSplitSuggestion getFastSplitSuggestion(Instance instance) throws IademException {
            int bestAttIndex = -1;
            double bestAttValue = Double.MAX_VALUE;
            for (int i = 0; i < this.virtualChildren.size(); ++i) {
                VirtualNode currentVirtualChild = this.virtualChildren.get(i);
                if (currentVirtualChild == null) continue;
                try {
                    currentVirtualChild.updateHeuristicMeasure(instance);
                }
                catch (IademException e) {
                    throw new IademException("LeafNode", "getFastSplitSuggestion", "Problems when updating measures: \n" + e.getMessage());
                }
                if (!(currentVirtualChild.getHeuristicMeasureUpper(instance) >= 0.0) || !(currentVirtualChild.getHeuristicMeasureUpper(instance) < bestAttValue)) continue;
                bestAttIndex = i;
                bestAttValue = currentVirtualChild.getHeuristicMeasureUpper(instance);
            }
            if (bestAttIndex != -1) {
                return this.virtualChildren.get(bestAttIndex).getBestSplitSuggestion();
            }
            return null;
        }

        public IademAttributeSplitSuggestion getBestSplitSuggestion(Instance instance) throws IademException {
            return this.getBestSplitSuggestionIADEM(instance);
        }

        public LeafNode[] doSplit(IademAttributeSplitSuggestion bestSuggestion, Instance instance) {
            SplitNode splitNode = this.virtualChildren.get(bestSuggestion.splitTest.getAttsTestDependsOn()[0]).getNewSplitNode(this.instTreeCountSinceReal, this.parent, bestSuggestion, instance);
            splitNode.setParent(this.parent);
            if (this.parent == null) {
                this.tree.setTreeRoot(splitNode);
            } else {
                ((SplitNode)this.parent).changeChildren(this, splitNode);
            }
            this.tree.newSplit(splitNode.getLeaves().size());
            return null;
        }

        @Override
        public double[] getClassVotes(Instance obs) {
            return this.getMajorityClassVotes(obs);
        }

        public double[] getMajorityClassVotes(Instance instance) {
            int i;
            double[] votes = new double[instance.attribute(instance.classIndex()).numValues()];
            Arrays.fill(votes, 0.0);
            if (this.instNodeCountSinceVirtual == 0L) {
                if (this.parent != null) {
                    ArrayList<LeafNode> siblings = this.parent.getLeaves();
                    siblings.remove(this);
                    ArrayList<LeafNode> siblingWithInfo = new ArrayList<LeafNode>();
                    long count = 0L;
                    for (LeafNode currentSibling : siblings) {
                        if (currentSibling.getInstNodeCountSinceVirtual() <= 0L) continue;
                        siblingWithInfo.add(currentSibling);
                        count += currentSibling.getInstNodeCountSinceVirtual();
                    }
                    if (count > 0L) {
                        for (LeafNode currentSibling : siblingWithInfo) {
                            double[] sibVotes = currentSibling.getMajorityClassVotes(instance);
                            double weight = (double)currentSibling.getInstNodeCountSinceVirtual() / (double)count;
                            for (int i2 = 0; i2 < votes.length; ++i2) {
                                int n = i2;
                                votes[n] = votes[n] + weight * sibVotes[i2];
                            }
                        }
                    }
                }
            } else {
                for (int i3 = 0; i3 < votes.length; ++i3) {
                    votes[i3] = this.classValueDist.getValue(i3) / (double)this.instNodeCountSinceVirtual;
                }
            }
            double voteCount = 0.0;
            for (i = 0; i < votes.length; ++i) {
                voteCount += votes[i];
            }
            if (voteCount == 0.0) {
                for (i = 0; i < votes.length; ++i) {
                    votes[i] = 1.0 / (double)votes.length;
                }
            } else {
                i = 0;
                while (i < votes.length) {
                    int n = i++;
                    votes[n] = votes[n] / voteCount;
                }
            }
            return votes;
        }

        public long getInstNodeCountSinceVirtual() {
            return this.instNodeCountSinceVirtual;
        }

        private double percentInCommon(double A_upper, double A_lower, double B_upper, double B_lower) {
            double percent;
            if (A_lower >= B_upper || A_upper <= B_lower) {
                percent = 0.0;
            } else {
                double A_out = 0.0;
                double A_margin = A_upper - A_lower;
                if (A_upper <= B_upper && A_lower >= B_lower) {
                    A_out = 0.0;
                } else if (A_upper > B_upper && A_lower >= B_lower) {
                    A_out = A_upper - B_upper;
                } else if (A_upper > B_upper && A_lower < B_lower) {
                    A_out = A_upper - B_upper + (B_lower - A_lower);
                } else if (A_upper <= B_upper && A_lower < B_lower) {
                    A_out = B_lower - A_lower;
                } else {
                    System.out.println("Something is wrong");
                }
                percent = (A_margin - A_out) / A_margin;
            }
            return percent;
        }

        public boolean hasInformationToSplit() {
            return this.instSeenSinceLastSplitAttempt >= (double)this.tree.gracePeriodOption.getValue();
        }

        public IademAttributeSplitSuggestion getBestSplitSuggestionIADEM(Instance instance) throws IademException {
            VirtualNode bestNode;
            double percent;
            int bestAttIndex = -1;
            int secondBestAttIndex = -1;
            double bestAtt_upper = Double.MAX_VALUE;
            double bestAtt_lower = Double.MAX_VALUE;
            double secondBestAtt_upper = Double.MAX_VALUE;
            double secondBestAtt_lower = Double.MAX_VALUE;
            double worstAtt_upper = Double.MIN_VALUE;
            double worstAtt_lower = Double.MIN_VALUE;
            for (int i = 0; i < this.virtualChildren.size(); ++i) {
                VirtualNode currentVirtualChild = this.virtualChildren.get(i);
                if (currentVirtualChild == null) continue;
                try {
                    currentVirtualChild.updateHeuristicMeasure(instance);
                }
                catch (IademException e) {
                    throw new IademException("LeafNode", "getBestSplitSuggestion7", "Problems when updating measures: \n" + e.getMessage());
                }
                if (!(currentVirtualChild.getHeuristicMeasureUpper(instance) >= 0.0)) continue;
                if (currentVirtualChild.getHeuristicMeasureUpper(instance) < bestAtt_upper || currentVirtualChild.getHeuristicMeasureUpper(instance) == bestAtt_upper && currentVirtualChild.getHeuristicMeasureLower(instance) < bestAtt_lower) {
                    secondBestAttIndex = bestAttIndex;
                    secondBestAtt_upper = bestAtt_upper;
                    secondBestAtt_lower = bestAtt_lower;
                    bestAttIndex = i;
                    bestAtt_upper = currentVirtualChild.getHeuristicMeasureUpper(instance);
                    bestAtt_lower = currentVirtualChild.getHeuristicMeasureLower(instance);
                } else if (currentVirtualChild.getHeuristicMeasureUpper(instance) < secondBestAtt_upper || currentVirtualChild.getHeuristicMeasureUpper(instance) == secondBestAtt_upper && currentVirtualChild.getHeuristicMeasureLower(instance) < secondBestAtt_lower) {
                    secondBestAttIndex = i;
                    secondBestAtt_upper = currentVirtualChild.getHeuristicMeasureUpper(instance);
                    secondBestAtt_lower = currentVirtualChild.getHeuristicMeasureLower(instance);
                }
                if (!(currentVirtualChild.getHeuristicMeasureUpper(instance) > worstAtt_upper) && (currentVirtualChild.getHeuristicMeasureUpper(instance) != worstAtt_upper || !(currentVirtualChild.getHeuristicMeasureLower(instance) > worstAtt_lower))) continue;
                worstAtt_upper = currentVirtualChild.getHeuristicMeasureUpper(instance);
                worstAtt_lower = currentVirtualChild.getHeuristicMeasureLower(instance);
            }
            int bestAtt = bestAttIndex;
            if (secondBestAttIndex != -1) {
                boolean differenceBestWorst;
                double best_worst = this.percentInCommon(bestAtt_upper, bestAtt_lower, worstAtt_upper, worstAtt_lower);
                double worst_best = this.percentInCommon(worstAtt_upper, worstAtt_lower, bestAtt_upper, bestAtt_lower);
                double d = this.tree.getAttributeDifferentiation();
                boolean similarityBestWorst = best_worst >= 1.0 - d && worst_best >= 1.0 - d;
                boolean similarityWithConfidenceBestWorst = similarityBestWorst && bestAtt_upper - bestAtt_lower <= d;
                boolean bl = differenceBestWorst = best_worst <= d || worst_best <= d;
                if (!similarityWithConfidenceBestWorst && !differenceBestWorst) {
                    bestAtt = -1;
                }
            }
            if (bestAtt != -1 && (percent = (bestNode = this.virtualChildren.get(bestAtt)) instanceof NumericVirtualNode ? 1.0 - bestNode.getPercent() : bestNode.getPercent()) > this.tree.getPercentInCommon()) {
                bestAtt = -1;
            }
            if (bestAtt >= 0) {
                return this.virtualChildren.get((int)bestAtt).bestSplitSuggestion;
            }
            return null;
        }

        @Override
        public void getNumberOfNodes(int[] count) {
            count[1] = count[1] + 1;
        }

        public void setSplit(boolean split) {
            this.split = split;
        }
    }

    public abstract class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Iadem2 tree;
        protected DoubleVector classValueDist;
        public Node parent;

        public DoubleVector getClassValueDist() {
            return this.classValueDist;
        }

        public void setClassValueDist(DoubleVector classValueDist) {
            this.classValueDist = classValueDist;
        }

        public Iadem2 getTree() {
            return this.tree;
        }

        public void setTree(Iadem2 tree) {
            this.tree = tree;
        }

        public Node(Iadem2 tree, Node parent, double[] initialClassCount) {
            this.tree = tree;
            this.parent = parent;
            this.classValueDist = new DoubleVector(initialClassCount);
        }

        public abstract int getSubtreeNodeCount();

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public abstract Node learnFromInstance(Instance var1);

        public abstract ArrayList<LeafNode> getLeaves();

        public abstract double[] getClassVotes(Instance var1);

        public int getChildCount() {
            return 0;
        }

        public abstract void getNumberOfNodes(int[] var1);
    }
}

