/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.SimpleCOD;

import com.yahoo.labs.samoa.instances.Instance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import moa.clusterers.outliers.SimpleCOD.MyMTree;
import moa.clusterers.outliers.SimpleCOD.StreamObj;
import moa.clusterers.outliers.utils.mtree.MTree;

public class ISBIndex {
    MyMTree mtree = new MyMTree();
    Map<Integer, Set<ISBNode>> mapNodes = new HashMap<Integer, Set<ISBNode>>();
    double m_radius;
    int m_k;

    public ISBIndex(double radius, int k) {
        this.m_radius = radius;
        this.m_k = k;
    }

    Vector<ISBNode> GetAllNodes() {
        Vector<ISBNode> v = new Vector<ISBNode>();
        for (Map.Entry<Integer, Set<ISBNode>> pairs : this.mapNodes.entrySet()) {
            Set<ISBNode> setNodes = pairs.getValue();
            for (ISBNode n : setNodes) {
                v.add(n);
            }
        }
        return v;
    }

    public Vector<ISBSearchResult> RangeSearch(ISBNode node, double radius) {
        Vector<ISBSearchResult> results = new Vector<ISBSearchResult>();
        MTree.Query query = this.mtree.getNearestByRange(node.obj, radius);
        for (MTree.ResultItem q : query) {
            StreamObj obj = (StreamObj)q.data;
            double d = q.distance;
            Vector<ISBNode> nodes = this.MapGetNodes(obj);
            for (int i = 0; i < nodes.size(); ++i) {
                results.add(new ISBSearchResult(nodes.get(i), d));
            }
        }
        return results;
    }

    public void Insert(ISBNode node) {
        this.mtree.add(node.obj);
        this.MapInsert(node);
    }

    public void Remove(ISBNode node) {
        this.MapDelete(node);
        if (this.MapCountObjRefs(node.obj) <= 0) {
            this.mtree.remove(node.obj);
        }
    }

    Vector<ISBNode> MapGetNodes(StreamObj obj) {
        int h = obj.hashCode();
        Vector<ISBNode> v = new Vector<ISBNode>();
        if (this.mapNodes.containsKey(h)) {
            Set<ISBNode> s = this.mapNodes.get(h);
            for (ISBNode node : s) {
                if (!node.obj.equals(obj)) continue;
                v.add(node);
            }
        }
        return v;
    }

    int MapCountObjRefs(StreamObj obj) {
        int h = obj.hashCode();
        int iCount = 0;
        if (this.mapNodes.containsKey(h)) {
            Set<ISBNode> s = this.mapNodes.get(h);
            for (ISBNode n : s) {
                if (!n.obj.equals(obj)) continue;
                ++iCount;
            }
        }
        return iCount;
    }

    void MapInsert(ISBNode node) {
        int h = node.obj.hashCode();
        if (this.mapNodes.containsKey(h)) {
            Set<ISBNode> s = this.mapNodes.get(h);
            s.add(node);
        } else {
            HashSet<ISBNode> s = new HashSet<ISBNode>();
            s.add(node);
            this.mapNodes.put(h, s);
        }
    }

    void MapDelete(ISBNode node) {
        int h = node.obj.hashCode();
        if (this.mapNodes.containsKey(h)) {
            Set<ISBNode> s = this.mapNodes.get(h);
            s.remove(node);
            if (s.isEmpty()) {
                this.mapNodes.remove(h);
            }
        }
    }

    public static class ISBSearchResult {
        public ISBNode node;
        public double distance;

        public ISBSearchResult(ISBNode n, double distance) {
            this.node = n;
            this.distance = distance;
        }
    }

    public static class ISBNode
    implements Comparable<ISBNode> {
        public Instance inst;
        public StreamObj obj;
        public Long id;
        public boolean bOutlier;
        public int count_after;
        private ArrayList<ISBNode> nn_before;
        public int nOutlier;
        public int nInlier;

        public ISBNode(Instance inst, StreamObj obj, Long id) {
            this.inst = inst;
            this.obj = obj;
            this.id = id;
            this.bOutlier = false;
            this.count_after = 1;
            this.nn_before = new ArrayList();
            this.nOutlier = 0;
            this.nInlier = 0;
        }

        @Override
        public int compareTo(ISBNode t) {
            if (this.id > t.id) {
                return 1;
            }
            if (this.id < t.id) {
                return -1;
            }
            return 0;
        }

        public void AddPrecNeigh(ISBNode node) {
            int pos = Collections.binarySearch(this.nn_before, node);
            if (pos < 0) {
                this.nn_before.add(-(pos + 1), node);
            }
        }

        public void RemovePrecNeigh(ISBNode node) {
            int pos = Collections.binarySearch(this.nn_before, node);
            if (pos >= 0) {
                this.nn_before.remove(pos);
            }
        }

        public ISBNode GetMinPrecNeigh(Long sinceId) {
            ISBNode dummy;
            int pos;
            int startPos;
            if (this.nn_before.size() > 0 && (startPos = (pos = Collections.binarySearch(this.nn_before, dummy = new ISBNode(null, null, sinceId))) < 0 ? -(pos + 1) : pos) < this.nn_before.size()) {
                return this.nn_before.get(startPos);
            }
            return null;
        }

        public int CountPrecNeighs(Long sinceId) {
            ISBNode dummy;
            int pos;
            int startPos;
            if (this.nn_before.size() > 0 && (startPos = (pos = Collections.binarySearch(this.nn_before, dummy = new ISBNode(null, null, sinceId))) < 0 ? -(pos + 1) : pos) < this.nn_before.size()) {
                return this.nn_before.size() - startPos;
            }
            return 0;
        }

        public List<ISBNode> Get_nn_before() {
            return this.nn_before;
        }
    }
}

