## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center",
  fig.width = 5, 
  fig.height=4
)

## ----setup--------------------------------------------------------------------
library(l1rotation)

## -----------------------------------------------------------------------------
head(example_data[,1:7])

## -----------------------------------------------------------------------------
set.seed(916)

lf <- local_factors(
  X = example_data, r = 2,
  parallel = FALSE, n_cores = NULL # Runs non-parallel by default
)


## -----------------------------------------------------------------------------
lf$rotation_diagnostics

## -----------------------------------------------------------------------------
lf$pc_plot

## -----------------------------------------------------------------------------
lf$rotated_plot

## -----------------------------------------------------------------------------
lf$has_local_factors

## -----------------------------------------------------------------------------
# Check for local factors in PC estimate...
test_pc_estimate <- test_local_factors(X = example_data, r = 2, loadings = lf$initial_loadings)

# And rotated estimate
test_rot_estimate <- test_local_factors(X = example_data, r = 2, loadings = lf$rotated_loadings)

test_pc_estimate$has_local_factors
test_rot_estimate$has_local_factors

## -----------------------------------------------------------------------------
round_hn <- round(test_rot_estimate$h_n, digits = 3)

lf$small_loadings_plot + 
  ggplot2::labs(
    title = 'Number of "small" loadings per factor', 
    caption = paste('"Small" is defined as loadings less than', round_hn)
  )

