## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(phonetisr)

## -----------------------------------------------------------------------------
ipa <- c("pʰãkʰ", "tʰum̥", "ɛkʰɯ")

phonetise(ipa)

## -----------------------------------------------------------------------------
phonetise(ipa, diacritics = TRUE)

## -----------------------------------------------------------------------------
ph <- c("pʰ", "tʰ", "kʰ", "ã", "m̥")

phonetise(ipa, multi = ph)

## -----------------------------------------------------------------------------
phonetise(ipa, multi = ph, split = FALSE, sep = ".")

## ----kl-----------------------------------------------------------------------
library(tidyverse)
data("kl_swadesh")
kl_swadesh

## ----kl-multi-----------------------------------------------------------------
kl_multi <- c(
  "pʰ", "tʰ", "qʰ",
  "tɬ", "tʃ", "qχ", 
  "dʒ"
)

## ----kl-phones----------------------------------------------------------------
kl_swadesh <- kl_swadesh |> 
  mutate(
    phones = phonetise(ipa, multi = kl_multi)
  )

kl_swadesh

## ----kl-unnest----------------------------------------------------------------
kl_unnest <- kl_swadesh |> 
  unnest(phones)
kl_unnest

## ----kl-count-----------------------------------------------------------------
kl_unnest |> 
  count(phones, sort = TRUE)

## ----kl-count-plot, fig.width=5-----------------------------------------------
kl_unnest |> 
  count(phones, sort = TRUE) |> 
  ggplot(aes(reorder(phones, desc(n)), n)) +
  geom_bar(stat = "identity")

## ----kl-feat------------------------------------------------------------------
kl_feat <- featurise(kl_swadesh$phones)
kl_feat

## ----kl-feat-plot, fig.width=5------------------------------------------------
kl_feat |> 
  ggplot(aes(reorder(phone, desc(count)), count, fill = type)) +
  geom_bar(stat = "identity")

## ----ipa-symbols--------------------------------------------------------------
data("ipa_symbols")
ipa_symbols

