/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.ui.swing.ChoiceButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class SmartToolbar
extends JPanel {
    private JLabel popupLabel;
    private JPanel userPanel;
    private JPopupMenu popupMenu;
    private Hashtable actionTable = new Hashtable();
    private boolean popupLabelAdded = false;

    public SmartToolbar() {
        this.popupMenu = new JPopupMenu();
        this.setLayout(new BorderLayout());
        this.userPanel = new JPanel();
        this.userPanel.setOpaque(false);
        this.userPanel.setLayout(new FlowLayout(0, 2, 2));
        this.add((Component)this.userPanel, "Center");
        this.popupLabel = new JLabel(">>");
        this.userPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                SmartToolbar.this.updateToolbar();
            }
        });
        this.popupLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Dimension dimension = SmartToolbar.this.popupLabel.getSize();
                SmartToolbar.this.popupMenu.show(SmartToolbar.this.popupLabel, dimension.width, dimension.height / 2 - 15);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                SmartToolbar.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                SmartToolbar.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    @Override
    public Component add(Component component) {
        Component component2 = this.userPanel.add(component);
        if (component instanceof ChoiceButton) {
            ChoiceButton choiceButton = (ChoiceButton)component;
            this.actionTable.put(choiceButton, choiceButton);
        } else if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            ButtonAction buttonAction = new ButtonAction(jButton);
            String string = jButton.getText();
            buttonAction.putValue("Name", string);
            this.actionTable.put(jButton, buttonAction);
        } else if (component instanceof JToggleButton) {
            JToggleButton jToggleButton = (JToggleButton)component;
            ButtonAction buttonAction = new ButtonAction(jToggleButton);
            String string = jToggleButton.getText();
            buttonAction.putValue("Name", string);
            this.actionTable.put(jToggleButton, buttonAction);
        }
        return component2;
    }

    @Override
    public void removeAll() {
        this.userPanel.removeAll();
        for (Object v : this.actionTable.values()) {
            if (!(v instanceof ButtonAction)) continue;
            ButtonAction buttonAction = (ButtonAction)v;
            buttonAction.resetListening();
        }
        this.actionTable.clear();
    }

    @Override
    public void remove(Component component) {
        this.userPanel.remove(component);
        Object v = this.actionTable.get(component);
        if (v instanceof ButtonAction) {
            ButtonAction buttonAction = (ButtonAction)v;
            buttonAction.resetListening();
        }
        this.actionTable.remove(component);
    }

    public JPanel getContentPane() {
        return this.userPanel;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.userPanel != null) {
            this.updateToolbar();
            SwingUtilities.updateComponentTreeUI(this.userPanel);
        }
    }

    private void updateToolbar() {
        Dimension dimension = this.userPanel.getPreferredSize();
        Dimension dimension2 = this.userPanel.getSize();
        if (dimension.width > dimension2.width || dimension.height < dimension2.height) {
            this.popupMenu = new JPopupMenu();
            boolean bl = false;
            for (int i = 0; i < this.userPanel.getComponentCount(); ++i) {
                Serializable serializable;
                Object object;
                Component component = this.userPanel.getComponent(i);
                Point point = component.getLocation();
                Dimension dimension3 = component.getPreferredSize();
                if (point.x + dimension3.width <= dimension2.width && point.y + dimension3.height <= dimension2.height) continue;
                bl = true;
                Object v = this.actionTable.get(component);
                if (v instanceof ChoiceButton) {
                    object = ((ChoiceButton)v).getPopupMenu();
                    this.popupMenu.add(this.getMenu((JPopupMenu)object));
                    continue;
                }
                if (!(v instanceof Action) || (object = (Action)v) == null) continue;
                if (object instanceof ButtonAction && ((ButtonAction)object).isToggle()) {
                    serializable = (ButtonAction)object;
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem((Action)object);
                    jCheckBoxMenuItem.setSelected(((ButtonAction)serializable).isSelected());
                    jCheckBoxMenuItem.setEnabled(component.isEnabled());
                    this.popupMenu.add(jCheckBoxMenuItem);
                    continue;
                }
                serializable = new JMenuItem((Action)object);
                ((JMenuItem)serializable).setEnabled(component.isEnabled());
                this.popupMenu.add((JMenuItem)serializable);
            }
            if (bl) {
                if (!this.popupLabelAdded) {
                    super.add((Component)this.popupLabel, "East");
                    this.popupLabelAdded = true;
                    this.validate();
                }
            } else if (this.popupLabelAdded) {
                super.remove(this.popupLabel);
                this.popupLabelAdded = false;
            }
        } else if (this.popupLabelAdded) {
            super.remove(this.popupLabel);
            this.popupLabelAdded = false;
        }
        this.repaint();
    }

    private JMenu getMenu(JPopupMenu jPopupMenu) {
        JMenu jMenu = new JMenu(jPopupMenu.getLabel());
        int n = jPopupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jPopupMenu.getComponent(i);
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem jMenuItem = (JMenuItem)component;
            JMenuItem jMenuItem2 = new JMenuItem(jMenuItem.getAction());
            jMenu.add(jMenuItem2);
        }
        return jMenu;
    }

    private class ButtonAction
    extends AbstractAction
    implements PropertyChangeListener {
        protected AbstractButton delegate;

        public ButtonAction(AbstractButton abstractButton) {
            this.delegate = abstractButton;
            abstractButton.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setEnabled(this.delegate.isEnabled());
        }

        public void resetListening() {
            this.delegate.removePropertyChangeListener(this);
        }

        public boolean isToggle() {
            return this.delegate instanceof JToggleButton;
        }

        public boolean isSelected() {
            boolean bl = false;
            if (this.isToggle()) {
                bl = ((JToggleButton)this.delegate).isSelected();
            }
            return bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionListener[] actionListenerArray = this.delegate.getActionListeners();
            for (int i = 0; i < actionListenerArray.length; ++i) {
                ActionEvent actionEvent2 = new ActionEvent(this.delegate, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers());
                if (this.delegate instanceof JToggleButton) {
                    JToggleButton jToggleButton;
                    jToggleButton.setSelected(!(jToggleButton = (JToggleButton)this.delegate).isSelected());
                }
                actionListenerArray[i].actionPerformed(actionEvent2);
            }
        }
    }
}

