% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/here.R
\name{here}
\alias{here}
\title{Find your files}
\usage{
here(...)
}
\arguments{
\item{...}{\verb{[character]}\cr
Path components below the project root, can be empty.
Each argument should be a string containing one or more
path components separated by a forward slash \code{"/"}.}
}
\description{
\code{here()} uses a reasonable heuristics to find your project's files, based on
the current working directory at the time when the package is loaded.
Use it as a drop-in replacement for \code{\link[=file.path]{file.path()}}, it will always locate the
files relative to your project root.
}
\details{
This package is intended for interactive use only.
Use \code{\link[rprojroot:root_criterion]{rprojroot::has_file()}} or the other functions in
the \pkg{rprojroot} package for more control,
or for package development.

If \code{here()} raises an error or otherwise behaves unexpectedly,
you may have attached \pkg{plyr} or another package
after \pkg{here}.
Correct this using
\href{https://conflicted.r-lib.org/}{the \pkg{conflicted} package},
or use \code{here::here("data", "df.rda")}.
}
\examples{
here()
\dontrun{
here("some", "path", "below", "your", "project", "root.txt")
here("some/path/below/your/project/root.txt")
}
}
\section{Project root}{
The project root is established with a call to \verb{here::}\code{\link[=i_am]{i_am()}}.
Although not recommended, it can be changed by calling \code{here::i_am()} again.

In the absence of such a call (e.g. for a new project),
starting with the current working directory during package load time,
the directory hierarchy is walked upwards
until a directory with at least one of the following conditions is found:
\itemize{
\item contains a file \code{.here}
\item contains a file matching \verb{[.]Rproj$} with contents matching \verb{^Version: } in the first line
\item contains a file \code{DESCRIPTION} with contents matching \verb{^Package: }
\item contains a file \code{remake.yml}
\item contains a file \code{.projectile}
\item contains a directory \code{.git}
\item contains a file \code{.git} with contents matching \verb{^gitdir: }
\item contains a directory \code{.svn}
}

In either case, \code{here()} appends its arguments as path components
to the root directory.
}
