## ----include = FALSE--------------------------------------------------------------------------------------------------------------------------------
library(knitr)
opts_chunk$set(
	comment = "",
	message = FALSE,
	warning = FALSE,
	tidy.opts = list(
		keep.blank.line = TRUE,
		width.cutoff = 150
		),
	options(width = 150),
	eval = TRUE
)

## ----setup------------------------------------------------------------------------------------------------------------------------------------------
library(survminer)
library(survival)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res.cox <- coxph(Surv(time, status) ~ ph.karno * age, data=lung)
summary(res.cox, conf.int = FALSE)

## ----ggforest, fig.width=5, fig.height=4------------------------------------------------------------------------------------------------------------
ggforest(res.cox, data = lung)

## ---------------------------------------------------------------------------------------------------------------------------------------------------
lung$ph.karno_age <- lung$ph.karno * lung$age

## ---------------------------------------------------------------------------------------------------------------------------------------------------
res.cox2 <- coxph(Surv(time, status) ~ ph.karno + age + ph.karno_age, data = lung)
summary(res.cox2 , conf.int = FALSE)

## ----ggforest-with-interactions, fig.width=5, fig.height=4------------------------------------------------------------------------------------------
ggforest(res.cox2, data=lung)

