library(ALS)
library(TIMP)

x <-  5700:5800

Cmodel<-mass()
Cmodel@x <-x 
Cmodel@nt <- length(x)
Cmodel@extracomp <- FALSE

Cparam <- theta()

colg <- hcl(.1,.1,.1,.1)

pdf("intro.pdf", width=7,height=7)

par(mfrow=c(2,2),mar=c(2,1,1,1),cex=1.5)

Cparam@peakpar <- list(c(5760,2,1),
                       c(5750,12,1)) 

  
Cparam@amplitudes <- c(1,4) 

C1 <- compModelMass(Cparam, Cmodel)

rs1 <- rowSums(C1)

plot(x,rs1,type="l",yaxt="n")  

matplot(x,C1,type="l", lty=1, ylim=c(0, max(rs1)),col=1,yaxt="n")
polygon(x,C1[,1],col=colg)
polygon(x,C1[,2],col= colg)
#axis(1, at=seq(5700,5800,by=40))

par(mar=c(2,1,3,1))

Cparam@peakpar <- list(c(5750,8,1),
                       c(5750,8,1)) 


Cparam@amplitudes <- a2 <- c(0.33, 0.99)

C2 <- compModelMass(Cparam, Cmodel)
rs2 <- rowSums(C2)

plot(x,rowSums(C2),type="l",yaxt="n")  

matplot(x,C2,type="l",  lty=1, ylim=c(0, max(rs2)),
        col=1,yaxt="n")
polygon(x,C2[,1],col=colg)
polygon(x,C2[,2],col= colg)
#axis(1, at=seq(5700,5800,by=40))

dev.off()
