/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.wrightfisher;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.sequence.Sequence;
import dr.evolution.wrightfisher.CodonFitnessFunction;
import dr.evolution.wrightfisher.Population;
import dr.evolution.wrightfisher.SimpleGenome;
import dr.evolution.wrightfisher.SimpleMutator;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;

public class SelectionMapping {
    public static void main(String[] stringArray) throws IOException {
        int n;
        int n2;
        if (stringArray.length != 1) {
            throw new RuntimeException("Expect a file name containing parameters!");
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        fileInputStream.close();
        int n3 = Integer.parseInt(properties.getProperty("genomeLength", "1000"));
        int n4 = Integer.parseInt(properties.getProperty("populationSize", "250"));
        int n5 = Integer.parseInt(properties.getProperty("replicates", "1000"));
        double d = Double.parseDouble(properties.getProperty("mu", "1e-4"));
        double d2 = Double.parseDouble(properties.getProperty("alpha", "0.06"));
        double d3 = Double.parseDouble(properties.getProperty("pinv", "0.5"));
        double d4 = Double.parseDouble(properties.getProperty("beta", "1"));
        int n6 = Integer.parseInt(properties.getProperty("stateSize", "4"));
        int n7 = Integer.parseInt(properties.getProperty("sampleSize", "40"));
        boolean bl = Boolean.valueOf(properties.getProperty("randomizeFittest", "false"));
        boolean bl2 = Boolean.valueOf(properties.getProperty("outputAlignments", "false"));
        String string = properties.getProperty("alignment.filename", "alignment.fasta");
        String string2 = properties.getProperty("output.filename", "out.txt");
        int n8 = Integer.parseInt(properties.getProperty("burninFactor", "10"));
        PrintWriter printWriter = new PrintWriter(new FileWriter(string2));
        printWriter.println("// WMD v1.0");
        printWriter.println("// genomeLength: " + n3);
        printWriter.println("// populationSize: " + n4);
        printWriter.println("// alpha: " + d2);
        printWriter.println("// beta: " + d4);
        printWriter.println("// replicates: " + n5);
        printWriter.println("// output.filename: " + string2);
        printWriter.println("// mu: " + d);
        printWriter.println("// outputAlignments: " + bl2);
        printWriter.println("// randomFittest: " + bl);
        printWriter.println("// alignment.filename: " + string);
        int[] nArray = new int[200];
        int[] nArray2 = new int[200];
        int[] nArray3 = new int[n3 * 3];
        double[] dArray = new double[1];
        int n9 = n4;
        ArrayList[] arrayListArray = new ArrayList[n4 + 1];
        for (int i = 0; i < n4 + 1; ++i) {
            arrayListArray[i] = new ArrayList();
        }
        long l = System.currentTimeMillis();
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            int n14;
            CodonFitnessFunction codonFitnessFunction = new CodonFitnessFunction(n3, d2, d4, d3);
            Population population = new Population(n4, n3 * 3, new SimpleMutator(d, n6), codonFitnessFunction, bl);
            SimpleGenome simpleGenome = new SimpleGenome(n3 * 3, codonFitnessFunction, bl);
            population = Population.forwardSimulation(population, n8 * n4);
            int n15 = -1;
            while (n15 == -1) {
                population = Population.forwardSimulation(population, n9);
                n15 = population.getAgeOfMRCA(dArray);
            }
            Population population2 = Population.forwardSimulation(population, 1);
            printWriter.println(n2 + "\t" + n15 + "\t" + population.getMeanParentFitness() + "\t" + dArray[0] + "\t" + population.getProportionAsFit(dArray[0]));
            if (n2 % 10 == 0) {
                System.out.print(n2 + "\t" + n15 + "\t" + population.getMeanParentFitness() + "\t" + dArray[0] + "\t" + population.getProportionAsFit(dArray[0]));
                long l2 = System.currentTimeMillis() - l;
                double d5 = (double)l2 / 1000.0;
                if (n2 != 0) {
                    double d6 = (double)(n5 - n2) * d5 / (double)n2;
                    System.out.println(" -- " + (double)Math.round(d6 / 36.0) / 100.0 + " hours");
                } else {
                    System.out.println();
                }
            }
            ArrayList[] arrayListArray2 = new ArrayList[200];
            for (n14 = 0; n14 < arrayListArray2.length; ++n14) {
                arrayListArray2[n14] = new ArrayList(200);
            }
            n14 = Math.min(n7, n4);
            population.getMutationDensity(n14, arrayListArray2);
            for (int i = 0; i < arrayListArray2.length; ++i) {
                for (int j = 0; j < arrayListArray2[i].size(); ++j) {
                    int n16 = i;
                    nArray[n16] = nArray[n16] + (Integer)arrayListArray2[i].get(j);
                }
                int n17 = i;
                nArray2[n17] = nArray2[n17] + arrayListArray2[i].size();
            }
            SimpleAlignment simpleAlignment = new SimpleAlignment();
            SimpleAlignment simpleAlignment2 = new SimpleAlignment();
            simpleAlignment.setDataType(Nucleotides.INSTANCE);
            simpleAlignment2.setDataType(AminoAcids.INSTANCE);
            if (bl2) {
                PrintWriter printWriter2 = new PrintWriter(new FileWriter(string));
                for (int i = 0; i < n14; ++i) {
                    printWriter2.print(">sequence_");
                    if (i < 10) {
                        printWriter2.print("0");
                    }
                    printWriter2.println("" + i);
                    String string3 = population.getGenome(i).getDNASequenceString();
                    String string4 = population.getGenome(i).getAminoAcidSequenceString();
                    printWriter2.println(string3);
                    simpleAlignment.addSequence(new Sequence(string3));
                    simpleAlignment2.addSequence(new Sequence(string4));
                }
                printWriter2.println();
                printWriter2.close();
            }
            for (int i = 0; i < n14; ++i) {
                int n18 = simpleGenome.hammingDistance(population.getGenome(i));
                nArray3[n18] = nArray3[n18] + 1;
            }
            n10 += SelectionMapping.countSingletons(simpleAlignment);
            n11 += SelectionMapping.countSingletons(simpleAlignment2);
            n12 += SelectionMapping.countSegregating(simpleAlignment);
            n13 += SelectionMapping.countSegregating(simpleAlignment2);
        }
        for (n2 = 0; n2 < arrayListArray.length; ++n2) {
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            for (int i = 0; i < arrayListArray[n2].size(); ++i) {
                double d11 = (Double)arrayListArray[n2].get(i);
                d7 += d11;
                if (d11 == 1.0) {
                    d8 += 1.0;
                    continue;
                }
                if (d11 > 1.0) {
                    d9 += 1.0;
                    continue;
                }
                d10 += 1.0;
            }
            printWriter.println(n2 + "\t" + arrayListArray[n2].size() + "\t" + (d7 /= (double)arrayListArray[n2].size()) + "\t" + (d8 /= (double)arrayListArray[n2].size()) + "\t" + (d9 /= (double)arrayListArray[n2].size()) + "\t" + (d10 /= (double)arrayListArray[n2].size()));
        }
        printWriter.println("--------------------");
        printWriter.println("SINGLETON COUNTS");
        printWriter.println("--------------------");
        printWriter.println("dna singletons = " + n10);
        printWriter.println("aa singletons = " + n11);
        n2 = n12 - n10;
        int n19 = n13 - n11;
        System.out.println("dna singletons = " + n10);
        System.out.println("aa singletons = " + n11);
        System.out.println("dna segregating = " + n12);
        System.out.println("aa segregating = " + n13);
        System.out.println("dna non-singles = " + n2);
        System.out.println("aa non-singles = " + n19);
        System.out.println("ratio = " + (double)n10 / (double)n11);
        System.out.println("ratio(non) = " + (double)n2 / (double)n19);
        printWriter.println("--------------------");
        printWriter.println("MUTATIONAL DENSITIES");
        printWriter.println("--------------------");
        for (n = 0; n < 200; ++n) {
            printWriter.println(nArray[n] + "\t" + nArray2[n]);
        }
        printWriter.println("--------------------");
        printWriter.println("Hamming distance distribution");
        printWriter.println("--------------------");
        for (n = 0; n < nArray3.length; ++n) {
            printWriter.println(n + "\t" + nArray3[n]);
        }
        printWriter.close();
    }

    public static int countSingletons(Alignment alignment) {
        int n = 0;
        int[] nArray = new int[alignment.getDataType().getStateCount()];
        for (int i = 0; i < alignment.getSiteCount(); ++i) {
            n += SelectionMapping.isSingleton(alignment, i, nArray) ? 1 : 0;
        }
        return n;
    }

    public static int countSegregating(Alignment alignment) {
        int n = 0;
        int[] nArray = new int[alignment.getDataType().getStateCount()];
        for (int i = 0; i < alignment.getSiteCount(); ++i) {
            n += SelectionMapping.isSegregating(alignment, i, nArray) ? 1 : 0;
        }
        return n;
    }

    public static boolean isSingleton(Alignment alignment, int n, int[] nArray) {
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < alignment.getSequenceCount(); ++n2) {
            int n3 = alignment.getState(n2, n);
            if (n3 < 0 || n3 >= nArray.length) continue;
            int n4 = alignment.getState(n2, n);
            nArray[n4] = nArray[n4] + 1;
        }
        for (int n5 : nArray) {
            if (n5 != 1) continue;
            return true;
        }
        return false;
    }

    public static boolean isSegregating(Alignment alignment, int n, int[] nArray) {
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        n2 = alignment.getSequenceCount();
        for (int i = 0; i < n2; ++i) {
            int n3 = alignment.getState(i, n);
            if (n3 < 0 || n3 >= nArray.length) continue;
            int n4 = alignment.getState(i, n);
            nArray[n4] = nArray[n4] + 1;
        }
        for (int n5 : nArray) {
            if (n5 <= 0 || n5 >= n2) continue;
            return true;
        }
        return false;
    }
}

