/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.alloppnet.speciation.MulSpeciesBindings;
import dr.evomodel.alloppnet.speciation.MulSpeciesTreeModel;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.Arrays;
import jebl.util.FixedBitSet;

public class MulTreeNodeSlide
extends SimpleMCMCOperator {
    private final MulSpeciesTreeModel multree;
    private final MulSpeciesBindings species;
    private final int[] preOrderIndexBefore;
    private final int[] preOrderIndexAfter;

    public MulTreeNodeSlide(MulSpeciesTreeModel mulSpeciesTreeModel, MulSpeciesBindings mulSpeciesBindings, double d) {
        this.multree = mulSpeciesTreeModel;
        this.species = mulSpeciesBindings;
        this.preOrderIndexBefore = new int[mulSpeciesTreeModel.getNodeCount()];
        Arrays.fill(this.preOrderIndexBefore, -1);
        this.preOrderIndexAfter = new int[mulSpeciesTreeModel.getNodeCount()];
        Arrays.fill(this.preOrderIndexAfter, -1);
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return "none";
    }

    @Override
    public String getOperatorName() {
        return "nodeReHeight(" + this.multree.getId() + "," + this.species.getId() + ")";
    }

    @Override
    public double doOperation() {
        this.operateOneNode(0.0);
        return 0.0;
    }

    public void operateOneNode(double d) {
        double d2;
        int n;
        int n2 = this.multree.getExternalNodeCount();
        assert (n2 == this.species.nSpSeqs());
        NodeRef[] nodeRefArray = new NodeRef[2 * n2 - 1];
        boolean[] blArray = new boolean[n2 - 1];
        MulTreeNodeSlide.mauCanonical(this.multree, nodeRefArray, blArray);
        int n3 = MathUtils.nextInt(n2 - 1);
        FixedBitSet fixedBitSet = new FixedBitSet(n2);
        FixedBitSet fixedBitSet2 = new FixedBitSet(n2);
        for (n = 0; n < 2 * n3 + 1; n += 2) {
            fixedBitSet.set(this.multree.speciesIndex(nodeRefArray[n]));
        }
        for (n = 2 * (n3 + 1); n < 2 * n2; n += 2) {
            fixedBitSet2.set(this.multree.speciesIndex(nodeRefArray[n]));
        }
        if (d > 0.0) {
            d2 = this.multree.getNodeHeight(nodeRefArray[2 * n3 + 1]) * d;
        } else {
            double d3 = this.species.speciationUpperBound(fixedBitSet, fixedBitSet2);
            d2 = MathUtils.nextDouble() * d3;
        }
        this.multree.beginTreeEdit();
        this.multree.setPreorderIndices(this.preOrderIndexBefore);
        NodeRef nodeRef = nodeRefArray[2 * n3 + 1];
        this.multree.setNodeHeight(nodeRef, d2);
        MulTreeNodeSlide.mauReconstruct(this.multree, nodeRefArray, blArray);
        this.multree.setPreorderIndices(this.preOrderIndexAfter);
        double[] dArray = null;
        for (int i = 0; i < this.preOrderIndexBefore.length; ++i) {
            int n4;
            int n5 = this.preOrderIndexBefore[i];
            if (n5 < 0 || (n4 = this.preOrderIndexAfter[i]) == n5) continue;
            Parameter parameter = this.multree.sppSplitPopulations;
            if (dArray == null) {
                dArray = parameter.getParameterValues();
            }
            if (this.multree.constPopulation()) {
                parameter.setParameterValue(n2 + n4, dArray[n2 + n5]);
                continue;
            }
            for (int j = 0; j < 2; ++j) {
                parameter.setParameterValue(n2 + 2 * n4 + j, dArray[n2 + 2 * n5 + j]);
            }
        }
        this.multree.endTreeEdit();
    }

    private static void mauCanonical(Tree tree, NodeRef[] nodeRefArray, boolean[] blArray) {
        MulTreeNodeSlide.mauCanonicalSub(tree, tree.getRoot(), 0, nodeRefArray, blArray);
    }

    private static int mauCanonicalSub(Tree tree, NodeRef nodeRef, int n, NodeRef[] nodeRefArray, boolean[] blArray) {
        if (tree.isExternal(nodeRef)) {
            nodeRefArray[n] = nodeRef;
            assert ((n & 1) == 0);
            return n + 1;
        }
        boolean bl = MathUtils.nextBoolean();
        int n2 = MulTreeNodeSlide.mauCanonicalSub(tree, tree.getChild(nodeRef, bl ? 1 : 0), n, nodeRefArray, blArray);
        nodeRefArray[n2] = nodeRef;
        assert ((n2 & 1) == 1);
        blArray[(n2 - 1) / 2] = bl;
        n2 = MulTreeNodeSlide.mauCanonicalSub(tree, tree.getChild(nodeRef, bl ? 0 : 1), n2 + 1, nodeRefArray, blArray);
        return n2;
    }

    private static void mauReconstruct(MulSpeciesTreeModel mulSpeciesTreeModel, NodeRef[] nodeRefArray, boolean[] blArray) {
        NodeRef nodeRef = MulTreeNodeSlide.mauReconstructSub(mulSpeciesTreeModel, 0, blArray.length, nodeRefArray, blArray);
        if (mulSpeciesTreeModel.getRoot() != nodeRef) {
            mulSpeciesTreeModel.setRoot(nodeRef);
        }
    }

    private static NodeRef mauReconstructSub(MulSpeciesTreeModel mulSpeciesTreeModel, int n, int n2, NodeRef[] nodeRefArray, boolean[] blArray) {
        if (n == n2) {
            return nodeRefArray[2 * n];
        }
        int n3 = -1;
        double d = -1.0;
        for (int i = n; i < n2; ++i) {
            double d2 = mulSpeciesTreeModel.getNodeHeight(nodeRefArray[2 * i + 1]);
            if (!(d < d2)) continue;
            d = d2;
            n3 = i;
        }
        NodeRef nodeRef = nodeRefArray[2 * n3 + 1];
        NodeRef nodeRef2 = mulSpeciesTreeModel.getChild(nodeRef, 0);
        NodeRef nodeRef3 = mulSpeciesTreeModel.getChild(nodeRef, 1);
        NodeRef nodeRef4 = MulTreeNodeSlide.mauReconstructSub(mulSpeciesTreeModel, n, n3, nodeRefArray, blArray);
        NodeRef nodeRef5 = MulTreeNodeSlide.mauReconstructSub(mulSpeciesTreeModel, n3 + 1, n2, nodeRefArray, blArray);
        if (blArray[n3]) {
            NodeRef nodeRef6 = nodeRef4;
            nodeRef4 = nodeRef5;
            nodeRef5 = nodeRef6;
        }
        if (nodeRef2 != nodeRef4) {
            mulSpeciesTreeModel.replaceChild(nodeRef, nodeRef2, nodeRef4);
        }
        if (nodeRef3 != nodeRef5) {
            mulSpeciesTreeModel.replaceChild(nodeRef, nodeRef3, nodeRef5);
        }
        return nodeRef;
    }
}

