/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import java.util.function.Consumer;
import org.ohdsi.circe.check.checkers.BaseCheckerFactory;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.cohortdefinition.ConditionEra;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.DemographicCriteria;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DoseEra;
import org.ohdsi.circe.cohortdefinition.DrugEra;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ObservationPeriod;
import org.ohdsi.circe.cohortdefinition.PayerPlanPeriod;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;
import org.ohdsi.circe.vocabulary.Concept;

public class ConceptCheckerFactory
extends BaseCheckerFactory {
    private static final String WARNING_EMPTY_VALUE = "%s in the %s has empty %s value";

    private ConceptCheckerFactory(WarningReporter reporter, String groupName) {
        super(reporter, groupName);
    }

    public static ConceptCheckerFactory getFactory(WarningReporter reporter, String groupName) {
        return new ConceptCheckerFactory(reporter, groupName);
    }

    @Override
    protected Consumer<Criteria> getCheck(Criteria criteria) {
        Consumer<Criteria> result = c -> {};
        if (criteria instanceof ConditionEra) {
            result = c -> {
                ConditionEra conditionEra = (ConditionEra)c;
                this.checkConcept(conditionEra.gender, "condition era", "gender");
            };
        } else if (criteria instanceof ConditionOccurrence) {
            result = c -> {
                ConditionOccurrence co = (ConditionOccurrence)c;
                this.checkConcept(co.conditionType, "condition occurrence", "condition type");
                this.checkConcept(co.gender, "condition occurrence", "gender");
                this.checkConcept(co.providerSpecialty, "condition occurrence", "provider speciality");
                this.checkConcept(co.visitType, "condition occurrence", "visit");
            };
        } else if (criteria instanceof Death) {
            result = c -> {
                Death death = (Death)c;
                this.checkConcept(death.deathType, "death", "death type");
                this.checkConcept(death.gender, "death", "gender");
            };
        } else if (criteria instanceof DeviceExposure) {
            result = c -> {
                DeviceExposure de = (DeviceExposure)c;
                this.checkConcept(de.deviceType, "device exposure", "device type");
                this.checkConcept(de.gender, "device exposure", "gender");
                this.checkConcept(de.providerSpecialty, "device exposure", "provider speciality");
                this.checkConcept(de.visitType, "device exposure", "visit");
            };
        } else if (criteria instanceof DoseEra) {
            result = c -> {
                DoseEra doseEra = (DoseEra)c;
                this.checkConcept(doseEra.unit, "dose era", "unit");
                this.checkConcept(doseEra.gender, "dose era", "gender");
            };
        } else if (criteria instanceof DrugEra) {
            result = c -> {
                DrugEra drugEra = (DrugEra)c;
                this.checkConcept(drugEra.gender, "drug era", "gender");
            };
        } else if (criteria instanceof DrugExposure) {
            result = c -> {
                DrugExposure de = (DrugExposure)c;
                this.checkConcept(de.drugType, "drug exposure", "drug type");
                this.checkConcept(de.routeConcept, "drug exposure", "route concept");
                this.checkConcept(de.doseUnit, "drug exposure", "dose unit");
                this.checkConcept(de.gender, "drug exposure", "gender");
                this.checkConcept(de.providerSpecialty, "drug exposure", "provider speciality");
                this.checkConcept(de.visitType, "drug exposure", "visit");
            };
        } else if (criteria instanceof Measurement) {
            result = c -> {
                Measurement m = (Measurement)c;
                this.checkConcept(m.measurementType, "measurement", "measurement type");
                this.checkConcept(m.operator, "measurement", "operator");
                this.checkConcept(m.valueAsConcept, "measurement", "value as concept");
                this.checkConcept(m.unit, "measurement", "unit");
                this.checkConcept(m.gender, "measurement", "gender");
                this.checkConcept(m.providerSpecialty, "measurement", "provider speciality");
                this.checkConcept(m.visitType, "measurement", "visit");
            };
        } else if (criteria instanceof Observation) {
            result = c -> {
                Observation o = (Observation)c;
                this.checkConcept(o.observationType, "observation", "observation type");
                this.checkConcept(o.valueAsConcept, "observation", "value as concept");
                this.checkConcept(o.qualifier, "observation", "qualifier");
                this.checkConcept(o.unit, "observation", "unit");
                this.checkConcept(o.gender, "observation", "gender");
                this.checkConcept(o.providerSpecialty, "observation", "provider speciality");
                this.checkConcept(o.visitType, "observation", "visit");
            };
        } else if (criteria instanceof ObservationPeriod) {
            result = c -> {
                ObservationPeriod op = (ObservationPeriod)c;
                this.checkConcept(op.periodType, "observation period", "period type");
            };
        } else if (criteria instanceof ProcedureOccurrence) {
            result = c -> {
                ProcedureOccurrence po = (ProcedureOccurrence)c;
                this.checkConcept(po.procedureType, "procedure occurrence", "procedure type");
                this.checkConcept(po.modifier, "procedure occurrence", "modifier");
                this.checkConcept(po.gender, "procedure occurrence", "gender");
                this.checkConcept(po.providerSpecialty, "procedure occurrence", "provider speciality");
                this.checkConcept(po.visitType, "procedure occurrence", "visit");
            };
        } else if (criteria instanceof Specimen) {
            result = c -> {
                Specimen specimen = (Specimen)c;
                this.checkConcept(specimen.specimenType, "specimen", "specimen type");
                this.checkConcept(specimen.unit, "specimen", "unit");
                this.checkConcept(specimen.anatomicSite, "specimen", "anatomic site");
                this.checkConcept(specimen.diseaseStatus, "specimen", "disease status");
                this.checkConcept(specimen.gender, "specimen", "gender");
            };
        } else if (criteria instanceof VisitOccurrence) {
            result = c -> {
                VisitOccurrence vo = (VisitOccurrence)c;
                this.checkConcept(vo.visitType, "visit occurrence", "visit");
                this.checkConcept(vo.gender, "visit occurrence", "gender");
                this.checkConcept(vo.providerSpecialty, "visit occurrence", "provider speciality");
                this.checkConcept(vo.placeOfService, "visit occurrence", "place of service");
            };
        } else if (criteria instanceof PayerPlanPeriod) {
            result = c -> {
                PayerPlanPeriod planPeriod = (PayerPlanPeriod)c;
                this.checkConcept(planPeriod.gender, "payer plan period", "gender");
            };
        }
        return result;
    }

    @Override
    protected Consumer<DemographicCriteria> getCheck(DemographicCriteria criteria) {
        Consumer<DemographicCriteria> result = c -> {
            this.checkConcept(criteria.ethnicity, "demographic", "ethnicity");
            this.checkConcept(criteria.gender, "demographic", "gender");
            this.checkConcept(criteria.race, "demographic", "race");
        };
        return result;
    }

    private void checkConcept(Concept[] concepts, String criteriaName, String attribute) {
        Consumer<String> warning = t -> this.reporter.add((String)t, this.groupName, criteriaName, attribute);
        Operations.match(concepts).when(r -> Objects.nonNull(r) && ((Concept[])r).length == 0).then(() -> warning.accept(WARNING_EMPTY_VALUE));
    }
}

