## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#"
)

## -----------------------------------------------------------------------------
library(ExtendedLaplace)
curve(dEL(x, mu = 0, sigma = 1, delta = 1), from = -5, to = 5, ylab = "Density", xlab = 'y')

## -----------------------------------------------------------------------------
curve(pEL(x, mu = 0, sigma = 1, delta = 1), from = -5, to = 5, ylab = "CDF", xlab = 'y')

## -----------------------------------------------------------------------------
qEL(c(0.025, 0.5, 0.975), mu = 0, sigma = 1, delta = 1)

## -----------------------------------------------------------------------------
samples <- rEL(10000, mu = 0, sigma = 1, delta = 1)
hist(samples, probability = TRUE, breaks = 40, main = "Simulated EL Data", xlab = 'y')
curve(dEL(x, mu = 0, sigma = 1, delta = 1), add = TRUE, col = "navy", lwd = 2)

## -----------------------------------------------------------------------------
qqplotEL(samples, mu = 0, sigma = 1, delta = 1)

## -----------------------------------------------------------------------------
sessionInfo()

