/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DiagonalFloatMatrix2D;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DenseFloatSingularValueDecomposition {
    private FloatMatrix2D U;
    private FloatMatrix2D V;
    private FloatMatrix2D S;
    private float[] elementsU;
    private float[] elementsVt;
    private float[] elementsS;
    private intW info;
    private int m;
    private int n;
    private int mn;
    private boolean wantWholeUV;
    private boolean wantUV;
    private boolean columnMatrix = false;

    public DenseFloatSingularValueDecomposition(FloatMatrix2D floatMatrix2D, boolean bl, boolean bl2) {
        float[] fArray;
        FloatProperty.DEFAULT.checkDense(floatMatrix2D);
        this.wantUV = bl;
        this.wantWholeUV = bl2;
        this.m = floatMatrix2D.rows();
        this.n = floatMatrix2D.columns();
        if (floatMatrix2D instanceof DenseColumnFloatMatrix2D) {
            fArray = (float[])floatMatrix2D.copy().elements();
            this.columnMatrix = true;
        } else {
            fArray = (float[])floatMatrix2D.viewDice().copy().elements();
        }
        this.mn = Math.min(this.m, this.n);
        int n = Math.max(this.m, this.n);
        this.info = new intW(2);
        int[] nArray = new int[8 * this.mn];
        this.elementsS = new float[this.mn];
        bl = true;
        if (true) {
            if (bl2) {
                this.elementsU = new float[this.m * this.m];
                this.elementsVt = new float[this.n * this.n];
                int n2 = 3 * this.mn * this.mn + Math.max(n, 4 * this.mn * this.mn + 4 * this.mn) + n;
                float[] fArray2 = new float[n2];
                LAPACK.getInstance().sgesdd("A", this.m, this.n, fArray, this.m, this.elementsS, this.elementsU, this.m, this.elementsVt, this.n, fArray2, n2, nArray, this.info);
            } else {
                this.elementsU = new float[this.m * this.mn];
                this.elementsVt = new float[this.mn * this.n];
                int n3 = 3 * this.mn * this.mn + Math.max(n, 4 * this.mn * this.mn + 4 * this.mn) + n;
                float[] fArray3 = new float[n3];
                LAPACK.getInstance().sgesdd("S", this.m, this.n, fArray, this.m, this.elementsS, this.elementsU, this.m, this.elementsVt, this.mn, fArray3, n3, nArray, this.info);
            }
        } else {
            int n4 = 3 * this.mn + Math.max(n, 6 * this.mn) + n;
            float[] fArray4 = new float[n4];
            LAPACK.getInstance().sgesdd("N", this.m, this.n, fArray, this.m, this.elementsS, null, this.m, null, this.n, fArray4, n4, nArray, this.info);
        }
        if (this.info.val != 0) {
            throw new IllegalArgumentException("Error occured while computing SVD decomposition: " + this.info);
        }
    }

    public float cond() {
        return this.elementsS[0] / this.elementsS[this.mn - 1];
    }

    public FloatMatrix2D getS() {
        if (this.S == null) {
            this.S = !this.wantWholeUV ? new DiagonalFloatMatrix2D(this.mn, this.mn, 0) : new DiagonalFloatMatrix2D(this.m, this.n, 0);
            for (int i = 0; i < this.mn; ++i) {
                this.S.setQuick(i, i, this.elementsS[i]);
            }
        }
        return this.S.copy();
    }

    public float[] getSingularValues() {
        return this.elementsS;
    }

    public FloatMatrix2D getU() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix U was not computed");
        }
        if (this.U == null) {
            this.U = !this.wantWholeUV ? (this.columnMatrix ? new DenseColumnFloatMatrix2D(this.m, this.mn).assign(this.elementsU) : new DenseFloatMatrix2D(this.mn, this.m).assign(this.elementsU).viewDice()) : (this.columnMatrix ? new DenseColumnFloatMatrix2D(this.m, this.m).assign(this.elementsU) : new DenseFloatMatrix2D(this.m, this.m).assign(this.elementsU).viewDice());
        }
        return this.U.copy();
    }

    public FloatMatrix2D getV() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix V was not computed");
        }
        if (this.V == null) {
            this.V = !this.wantWholeUV ? (this.columnMatrix ? new DenseColumnFloatMatrix2D(this.mn, this.n).assign(this.elementsVt).viewDice() : new DenseFloatMatrix2D(this.n, this.mn).assign(this.elementsVt)) : (this.columnMatrix ? new DenseColumnFloatMatrix2D(this.n, this.n).assign(this.elementsVt).viewDice() : new DenseFloatMatrix2D(this.n, this.n).assign(this.elementsVt));
        }
        return this.V.copy();
    }

    public intW getInfo() {
        return this.info;
    }

    public float norm2() {
        return this.elementsS[0];
    }

    public int rank() {
        float f = (float)Math.pow(2.0, -23.0);
        float f2 = (float)Math.max(this.m, this.n) * this.elementsS[0] * f;
        int n = 0;
        for (int i = 0; i < this.elementsS.length; ++i) {
            if (!(this.elementsS[i] > f2)) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        stringBuffer.append("---------------------------------------------------------------------\n");
        stringBuffer.append("cond = ");
        try {
            stringBuffer.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nrank = ");
        try {
            stringBuffer.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\nnorm2 = ");
        try {
            stringBuffer.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nU = ");
        try {
            stringBuffer.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nS = ");
        try {
            stringBuffer.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nV = ");
        try {
            stringBuffer.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

