/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProcessingInformation {
    public static final String SUCCEEDED = "Succeeded";
    public static final String FAILED = "Failed";
    public static final String STARTED = "Started";
    public final String name;
    public final String origin;
    public final String msg;
    public final InformationType type;
    public final Object details;

    protected ProcessingInformation(String name, String origin, String msg, InformationType type, Object details) {
        this.name = name;
        this.origin = origin;
        this.msg = msg == null ? "Undefined" : msg;
        this.type = type;
        this.details = details;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(": ").append(this.msg);
        return builder.toString();
    }

    public static List<String> getMessages(List<ProcessingInformation> infos, InformationType type) {
        if (infos == null || infos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> msg = new ArrayList<String>();
        for (ProcessingInformation inf : infos) {
            if (inf.type != type) continue;
            msg.add(inf.toString());
        }
        return msg;
    }

    public static List<ProcessingInformation> addPrefix(List<ProcessingInformation> infos, String prefix) {
        if (infos == null || infos.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ProcessingInformation> msg = new ArrayList<ProcessingInformation>();
        for (ProcessingInformation inf : infos) {
            msg.add(inf.addPrefix(prefix));
        }
        return msg;
    }

    public static List<String> getErrorMessages(List<ProcessingInformation> infos) {
        return ProcessingInformation.getMessages(infos, InformationType.Error);
    }

    public static List<String> getWarningMessages(List<ProcessingInformation> infos) {
        return ProcessingInformation.getMessages(infos, InformationType.Warning);
    }

    public static boolean hasInformation(List<ProcessingInformation> infos, InformationType type) {
        if (infos == null || infos.isEmpty()) {
            return false;
        }
        for (ProcessingInformation inf : infos) {
            if (inf.type != type) continue;
            return true;
        }
        return false;
    }

    public static boolean hasErrors(List<ProcessingInformation> infos) {
        return ProcessingInformation.hasInformation(infos, InformationType.Error);
    }

    public static boolean hasWarnings(List<ProcessingInformation> infos) {
        return ProcessingInformation.hasInformation(infos, InformationType.Warning);
    }

    public ProcessingInformation addPrefix(String prefix) {
        return new ProcessingInformation(prefix + '.' + this.name, this.origin, this.msg, this.type, this.details);
    }

    public static ProcessingInformation error(String name, Exception err) {
        return new ProcessingInformation(name, null, err != null ? err.getMessage() : "Unexpected error", InformationType.Error, err);
    }

    public static ProcessingInformation error(String name, String msg, Object err) {
        return new ProcessingInformation(name, null, msg, InformationType.Error, err);
    }

    public static ProcessingInformation warning(String name, String msg, Object info) {
        return new ProcessingInformation(name, null, msg, InformationType.Warning, info);
    }

    public static ProcessingInformation error(String name, String msg) {
        return new ProcessingInformation(name, null, msg, InformationType.Error, null);
    }

    public static ProcessingInformation warning(String name, String msg) {
        return new ProcessingInformation(name, null, msg, InformationType.Warning, null);
    }

    public static ProcessingInformation info(String name, String msg, Object details) {
        return new ProcessingInformation(name, null, msg, InformationType.Info, details);
    }

    public static ProcessingInformation info(String name, String msg) {
        return new ProcessingInformation(name, null, msg, InformationType.Info, null);
    }

    public static ProcessingInformation error(String name, String origin, Exception err) {
        return new ProcessingInformation(name, origin, err != null ? err.getMessage() : "Unexpected error", InformationType.Error, err);
    }

    public static ProcessingInformation error(String name, String origin, String msg, Object err) {
        return new ProcessingInformation(name, origin, msg, InformationType.Error, err);
    }

    public static ProcessingInformation warning(String name, String origin, String msg, Object info) {
        return new ProcessingInformation(name, origin, msg, InformationType.Warning, info);
    }

    public static ProcessingInformation error(String name, String origin, String msg) {
        return new ProcessingInformation(name, origin, msg, InformationType.Error, null);
    }

    public static ProcessingInformation warning(String name, String origin, String msg) {
        return new ProcessingInformation(name, origin, msg, InformationType.Warning, null);
    }

    public static ProcessingInformation info(String name, String origin, String msg, Object details) {
        return new ProcessingInformation(name, origin, msg, InformationType.Info, details);
    }

    public static ProcessingInformation info(String name, String origin, String msg) {
        return new ProcessingInformation(name, origin, msg, InformationType.Info, null);
    }

    public static ProcessingInformation start(String name, String origin) {
        return new ProcessingInformation(name, origin, STARTED, InformationType.Log, null);
    }

    public static ProcessingInformation success(String name, String origin) {
        return new ProcessingInformation(name, origin, SUCCEEDED, InformationType.Log, null);
    }

    public static ProcessingInformation failure(String name, String origin) {
        return new ProcessingInformation(name, origin, FAILED, InformationType.Log, null);
    }

    public static ProcessingInformation log(String name, String origin, String message) {
        return new ProcessingInformation(name, origin, message, InformationType.Log, null);
    }

    public static enum InformationType {
        Error,
        Warning,
        Info,
        Log;

    }
}

