/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import java.util.Random;
import moa.core.ObjectRepository;
import moa.options.ClassOption;
import moa.options.IntOption;
import moa.streams.CachedInstancesStream;
import moa.streams.InstanceStream;
import moa.tasks.AbstractTask;
import moa.tasks.TaskMonitor;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheShuffledStream
extends AbstractTask {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to cache and shuffle.", InstanceStream.class, "generators.RandomTreeGenerator");
    public IntOption maximumCacheSizeOption = new IntOption("maximumCacheSize", 'm', "Maximum number of instances to cache.", 1000000, 1, Integer.MAX_VALUE);
    public IntOption shuffleRandomSeedOption = new IntOption("shuffleRandomSeed", 'r', "Seed for random shuffling of instances.", 1);

    @Override
    public String getPurposeString() {
        return "Stores and shuffles examples in memory.";
    }

    @Override
    protected Object doTaskImpl(TaskMonitor monitor, ObjectRepository repository) {
        InstanceStream stream = (InstanceStream)this.getPreparedClassOption(this.streamOption);
        Instances cache = new Instances(stream.getHeader(), 0);
        monitor.setCurrentActivity("Caching instances...", -1.0);
        while (cache.numInstances() < this.maximumCacheSizeOption.getValue() && stream.hasMoreInstances()) {
            cache.add(stream.nextInstance());
            if (cache.numInstances() % 10 != 0) continue;
            if (monitor.taskShouldAbort()) {
                return null;
            }
            long estimatedRemainingInstances = stream.estimatedRemainingInstances();
            long maxRemaining = this.maximumCacheSizeOption.getValue() - cache.numInstances();
            if (estimatedRemainingInstances < 0L || maxRemaining < estimatedRemainingInstances) {
                estimatedRemainingInstances = maxRemaining;
            }
            monitor.setCurrentActivityFractionComplete(estimatedRemainingInstances < 0L ? -1.0 : (double)cache.numInstances() / (double)((long)cache.numInstances() + estimatedRemainingInstances));
        }
        monitor.setCurrentActivity("Shuffling instances...", -1.0);
        cache.randomize(new Random(this.shuffleRandomSeedOption.getValue()));
        return new CachedInstancesStream(cache);
    }

    @Override
    public Class<?> getTaskResultType() {
        return CachedInstancesStream.class;
    }
}

