/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.externalConstraints.ExternalConstraint;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import choco.cp.solver.constraints.global.geost.layers.ExternalLayer;
import choco.cp.solver.constraints.global.geost.layers.GeometricKernel;
import choco.cp.solver.constraints.global.geost.layers.IntermediateLayer;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateInt;
import choco.kernel.model.constraints.geost.GeostOptions;
import choco.kernel.model.variables.geost.ShiftedBox;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solution;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import com.sun.tools.javac.util.Pair;
import java.util.HashMap;
import java.util.List;

public final class Geost_Constraint
extends AbstractLargeIntSConstraint {
    int[] oIDs;
    IStateInt lastNonFixedO;
    Constants cst = new Constants();
    Setup stp;
    ExternalLayer externalLayer;
    GeometricKernel geometricKernel;
    IntermediateLayer intermediateLayer;
    protected Solver s;
    private int greedyMode = 0;
    boolean increment = false;
    List<int[]> ctrlVs;

    public Geost_Constraint(IntDomainVar[] vars, int k, List<Obj> objects, List<ShiftedBox> shiftedBoxes, List<ExternalConstraint> ectr, List<int[]> ctrlVs, boolean memo_active, HashMap<Pair<Integer, Integer>, Boolean> included, boolean increment_, Solver solver) {
        super(ConstraintEvent.VERY_SLOW, vars);
        this.stp = new Setup(this.cst, solver.getPropagationEngine(), this);
        this.intermediateLayer = new IntermediateLayer();
        this.externalLayer = new ExternalLayer(this.cst, this.stp);
        this.geometricKernel = new GeometricKernel(this.cst, this.stp, this.externalLayer, this.intermediateLayer, memo_active, included, solver, this);
        this.cst.setDIM(k);
        this.ctrlVs = ctrlVs;
        this.stp.SetupTheProblem(objects, shiftedBoxes, ectr);
        this.oIDs = new int[this.stp.getNbOfObjects()];
        for (int i = 0; i < this.stp.getNbOfObjects(); ++i) {
            this.oIDs[i] = objects.get(i).getObjectId();
        }
        this.lastNonFixedO = solver.getEnvironment().makeInt(this.oIDs.length);
        this.s = solver;
        this.greedyMode = 1;
        this.increment = increment_;
        IntDomainVarImpl D = new IntDomainVarImpl(this.s, "D", 1, 0, 100);
    }

    public Geost_Constraint(IntDomainVar[] vars, int k, List<Obj> objects, List<ShiftedBox> shiftedBoxes, List<ExternalConstraint> ectr, boolean memo, HashMap<Pair<Integer, Integer>, Boolean> included, Solver solver) {
        super(ConstraintEvent.VERY_SLOW, vars);
        this.stp = new Setup(this.cst, solver.getPropagationEngine(), this);
        this.intermediateLayer = new IntermediateLayer();
        this.externalLayer = new ExternalLayer(this.cst, this.stp);
        this.geometricKernel = new GeometricKernel(this.cst, this.stp, this.externalLayer, this.intermediateLayer, memo, included, solver, this);
        this.cst.setDIM(k);
        this.stp.SetupTheProblem(objects, shiftedBoxes, ectr);
        this.oIDs = new int[this.stp.getNbOfObjects()];
        for (int i = 0; i < this.stp.getNbOfObjects(); ++i) {
            this.oIDs[i] = objects.get(i).getObjectId();
        }
        this.lastNonFixedO = solver.getEnvironment().makeInt(this.oIDs.length);
        this.s = solver;
    }

    public void filter() throws ContradictionException {
        if (this.greedyMode == 0) {
            this.filterWithoutGreedyMode();
        } else {
            long tmpTime = System.nanoTime() / 1000000L;
            this.filterWithGreedyMode();
            GeostOptions cfr_ignored_0 = this.stp.opt;
            GeostOptions.timefilterWithGreedyMode += System.nanoTime() / 1000000L - tmpTime;
        }
    }

    private void filterWithGreedyMode() throws ContradictionException {
        long tmpTime;
        long tmpTimeFixAllObj;
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("Geost_Constraint:filterWithGreedyMode()");
        }
        this.s.worldPush();
        boolean result = false;
        if (!this.increment) {
            tmpTimeFixAllObj = System.nanoTime() / 1000000L;
            result = this.geometricKernel.fixAllObjs(this.cst.getDIM(), this.oIDs, this.stp.getConstraints(), this.ctrlVs, this.lastNonFixedO);
            GeostOptions cfr_ignored_1 = this.stp.opt;
            GeostOptions.timeFixAllObj += System.nanoTime() / 1000000L - tmpTimeFixAllObj;
        } else {
            tmpTimeFixAllObj = System.nanoTime() / 1000000L;
            result = this.geometricKernel.fixAllObjs_incr(this.cst.getDIM(), this.oIDs, this.stp.getConstraints(), this.ctrlVs, this.lastNonFixedO);
            GeostOptions cfr_ignored_2 = this.stp.opt;
            GeostOptions.timeFixAllObj += System.nanoTime() / 1000000L - tmpTimeFixAllObj;
        }
        if (!result) {
            this.s.worldPop();
            tmpTime = System.nanoTime() / 1000000L;
            this.filterWithoutGreedyMode();
            GeostOptions cfr_ignored_3 = this.stp.opt;
            GeostOptions.timefilterWithoutGreedyMode += System.nanoTime() / 1000000L - tmpTime;
        } else {
            tmpTime = System.nanoTime() / 1000000L;
            Solution sol = new Solution(this.s);
            for (int i = 0; i < this.s.getNbIntVars(); ++i) {
                sol.recordIntValue(i, this.s.getIntVar(i).getVal());
            }
            GeostOptions cfr_ignored_4 = this.stp.opt;
            GeostOptions.handleSolution1 += System.nanoTime() / 1000000L - tmpTime;
            tmpTime = System.nanoTime() / 1000000L;
            this.s.worldPop();
            GeostOptions cfr_ignored_5 = this.stp.opt;
            GeostOptions.handleSolution2 += System.nanoTime() / 1000000L - tmpTime;
            tmpTime = System.nanoTime() / 1000000L;
            this.s.restoreSolution(sol);
            GeostOptions cfr_ignored_6 = this.stp.opt;
            GeostOptions.handleSolution3 += System.nanoTime() / 1000000L - tmpTime;
        }
    }

    private void filterWithoutGreedyMode() throws ContradictionException {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("Geost_Constraint:filterWithoutGreedyMode()");
        }
        if (!this.geometricKernel.filterCtrs(this.cst.getDIM(), this.oIDs, this.stp.getConstraints())) {
            this.fail();
        }
    }

    @Override
    public boolean isSatisfied() {
        boolean b = false;
        this.s.worldPushDuringPropagation();
        try {
            b = this.geometricKernel.filterCtrs(this.cst.getDIM(), this.oIDs, this.stp.getConstraints());
        }
        catch (ContradictionException e) {
            b = false;
        }
        this.s.worldPopDuringPropagation();
        return b;
    }

    @Override
    public void propagate() throws ContradictionException {
        GeostOptions cfr_ignored_0 = this.stp.opt;
        if (GeostOptions.debug) {
            LOGGER.info("GeostConstraint:propagate()");
        }
        this.filter();
    }

    @Override
    public void awake() throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.constAwake(false);
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.constAwake(false);
    }

    public Constants getCst() {
        return this.cst;
    }

    public Setup getStp() {
        return this.stp;
    }

    public void setCst(Constants cst) {
        this.cst = cst;
    }

    public void setStp(Setup stp) {
        this.stp = stp;
    }

    public ExternalLayer getExternalLayer() {
        return this.externalLayer;
    }

    public List<InternalConstraint> getForbiddenRegions(Obj o) {
        int i;
        List<ExternalConstraint> ectrs = this.stp.getConstraints();
        for (i = 0; i < ectrs.size(); ++i) {
            ectrs.get(i).setFrame(this.externalLayer.InitFrameExternalConstraint(ectrs.get(i), this.oIDs));
        }
        for (i = 0; i < o.getRelatedExternalConstraints().size(); ++i) {
            List<InternalConstraint> v = this.externalLayer.genInternalCtrs(o.getRelatedExternalConstraints().get(i), o);
            for (int j = 0; j < v.size(); ++j) {
                o.addRelatedInternalConstraint(v.get(j));
            }
        }
        return o.getRelatedInternalConstraints();
    }

    public void setGreedy(boolean greedy) {
        this.greedyMode = greedy ? 1 : 0;
    }

    public boolean isGreedy() {
        return this.greedyMode != 0;
    }
}

