/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Iterables;
import com.google.common.math.DoubleMath;
import java.util.Collection;
import java.util.HashSet;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;

public class TypeUtil {
    private TypeUtil() {
    }

    public static DataType getDataType(Object value) {
        if (value instanceof String) {
            return DataType.STRING;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return DataType.INTEGER;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        throw new IllegalArgumentException();
    }

    public static DataType getDataType(String value) {
        try {
            Integer.parseInt(value);
            return DataType.INTEGER;
        }
        catch (NumberFormatException integerNfe) {
            try {
                double doubleValue = Double.parseDouble(value);
                if (DoubleMath.isMathematicalInteger((double)doubleValue)) {
                    return DataType.INTEGER;
                }
                return DataType.DOUBLE;
            }
            catch (NumberFormatException doubleNfe) {
                return DataType.STRING;
            }
        }
    }

    public static DataType getDataType(Collection<?> values) {
        return TypeUtil.getDataType(values, null);
    }

    public static DataType getDataType(Collection<?> values, DataType defaultDataType) {
        if (values.isEmpty()) {
            if (defaultDataType != null) {
                return defaultDataType;
            }
            throw new IllegalArgumentException();
        }
        boolean allStrings = true;
        HashSet<DataType> dataTypes = new HashSet<DataType>();
        for (Object value : values) {
            DataType dataType;
            if (value instanceof String) {
                dataType = TypeUtil.getDataType((String)value);
            } else {
                allStrings = false;
                dataType = TypeUtil.getDataType(value);
            }
            dataTypes.add(dataType);
        }
        if (dataTypes.size() == 1) {
            return (DataType)Iterables.getOnlyElement(dataTypes);
        }
        if (allStrings) {
            return DataType.STRING;
        }
        throw new IllegalArgumentException("Expected all values to be of the same data type, got " + dataTypes.size() + " different data types (" + dataTypes + ")");
    }

    public static OpType getOpType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return OpType.CATEGORICAL;
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                return OpType.CONTINUOUS;
            }
            case BOOLEAN: {
                return OpType.CATEGORICAL;
            }
            case DATE: 
            case DATE_TIME: {
                return OpType.ORDINAL;
            }
        }
        throw new IllegalArgumentException();
    }
}

