/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropXeqCReif
extends Propagator<IntVar> {
    IntVar var;
    int cste;
    BoolVar r;

    public PropXeqCReif(IntVar x, int c, BoolVar r) {
        super((Variable[])new IntVar[]{x, r}, (Priority)PropagatorPriority.BINARY, false);
        this.cste = c;
        this.var = x;
        this.r = r;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.r.isInstantiated()) {
            if (this.r.getValue() == 1) {
                this.var.instantiateTo(this.cste, (ICause)this);
                this.setPassive();
            } else if (this.var.removeValue(this.cste, (ICause)this) || !this.var.contains(this.cste)) {
                this.setPassive();
            }
        } else if (this.var.isInstantiatedTo(this.cste)) {
            this.r.setToTrue(this);
            this.setPassive();
        } else if (!this.var.contains(this.cste)) {
            this.r.setToFalse(this);
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.r.isInstantiatedTo(1)) {
                return ESat.eval(this.var.contains(this.cste));
            }
            return ESat.eval(!this.var.contains(this.cste));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        if (((IntVar[])this.vars)[1].isInstantiatedTo(1)) {
            if (pivot == ((IntVar[])this.vars)[1]) {
                ((IntVar[])this.vars)[1].intersectLit(1, explanation);
                IntIterableRangeSet dom0 = explanation.universe();
                dom0.remove(this.cste);
                ((IntVar[])this.vars)[0].unionLit(dom0, explanation);
            } else if (pivot == ((IntVar[])this.vars)[0]) {
                ((IntVar[])this.vars)[1].unionLit(0, explanation);
                ((IntVar[])this.vars)[0].intersectLit(this.cste, explanation);
            }
        } else if (((IntVar[])this.vars)[1].isInstantiatedTo(0)) {
            if (pivot == ((IntVar[])this.vars)[1]) {
                ((IntVar[])this.vars)[1].intersectLit(0, explanation);
                ((IntVar[])this.vars)[0].unionLit(this.cste, explanation);
            } else if (pivot == ((IntVar[])this.vars)[0]) {
                ((IntVar[])this.vars)[1].unionLit(1, explanation);
                IntIterableRangeSet dom0 = explanation.universe();
                dom0.remove(this.cste);
                ((IntVar[])this.vars)[0].intersectLit(dom0, explanation);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public String toString() {
        return "(" + this.var.getName() + " = " + this.cste + ") <=> " + this.r.getName();
    }
}

