/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.Date;
import java.util.Iterator;
import org.vikamine.kernel.util.AttributeValuesIterator;
import org.vikamine.kernel.util.DateStatistics;

public class DateStatisticsIterator
implements AttributeValuesIterator {
    private DateStatistics stat;
    private DateStatistics.Interval currentInterval = null;
    private Iterator intervalIterator;
    private int currentIndex = 0;

    public DateStatisticsIterator(DateStatistics stat) {
        this.stat = stat;
        this.intervalIterator = stat.getIntervals().iterator();
    }

    @Override
    public int getIterationValueCount() {
        return this.stat.getIntervals().size();
    }

    @Override
    public int getCurrentInstancesCount() {
        if (this.currentInterval == null) {
            throw new IllegalStateException("must call next() at least once before");
        }
        return this.currentInterval.instancesCount;
    }

    public Date getCurrentIntervalStart() {
        Date begin = new Date();
        begin.setTime(this.currentInterval.begin.getTimeInMillis());
        return begin;
    }

    public Date getCurrentIntervalEndExclusive() {
        Date end = new Date();
        end.setTime(this.currentInterval.end.getTimeInMillis());
        return end;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }

    @Override
    public boolean hasNext() {
        return this.intervalIterator.hasNext();
    }

    public Object next() {
        this.currentInterval = (DateStatistics.Interval)this.intervalIterator.next();
        ++this.currentIndex;
        return new Double(this.currentIndex);
    }
}

