/*
 * Decompiled with CFR 0.152.
 */
package moa.recommender.rc.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import moa.recommender.rc.utils.Pair;
import moa.recommender.rc.utils.Vector;

public class SparseVector
extends Vector {
    private static final long serialVersionUID = 1971022389328939125L;
    private Map<Integer, Double> map;

    public SparseVector() {
        this.map = new HashMap<Integer, Double>();
    }

    public SparseVector(Map<Integer, Double> map) {
        this.map = map == null ? new HashMap<Integer, Double>() : map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void set(int index, double val) {
        this.map.put(index, val);
    }

    @Override
    public void remove(int index) {
        this.map.remove(index);
    }

    @Override
    public Set<Integer> getIdxs() {
        return this.map.keySet();
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(new HashMap<Integer, Double>(this.map));
    }

    @Override
    public Double get(int index) {
        return this.map.get(index);
    }

    @Override
    public Iterator<Pair<Integer, Double>> iterator() {
        return new SparseVectorIterator();
    }

    public class SparseVectorIterator
    implements Iterator<Pair<Integer, Double>> {
        private Iterator<Integer> it;

        public SparseVectorIterator() {
            this.it = SparseVector.this.map.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Pair<Integer, Double> next() {
            Integer idx = this.it.next();
            return new Pair<Integer, Double>(idx, (Double)SparseVector.this.map.get(idx));
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

