/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.branchmodel;

import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.NodeRef;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.substmodel.codon.GY94CodonModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math.random.MersenneTwister;

public class RandomBranchModel
extends AbstractModel
implements BranchModel {
    public static final String RANDOM_BRANCH_MODEL = "randomBranchModel";
    private final TreeModel treeModel;
    private GY94CodonModel baseSubstitutionModel;
    private LinkedList<SubstitutionModel> substitutionModels;
    private LinkedHashMap<NodeRef, Integer> branchAssignmentMap;
    private double rate;
    private static MersenneTwister random;

    public RandomBranchModel(TreeModel treeModel, GY94CodonModel gY94CodonModel, double d, boolean bl, long l) {
        super(RANDOM_BRANCH_MODEL);
        this.treeModel = treeModel;
        this.baseSubstitutionModel = gY94CodonModel;
        this.rate = d;
        random = bl ? new MersenneTwister(l) : new MersenneTwister(MathUtils.nextLong());
        this.setup();
    }

    private void setup() {
        DataType dataType = this.baseSubstitutionModel.getDataType();
        FrequencyModel frequencyModel = this.baseSubstitutionModel.getFrequencyModel();
        Parameter.Default default_ = new Parameter.Default("kappa", 1, this.baseSubstitutionModel.getKappa());
        this.substitutionModels = new LinkedList();
        this.branchAssignmentMap = new LinkedHashMap();
        int n = 0;
        for (NodeRef nodeRef : this.treeModel.getNodes()) {
            if (this.treeModel.isRoot(nodeRef)) continue;
            double d = this.treeModel.getNodeHeight(nodeRef);
            double d2 = this.treeModel.getNodeHeight(this.treeModel.getParent(nodeRef));
            double d3 = 0.5 * (d2 + d);
            double d4 = this.baseSubstitutionModel.getOmega();
            double d5 = d4 * d3;
            double d6 = Math.log(1.0 - random.nextDouble()) / -this.rate;
            double d7 = d5 + d6;
            Parameter.Default default_2 = new Parameter.Default("omega", 1, d7);
            GY94CodonModel gY94CodonModel = new GY94CodonModel((Codons)dataType, default_2, default_, frequencyModel);
            this.substitutionModels.add(gY94CodonModel);
            this.branchAssignmentMap.put(nodeRef, n);
            ++n;
        }
    }

    @Override
    public BranchModel.Mapping getBranchModelMapping(NodeRef nodeRef) {
        final int n = this.branchAssignmentMap.get(nodeRef);
        return new BranchModel.Mapping(){

            @Override
            public int[] getOrder() {
                return new int[]{n};
            }

            @Override
            public double[] getWeights() {
                return new double[]{1.0};
            }
        };
    }

    @Override
    public List<SubstitutionModel> getSubstitutionModels() {
        return this.substitutionModels;
    }

    @Override
    public SubstitutionModel getRootSubstitutionModel() {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public FrequencyModel getRootFrequencyModel() {
        return this.getRootSubstitutionModel().getFrequencyModel();
    }

    @Override
    public boolean requiresMatrixConvolution() {
        return false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

