/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceDistribution;
import dr.inference.trace.TraceException;
import dr.inference.trace.TraceList;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.util.NumberFormatter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class CnCsPerSiteAnalysis
implements Citable {
    public static final String CNCS_PER_SITE_ANALYSIS = "cNcSPerSiteAnalysis";
    public static final String BURN_IN = "burnin";
    public static final String CUTOFF = "cutoff";
    public static final String INCLUDE_SIGNIFICANT_SYMBOL = "includeSymbol";
    public static final String INCLUDE_PVALUES = "includePValues";
    public static final String INCLUDE_SITE_CLASSIFICATION = "includeClassification";
    public static final String SEPARATOR_STRING = "separator";
    public static final String INCLUDE_SIMULATION_OUTCOME = "simulationOutcome";
    public static final String SITE_SIMULATION = "siteSimulation";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("cutoff", true), AttributeRule.newIntegerRule("burnin", true), AttributeRule.newBooleanRule("includePValues", true), AttributeRule.newBooleanRule("includeSymbol", true), AttributeRule.newBooleanRule("includeClassification", true), AttributeRule.newBooleanRule("simulationOutcome", true), AttributeRule.newStringRule("siteSimulation", true), AttributeRule.newStringRule("separator", true)};

        @Override
        public String getParserName() {
            return CnCsPerSiteAnalysis.CNCS_PER_SITE_ANALYSIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("fileNameCN");
            String string2 = xMLObject.getStringAttribute("fileNameCS");
            try {
                long l;
                File file = new File(string);
                File file2 = new File(string2);
                String string3 = file.getName();
                String string4 = file2.getName();
                String string5 = file.getParent();
                String string6 = file2.getParent();
                if (!file.isAbsolute()) {
                    string5 = System.getProperty("user.dir");
                }
                if (!file2.isAbsolute()) {
                    string6 = System.getProperty("user.dir");
                }
                file = new File(string5, string3);
                file2 = new File(string6, string4);
                string2 = file2.getAbsolutePath();
                LogFileTraces logFileTraces = new LogFileTraces(string, file);
                LogFileTraces logFileTraces2 = new LogFileTraces(string2, file2);
                logFileTraces.loadTraces();
                logFileTraces2.loadTraces();
                long l2 = logFileTraces.getMaxState();
                long l3 = logFileTraces2.getMaxState();
                if (l2 != l3) {
                    System.err.println("max states in" + string + "and" + string2 + "are not equal");
                }
                if ((l = xMLObject.getAttribute(CnCsPerSiteAnalysis.BURN_IN, l2 / 10L).longValue()) < 0L || l >= l2) {
                    l = l2 / 5L;
                    System.out.println("WARNING: Burn-in larger than total number of states - using 20%");
                }
                logFileTraces.setBurnIn(l);
                logFileTraces2.setBurnIn(l);
                CnCsPerSiteAnalysis cnCsPerSiteAnalysis = new CnCsPerSiteAnalysis(logFileTraces, logFileTraces2);
                cnCsPerSiteAnalysis.setCutoff(xMLObject.getAttribute(CnCsPerSiteAnalysis.CUTOFF, 0.05));
                cnCsPerSiteAnalysis.setSeparator(xMLObject.getAttribute(CnCsPerSiteAnalysis.SEPARATOR_STRING, "\t"));
                cnCsPerSiteAnalysis.setincludePValues(xMLObject.getAttribute(CnCsPerSiteAnalysis.INCLUDE_PVALUES, true));
                cnCsPerSiteAnalysis.setIncludeSignificantSymbol(xMLObject.getAttribute(CnCsPerSiteAnalysis.INCLUDE_SIGNIFICANT_SYMBOL, true));
                cnCsPerSiteAnalysis.setIncludeSiteClassification(xMLObject.getAttribute(CnCsPerSiteAnalysis.INCLUDE_SITE_CLASSIFICATION, true));
                cnCsPerSiteAnalysis.setIncludeSimulationOutcome(xMLObject.getAttribute(CnCsPerSiteAnalysis.INCLUDE_SIMULATION_OUTCOME, false));
                if (cnCsPerSiteAnalysis.getIncludeSimulationOutcome()) {
                    String string7 = xMLObject.getAttribute(CnCsPerSiteAnalysis.SITE_SIMULATION, "empty");
                    if (string7.equals("empty")) {
                        System.err.println("you want simulation evaluation but do not provide a site simulation string??");
                    } else {
                        String[] stringArray = CnCsPerSiteAnalysis.parseVariableLengthStringArray(string7);
                        cnCsPerSiteAnalysis.setSiteSimulation(stringArray);
                    }
                }
                return cnCsPerSiteAnalysis;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "or" + string2 + "' can not be opened for " + this.getParserName() + " element.");
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
        }

        @Override
        public String getParserDescription() {
            return "Performs a trace analysis of N and S counts.";
        }

        @Override
        public Class getReturnType() {
            return CnCsPerSiteAnalysis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final TraceList traceListN;
    private final TraceList traceListS;
    private final int numSites;
    private OutputFormat format;
    private int fieldWidth;
    private int firstField;
    private NumberFormatter numberFormatter;

    public CnCsPerSiteAnalysis(TraceList traceList, TraceList traceList2) {
        this.traceListN = traceList;
        this.traceListS = traceList2;
        this.numSites = traceList.getTraceCount() / 2;
        this.format = new OutputFormat();
        this.fieldWidth = 14;
        this.firstField = 10;
        this.numberFormatter = new NumberFormatter(6);
        this.numberFormatter.setPadding(true);
        this.numberFormatter.setFieldWidth(this.fieldWidth);
    }

    public void setIncludeMeans(boolean bl) {
        this.format.includeMeans = bl;
    }

    public void setIncludeSignificantSymbol(boolean bl) {
        this.format.includeSignificantSymbol = bl;
    }

    public void setincludePValues(boolean bl) {
        this.format.includePValues = bl;
    }

    public void setIncludeSimulationOutcome(boolean bl) {
        this.format.includeSimulationOutcome = bl;
    }

    public boolean getIncludeSimulationOutcome() {
        return this.format.includeSimulationOutcome;
    }

    public void setSiteSimulation(String[] stringArray) {
        this.format.siteSimulation = stringArray;
    }

    public void setIncludeSiteClassification(boolean bl) {
        this.format.includeSiteClassification = bl;
    }

    public void setCutoff(double d) {
        this.format.cutoff = d;
    }

    public void setSeparator(String string) {
        this.format.separator = string;
    }

    private String toStringSite(int n, OutputFormat outputFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        this.traceListN.analyseTrace(n);
        this.traceListN.analyseTrace(this.traceListN.getTraceCount() / 2 + n);
        this.traceListS.analyseTrace(n);
        this.traceListS.analyseTrace(this.traceListS.getTraceCount() / 2 + n);
        TraceDistribution traceDistribution = this.traceListN.getDistributionStatistics(n);
        TraceDistribution traceDistribution2 = this.traceListS.getDistributionStatistics(n);
        TraceDistribution traceDistribution3 = this.traceListN.getDistributionStatistics(this.traceListN.getTraceCount() / 2 + n);
        TraceDistribution traceDistribution4 = this.traceListS.getDistributionStatistics(this.traceListS.getTraceCount() / 2 + n);
        double d = traceDistribution.getMean();
        double d2 = traceDistribution2.getMean();
        double d3 = traceDistribution3.getMean();
        double d4 = traceDistribution4.getMean();
        stringBuilder.append(this.numberFormatter.formatToFieldWidth(Integer.toString(n + 1), this.firstField));
        if (outputFormat.includeMeans) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(d);
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(d3);
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(d2);
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(d4);
        }
        boolean bl = false;
        String string = "0";
        double d5 = 0.0;
        d5 = d + d2 == 0.0 ? 1.0 : CnCsPerSiteAnalysis.getCumExtBinProb(d2, d + d2, d4 / (d3 + d4));
        if (d5 < outputFormat.cutoff) {
            bl = true;
            string = "-";
        }
        double d6 = 0.0;
        d6 = d + d2 == 0.0 ? 1.0 : CnCsPerSiteAnalysis.getCumExtBinProb(d, d + d2, d3 / (d3 + d4));
        if (d6 < outputFormat.cutoff) {
            bl = true;
            string = "+";
        }
        if (outputFormat.includePValues) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(d5);
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(d6);
        }
        if (outputFormat.includeSiteClassification) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(string);
        }
        if (outputFormat.includeSignificantSymbol) {
            stringBuilder.append(outputFormat.separator);
            if (bl) {
                stringBuilder.append("*");
            }
        }
        if (outputFormat.includeSimulationOutcome) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(outputFormat.siteSimulation[n]);
            stringBuilder.append(outputFormat.separator);
            if (outputFormat.siteSimulation[n].equals("+") || outputFormat.siteSimulation[n].equals("-")) {
                if (string.equals(outputFormat.siteSimulation[n])) {
                    stringBuilder.append("TP");
                } else {
                    stringBuilder.append("FN");
                }
            } else if (string.equals(outputFormat.siteSimulation[n])) {
                stringBuilder.append("TN");
            } else {
                stringBuilder.append("FP");
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String header(OutputFormat outputFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# Some information here\n");
        stringBuilder.append("# Please cite: " + Citable.Utils.getCitationString(this));
        stringBuilder.append(this.numberFormatter.formatToFieldWidth("Site", this.firstField));
        if (outputFormat.includeMeans) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Mean CN", this.fieldWidth));
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Mean UN", this.fieldWidth));
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Mean CS", this.fieldWidth));
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Mean US", this.fieldWidth));
        }
        if (outputFormat.includePValues) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Neg_Pvalue", this.fieldWidth));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Pos_Pvalue", this.fieldWidth));
        }
        if (outputFormat.includeSiteClassification) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Classification", this.fieldWidth));
        }
        if (outputFormat.includeSignificantSymbol) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Significant", this.fieldWidth));
        }
        if (outputFormat.includeSimulationOutcome) {
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Simulated", this.fieldWidth));
            stringBuilder.append(outputFormat.separator);
            stringBuilder.append(this.numberFormatter.formatToFieldWidth("Evaluation", this.fieldWidth));
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.header(this.format));
        for (int i = 0; i < this.numSites; ++i) {
            stringBuilder.append(this.toStringSite(i, this.format));
        }
        return stringBuilder.toString();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.COUNTING_PROCESSES;
    }

    @Override
    public String getDescription() {
        return "Renaissance counting";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_2012_RENAISSANCE);
    }

    private static double getCumExtBinProb(double d, double d2, double d3) {
        double d4 = 0.0;
        return d4;
    }

    private static double[] toPrimitiveDoubleArray(Double[] doubleArray) {
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        return dArray;
    }

    private static String[] parseVariableLengthStringArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() > 0) {
            String[] stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    private class OutputFormat {
        boolean includeMeans;
        boolean includePValues;
        boolean includeSignificantSymbol;
        boolean includeSiteClassification;
        boolean includeSimulationOutcome;
        String[] siteSimulation;
        double cutoff;
        String separator;

        OutputFormat() {
            this(true, true, true, true, false, null, 0.05, "\t");
        }

        OutputFormat(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String[] stringArray, double d, String string) {
            this.includeMeans = bl;
            this.includePValues = bl2;
            this.includeSignificantSymbol = bl3;
            this.includeSiteClassification = bl4;
            this.includeSimulationOutcome = bl5;
            this.siteSimulation = stringArray;
            this.cutoff = d;
            this.separator = string;
        }
    }
}

