## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(DFBA)

## -----------------------------------------------------------------------------
set.seed(77)

w1 <- 10 + rweibull(30, .8) 
w2 <- 9.1 + rweibull(30, .7)

## -----------------------------------------------------------------------------
A <- dfba_wilcoxon(Y1 = w1,
                   Y2 = w2)

A

## ----eval = FALSE-------------------------------------------------------------
#  B <- dfba_wilcoxon(Y1 = w1,
#                     Y2 = w2,
#                     method = "small",
#                     samples = 100000,
#                     hide_progress = TRUE)

## ----echo = FALSE-------------------------------------------------------------
load("wilcoxon_ex")
B

## ----fig.width = 7------------------------------------------------------------
plot(A)

## ----fig.width = 7------------------------------------------------------------
plot(B)

