/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class Tools {
    public static PrintStream getNewOutputStreamDlg(Frame par, String title, String deffn) {
        FileDialog fd = new FileDialog(par, title, 1);
        if (deffn != null) {
            fd.setFile(deffn);
        }
        fd.setModal(true);
        fd.show();
        String fnam = "";
        if (fd.getDirectory() != null) {
            fnam = fnam + fd.getDirectory();
        }
        if (fd.getFile() == null) {
            return null;
        }
        fnam = fnam + fd.getFile();
        try {
            PrintStream outs = new PrintStream(new FileOutputStream(fnam));
            return outs;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static double nlogn(double n) {
        return n <= 0.0 ? 0.0 : n * Math.log(n);
    }

    public static double nlogn(int n) {
        return n <= 0 ? 0.0 : (double)n * Math.log(n);
    }

    public static int[] sortDoublesIndex(double[] da) {
        int i;
        int ct = da.length;
        int[] r = new int[ct];
        for (i = 0; i < ct; ++i) {
            r[i] = i;
        }
        for (i = 0; i < ct - 1; ++i) {
            double d = da[r[i]];
            for (int j = ct - 1; j > i; --j) {
                double d2 = da[r[j]];
                if (!(d2 > d)) continue;
                int xx = r[i];
                r[i] = r[j];
                r[j] = xx;
                d = d2;
            }
        }
        return r;
    }

    public static int[] sortIntegersIndex(int[] da) {
        int i;
        int ct = da.length;
        int[] r = new int[ct];
        for (i = 0; i < ct; ++i) {
            r[i] = i;
        }
        for (i = 0; i < ct - 1; ++i) {
            int d = da[r[i]];
            for (int j = ct - 1; j > i; --j) {
                int d2 = da[r[j]];
                if (d2 <= d) continue;
                int xx = r[i];
                r[i] = r[j];
                r[j] = xx;
                d = d2;
            }
        }
        return r;
    }

    public static String getDisplayableValue(double val) {
        return Tools.getDisplayableValue(val, val);
    }

    public static String getDisplayableValue(double val, double range) {
        double vLenLog10 = range > 0.0 ? Math.log(range) / Math.log(10.0) : 0.0;
        int dac = 2 - (int)vLenLog10 < 0 ? 0 : 2 - (int)vLenLog10;
        return Tools.getDisplayableValue(val, dac);
    }

    public static String getDisplayableValue(double val, int dac) {
        String sig = "";
        if (dac == 0) {
            return "" + (int)val;
        }
        double mplr = 10.0;
        long implr = 10L;
        for (int i = 1; i <= dac; ++i) {
            mplr *= 10.0;
            implr *= 10L;
        }
        long front = (long)((double)Math.round(val * mplr) / mplr);
        mplr /= 10.0;
        implr /= 10L;
        double post = (val - (double)front) * mplr;
        if (post < 0.0) {
            post = -post;
        }
        long ipost = Math.round(post);
        if (val < 0.0 && front == 0L && ipost > 0L) {
            sig = "-";
        }
        if (ipost >= implr) {
            ipost -= implr;
            front = front >= 0L ? ++front : --front;
        }
        String spost = "" + ipost;
        while (spost.length() < dac) {
            spost = "0" + spost;
        }
        return sig + front + "." + spost;
    }

    public static double parseDouble(String s) {
        double d = 0.0;
        try {
            Double dd = Double.valueOf(s);
            d = dd;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static int parseInt(String s) {
        int i = 0;
        try {
            Integer dd = Integer.valueOf(s);
            i = dd;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static int parseHexInt(String s) {
        int i = 0;
        try {
            i = Integer.parseInt(s, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static long parseHexLong(String s) {
        long i = 0L;
        try {
            i = Long.parseLong(s, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static String color2hrgb(Color c) {
        int i = c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
        String s = Integer.toHexString(i);
        while (s.length() < 6) {
            s = "0" + s;
        }
        return "#" + s;
    }

    public static Color hrgb2color(String s) {
        if (s != null && s.length() > 0 && s.charAt(0) == '#') {
            int c = Tools.parseHexInt(s.substring(1));
            return new Color(c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF);
        }
        return null;
    }
}

