/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.ssf.BaseState;
import ec.tstoolkit.ssf.FastInitializer;
import ec.tstoolkit.ssf.FastState;
import ec.tstoolkit.ssf.IFastFilteringResults;
import ec.tstoolkit.ssf.IFastInitializer;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.ISsfData;

public class FastFilter<F extends ISsf> {
    private int m_pos;
    private int m_end;
    private int m_dim;
    private int m_ndiffuse;
    private boolean m_steady;
    private FastState m_state;
    private IFastInitializer<F> m_initializer;
    private F m_ssf;
    private ISsfData m_data;
    private IFastFilteringResults m_rslts;
    private static final double m_epsilon = 0.0;

    private void checksteady() {
        this.m_steady = false;
        for (int i = 0; i < this.m_dim; ++i) {
            if (!(Math.abs(this.m_state.L.get(i)) > 0.0)) continue;
            return;
        }
        this.m_steady = true;
    }

    public IFastInitializer<F> getInitializer() {
        return this.m_initializer;
    }

    public F getSsf() {
        return this.m_ssf;
    }

    public FastState getState() {
        return this.m_state;
    }

    private boolean initialize(IFastFilteringResults rslts) {
        this.m_state = new FastState(this.m_dim, this.m_data.hasData());
        if (this.m_initializer != null) {
            this.m_ndiffuse = this.m_initializer.initialize(this.m_ssf, this.m_data, this.m_state, rslts);
        } else {
            FastInitializer initializer = new FastInitializer();
            this.m_ndiffuse = initializer.initialize(this.m_ssf, this.m_data, this.m_state, rslts);
        }
        if (this.m_ndiffuse < 0) {
            return false;
        }
        this.m_pos = this.m_ndiffuse;
        return true;
    }

    private void iterate() {
        double zl = this.m_ssf.ZX(this.m_pos, this.m_state.L);
        double zlv = zl / this.m_state.f;
        this.m_state.f -= zl * zlv;
        this.m_ssf.TX(this.m_pos, this.m_state.L);
        double[] L = this.m_state.L.getData();
        double[] C = this.m_state.C.getData();
        int i = 0;
        while (i < this.m_dim) {
            double tl = L[i];
            int n = i;
            L[n] = L[n] - C[i] * zlv;
            int n2 = i++;
            C[n2] = C[n2] - tl * zlv;
        }
    }

    public boolean process(ISsfData data, IFastFilteringResults rslts) {
        if (this.m_ssf == null) {
            return false;
        }
        BaseState.fnCalls.incrementAndGet();
        this.m_data = data;
        this.m_rslts = rslts;
        this.m_dim = this.m_ssf.getStateDim();
        this.m_pos = 0;
        this.m_end = this.m_data.getCount();
        if (!this.initialize(rslts)) {
            return false;
        }
        if (rslts != null) {
            rslts.prepare((ISsf)this.m_ssf, this.m_data);
        }
        if (this.m_pos < this.m_end) {
            do {
                this.updateE();
                if (rslts != null) {
                    this.m_rslts.save(this.m_pos, this.m_state);
                }
                this.updateA();
                if (this.m_steady) continue;
                this.iterate();
            } while (++this.m_pos < this.m_end);
        }
        if (rslts != null) {
            rslts.close();
        }
        return true;
    }

    public void setInitializer(IFastInitializer<F> value) {
        this.m_initializer = value;
    }

    public void setSsf(F value) {
        this.m_ssf = value;
    }

    private void updateA() {
        this.m_ssf.TX(this.m_pos, this.m_state.A);
        double s = this.m_state.e / this.m_state.f;
        this.m_state.A.addAY(s, this.m_state.C);
    }

    private void updateE() {
        double y = this.m_data.get(this.m_pos);
        this.m_state.e = y - this.m_ssf.ZX(this.m_pos, this.m_state.A);
    }
}

