/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.JenaHandler;
import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.arp.MalformedURIException;
import com.hp.hpl.jena.rdf.arp.SAX2RDF;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.impl.RDFDefaultErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import org.xml.sax.SAXParseException;

public class SAX2Model
extends SAX2RDF {
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private final JenaHandler handler;
    private boolean closed = false;

    public static SAX2Model newInstance(String base, Model m) throws MalformedURIException {
        return new SAX2Model(base, m, "");
    }

    public static SAX2Model create(String base, Model m) throws SAXParseException {
        return new SAX2Model(base, m, "", 0);
    }

    public static SAX2Model create(String base, Model m, String lang) throws SAXParseException {
        return new SAX2Model(base, m, lang, 0);
    }

    public static SAX2Model newInstance(String base, Model m, String lang) throws MalformedURIException {
        return new SAX2Model(base, m, lang);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXParseException {
        super.startPrefixMapping(prefix, uri);
    }

    protected SAX2Model(String base, Model m, String lang) throws MalformedURIException {
        super(base, lang, true);
        this.handler = this.initHandler(m);
        this.initParseX(base, lang);
    }

    protected SAX2Model(String base, Model m, String lang, int dummy) throws SAXParseException {
        super(base, lang, true);
        this.handler = this.initHandler(m);
        this.initParse(base, lang);
    }

    SAX2Model(String base, Model m, String lang, boolean dummy) {
        super(base, lang, dummy);
        this.handler = this.initHandler(m);
    }

    private JenaHandler initHandler(Model m) {
        if (m == null) {
            return null;
        }
        JenaHandler rslt = new JenaHandler(m, this.errorHandler);
        rslt.useWith(this.getHandlers());
        return rslt;
    }

    public void close() {
        if (!this.closed) {
            super.close();
            if (this.handler != null) {
                this.handler.bulkUpdate();
            }
            this.closed = true;
        }
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        if (this.handler != null) {
            this.handler.setErrorHandler(errHandler);
        }
        return old;
    }

    public Object setProperty(String str, Object value) throws JenaException {
        Object obj = value;
        if (str.startsWith("http:") && str.startsWith("http://jena.hpl.hp.com/arp/properties/")) {
            str = str.substring(JenaReader.arpPropertiesURLLength);
        }
        return this.setArpProperty(str, obj);
    }

    private Object setArpProperty(String str, Object v) {
        return JenaReader.setArpProperty(this.getOptions(), str, v, this.errorHandler);
    }
}

