/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import weka.core.Environment;
import weka.gui.EnvironmentField;
import weka.gui.ExtensionFileFilter;
import weka.gui.FileEditor;
import weka.gui.PropertyDialog;

public class FileEnvironmentField
extends EnvironmentField {
    private static final long serialVersionUID = -233731548086207652L;
    protected FileEditor m_fileEditor = new FileEditor();
    protected PropertyDialog m_fileEditorDialog;
    protected JButton m_browseBut;

    public FileEnvironmentField() {
        this("", 0, false);
        this.setEnvironment(Environment.getSystemWide());
    }

    public FileEnvironmentField(Environment env) {
        this("", 0, false);
        this.setEnvironment(env);
    }

    public FileEnvironmentField(String label, Environment env) {
        this(label, 0, false);
        this.setEnvironment(env);
    }

    public FileEnvironmentField(String label, Environment env, int fileChooserType) {
        this(label, fileChooserType, false);
        this.setEnvironment(env);
    }

    public FileEnvironmentField(String label, Environment env, int fileChooserType, boolean directoriesOnly) {
        this(label, fileChooserType, directoriesOnly);
        this.setEnvironment(env);
    }

    public FileEnvironmentField(String label, int fileChooserType, boolean directoriesOnly) {
        super(label);
        this.m_fileEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                File selected = (File)FileEnvironmentField.this.m_fileEditor.getValue();
                if (selected != null) {
                    FileEnvironmentField.this.setText(selected.toString());
                }
            }
        });
        final JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        if (directoriesOnly) {
            embeddedEditor.setFileSelectionMode(1);
        } else {
            embeddedEditor.setFileSelectionMode(0);
        }
        embeddedEditor.setDialogType(fileChooserType);
        ExtensionFileFilter ff = new ExtensionFileFilter(".model", "Serialized Weka classifier (*.model)");
        embeddedEditor.addChoosableFileFilter(ff);
        this.m_browseBut = new JButton("Browse...");
        this.m_browseBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String modelPath = FileEnvironmentField.this.getText();
                    if (modelPath != null) {
                        try {
                            modelPath = FileEnvironmentField.this.m_env.substitute(modelPath);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        File toSet = new File(modelPath);
                        if (toSet.isFile()) {
                            FileEnvironmentField.this.m_fileEditor.setValue(new File(modelPath));
                            toSet = toSet.getParentFile();
                        }
                        if (toSet.isDirectory()) {
                            embeddedEditor.setCurrentDirectory(toSet);
                        }
                    }
                    FileEnvironmentField.this.showFileEditor();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel bP = new JPanel();
        bP.setLayout(new BorderLayout());
        bP.add((Component)this.m_browseBut, "Center");
        this.add((Component)bP, "East");
    }

    public void addFileFilter(FileFilter toSet) {
        JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        embeddedEditor.addChoosableFileFilter(toSet);
    }

    public void setFileFilter(FileFilter toSet) {
        JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        embeddedEditor.setFileFilter(toSet);
    }

    public void setCurrentDirectory(String directory) {
        this.setCurrentDirectory(new File(directory));
    }

    public void setCurrentDirectory(File directory) {
        String tmpString = directory.toString();
        if (Environment.containsEnvVariables(tmpString)) {
            try {
                tmpString = this.m_env.substitute(tmpString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File tmp2 = new File(new File(tmpString).getAbsolutePath());
        JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        if (tmp2.isDirectory()) {
            embeddedEditor.setCurrentDirectory(tmp2);
            if (embeddedEditor.getFileSelectionMode() == 1) {
                super.setAsText(directory.toString());
            }
        } else {
            embeddedEditor.setSelectedFile(tmp2);
            if (embeddedEditor.getFileSelectionMode() == 0) {
                super.setAsText(directory.toString());
            }
        }
    }

    public void resetFileFilters() {
        JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        embeddedEditor.resetChoosableFileFilters();
    }

    private void showFileEditor() {
        if (this.m_fileEditorDialog == null) {
            this.m_fileEditorDialog = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), (PropertyEditor)this.m_fileEditor, -1, -1) : new PropertyDialog(PropertyDialog.getParentFrame(this), (PropertyEditor)this.m_fileEditor, -1, -1);
        }
        if (PropertyDialog.getParentDialog(this) != null) {
            this.m_fileEditorDialog.setLocationRelativeTo(PropertyDialog.getParentDialog(this));
        } else {
            this.m_fileEditorDialog.setLocationRelativeTo(PropertyDialog.getParentFrame(this));
        }
        this.m_fileEditorDialog.setVisible(true);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.m_fileEditorDialog != null) {
            this.m_fileEditorDialog.dispose();
            this.m_fileEditorDialog = null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_browseBut.setEnabled(enabled);
    }

    @Override
    public Object getValue() {
        String path = this.getAsText();
        if (path != null && path.length() > 0) {
            return new File(path);
        }
        JFileChooser embeddedEditor = (JFileChooser)this.m_fileEditor.getCustomEditor();
        if (embeddedEditor.getFileSelectionMode() == 1) {
            return new File(".");
        }
        return new File("");
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof File) {
            this.setAsText(((File)value).toString());
        }
    }

    @Override
    public void setAsText(String val) {
        this.setCurrentDirectory(val);
    }
}

