/*
 * Decompiled with CFR 0.152.
 */
public class RuleList
extends AssocRuleMining {
    protected RuleNode startRulelist = null;

    protected void insertRuleintoRulelist(short[] sArray, short[] sArray2, double d) {
        RuleNode ruleNode = new RuleNode(sArray, sArray2, d);
        if (this.startRulelist == null) {
            this.startRulelist = ruleNode;
            return;
        }
        if (d > this.startRulelist.laplaceAccuracy) {
            ruleNode.next = this.startRulelist;
            this.startRulelist = ruleNode;
            return;
        }
        RuleNode ruleNode2 = this.startRulelist;
        RuleNode ruleNode3 = this.startRulelist.next;
        while (ruleNode3 != null) {
            if (d > ruleNode3.laplaceAccuracy) {
                ruleNode2.next = ruleNode;
                ruleNode.next = ruleNode3;
                return;
            }
            ruleNode2 = ruleNode3;
            ruleNode3 = ruleNode3.next;
        }
        ruleNode2.next = ruleNode;
    }

    protected double getLaplaceAccuracy(short[] sArray, short s) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.dataArray.length; ++i) {
            if (!this.isSubset(sArray, this.dataArray[i])) continue;
            int n3 = this.dataArray[i].length - 1;
            if (s == this.dataArray[i][n3]) {
                ++n2;
            }
            ++n;
        }
        double d = (double)(n2 + 1) / (double)(n + this.numClasses);
        return d;
    }

    protected short classifyRecordBestKaverage(int n, short[] sArray, short[] sArray2) {
        RuleNode ruleNode = this.startRulelist;
        RuleNode ruleNode2 = this.startRulelist;
        this.startRulelist = null;
        this.obtainallRulesForRecord(ruleNode, sArray2);
        this.keepBestKrulesPerClass(n, sArray);
        double[] dArray = this.getAverageAccuracies(sArray[0]);
        short s = (short)this.selectClassWithBestAverage(dArray, sArray[0]);
        this.startRulelist = ruleNode2;
        return s;
    }

    private void keepBestKrulesPerClass(int n, short[] sArray) {
        for (int i = 0; i < sArray.length; ++i) {
            int n2 = 0;
            RuleNode ruleNode = this.startRulelist;
            RuleNode ruleNode2 = null;
            while (ruleNode != null) {
                if (sArray[i] == ruleNode.consequent[0]) {
                    if (n2 < n) {
                        ++n2;
                        ruleNode2 = ruleNode;
                    } else if (ruleNode2 == null) {
                        this.startRulelist = ruleNode.next;
                    } else {
                        ruleNode2.next = ruleNode.next;
                    }
                } else {
                    ruleNode2 = ruleNode;
                }
                ruleNode = ruleNode.next;
            }
        }
    }

    private double[] getAverageAccuracies(int n) {
        int n2;
        double[] dArray = new double[this.numClasses];
        int[] nArray = new int[this.numClasses];
        RuleNode ruleNode = this.startRulelist;
        while (ruleNode != null) {
            n2 = ruleNode.consequent[0] - n;
            dArray[n2] = dArray[n2] + ruleNode.laplaceAccuracy;
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
            ruleNode = ruleNode.next;
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            if (dArray[n2] == 0.0) continue;
            dArray[n2] = dArray[n2] / (double)nArray[n2];
        }
        return dArray;
    }

    private int selectClassWithBestAverage(double[] dArray, int n) {
        int n2 = 0;
        double d = dArray[n2];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            n2 = i;
            d = dArray[i];
        }
        return n2 + n;
    }

    private void obtainallRulesForRecord(RuleNode ruleNode, short[] sArray) {
        RuleNode ruleNode2 = null;
        RuleNode ruleNode3 = null;
        while (ruleNode != null) {
            if (this.isSubset(ruleNode.antecedent, sArray)) {
                RuleNode ruleNode4 = new RuleNode(ruleNode.antecedent, ruleNode.consequent, ruleNode.laplaceAccuracy);
                if (ruleNode2 == null) {
                    ruleNode2 = ruleNode4;
                } else {
                    ruleNode3.next = ruleNode4;
                }
                ruleNode3 = ruleNode4;
            }
            ruleNode = ruleNode.next;
        }
        this.startRulelist = ruleNode2;
    }

    protected int getNumCRs() {
        int n = 0;
        RuleNode ruleNode = this.startRulelist;
        while (ruleNode != null) {
            ++n;
            ruleNode = ruleNode.next;
        }
        return n;
    }

    protected void setNumClasses(int n) {
        this.numClasses = n;
    }

    protected void setDataArray(short[][] sArray) {
        this.dataArray = sArray;
    }

    public void outputRules() {
        this.outputRules(this.startRulelist);
    }

    private void outputRules(RuleNode ruleNode) {
        System.out.println("CLASSIFIER\n----------\b");
        if (ruleNode == null) {
            System.out.println("No rules generated!");
        }
        int n = 1;
        RuleNode ruleNode2 = ruleNode;
        while (ruleNode2 != null) {
            System.out.print("(" + n + ") ");
            this.outputRule(ruleNode2);
            System.out.println(" " + this.twoDecPlaces(ruleNode2.laplaceAccuracy) + "%");
            ++n;
            ruleNode2 = ruleNode2.next;
        }
    }

    private void outputRule(RuleNode ruleNode) {
        this.outputItemSet(ruleNode.antecedent);
        System.out.print(" -> ");
        this.outputItemSet(ruleNode.consequent);
    }

    public void outputNumRules() {
        System.out.println("Number of rules         = " + this.getNumCRs());
    }

    protected class RuleNode {
        protected short[] antecedent;
        protected short[] consequent;
        double laplaceAccuracy = 0.0;
        RuleNode next = null;

        private RuleNode(short[] sArray, short[] sArray2, double d) {
            this.antecedent = sArray;
            this.consequent = sArray2;
            this.laplaceAccuracy = d;
        }
    }
}

