/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search;

import org.jamesframework.core.exceptions.SearchException;
import org.jamesframework.core.problems.Problem;
import org.jamesframework.core.problems.constraints.validations.Validation;
import org.jamesframework.core.problems.objectives.evaluations.Evaluation;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.Search;
import org.jamesframework.core.search.listeners.SearchListener;

public abstract class LocalSearch<SolutionType extends Solution>
extends Search<SolutionType> {
    private SolutionType curSolution = null;
    private Evaluation curSolutionEvaluation = null;
    private Validation curSolutionValidation = null;

    public LocalSearch(Problem<SolutionType> problem) {
        this(null, problem);
    }

    public LocalSearch(String name, Problem<SolutionType> problem) {
        super(name != null ? name : "LocalSearch", problem);
    }

    @Override
    public void init() {
        super.init();
        if (this.curSolution == null) {
            this.generateRandomInitialSolution();
        }
    }

    protected void generateRandomInitialSolution() {
        if (this.curSolution != null) {
            throw new SearchException("Cannot set random initial solution in local search: current solution is already set.");
        }
        this.updateCurrentAndBestSolution(this.getProblem().createRandomSolution(this.getRandom()));
    }

    private void fireNewCurrentSolution(SolutionType newCurrentSolution, Evaluation newCurrentSolutionEvaluation, Validation newCurrentSolutionValidation) {
        for (SearchListener<SolutionType> l : this.getSearchListeners()) {
            l.newCurrentSolution(this, newCurrentSolution, newCurrentSolutionEvaluation, newCurrentSolutionValidation);
        }
    }

    public SolutionType getCurrentSolution() {
        return this.curSolution;
    }

    public Evaluation getCurrentSolutionEvaluation() {
        return this.curSolutionEvaluation;
    }

    public Validation getCurrentSolutionValidation() {
        return this.curSolutionValidation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSolution(SolutionType solution) {
        Object object = this.getStatusLock();
        synchronized (object) {
            this.assertIdle("Cannot set current solution.");
            if (solution == null) {
                throw new NullPointerException("Cannot set current solution: received null.");
            }
            this.updateCurrentAndBestSolution(solution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSolution(SolutionType solution, Evaluation evaluation, Validation validation) {
        Object object = this.getStatusLock();
        synchronized (object) {
            this.assertIdle("Cannot set current solution.");
            if (solution == null || evaluation == null || validation == null) {
                throw new NullPointerException("Cannot set current solution: solution, evaluation and validation can not be null.");
            }
            this.updateCurrentAndBestSolution(solution, evaluation, validation);
        }
    }

    protected void updateCurrentSolution(SolutionType solution) {
        this.updateCurrentSolution(solution, this.getProblem().evaluate(solution), this.getProblem().validate(solution));
    }

    protected void updateCurrentSolution(SolutionType solution, Evaluation evaluation, Validation validation) {
        this.curSolution = solution;
        this.curSolutionEvaluation = evaluation;
        this.curSolutionValidation = validation;
        this.fireNewCurrentSolution(this.curSolution, this.curSolutionEvaluation, this.curSolutionValidation);
    }

    protected boolean updateCurrentAndBestSolution(SolutionType solution) {
        return this.updateCurrentAndBestSolution(solution, this.getProblem().evaluate(solution), this.getProblem().validate(solution));
    }

    protected boolean updateCurrentAndBestSolution(SolutionType solution, Evaluation evaluation, Validation validation) {
        this.updateCurrentSolution(solution, evaluation, validation);
        return this.updateBestSolution(solution, evaluation, validation);
    }
}

