/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.continuous.arithmetic;

import java.util.List;
import java.util.TreeSet;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.expression.continuous.arithmetic.RealIntervalConstant;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.util.objects.RealInterval;
import org.chocosolver.util.tools.RealUtils;

public class UnCArExpression
implements CArExpression {
    Model model;
    RealVar me = null;
    CArExpression.Operator op;
    private final CArExpression e;
    IStateDouble l;
    IStateDouble u;

    public UnCArExpression(CArExpression.Operator op, CArExpression exp) {
        this.op = op;
        this.e = exp;
        this.model = this.e.getModel();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public RealVar realVar(double p) {
        if (this.me == null) {
            RealVar v = this.e.realVar(p);
            switch (this.op) {
                case NEG: {
                    this.me = this.model.realVar(-v.getUB(), -v.getLB(), p);
                    this.model.realIbexGenericConstraint("{0}=-{1}", this.me, v).post();
                    break;
                }
                case ABS: {
                    this.me = this.model.realVar(0.0, Math.max(Math.abs(v.getLB()), Math.abs(v.getUB())), p);
                    this.model.realIbexGenericConstraint("{0}=abs({1})", this.me, v).post();
                    break;
                }
                case EXP: {
                    this.me = this.model.realVar(Math.min(Math.exp(v.getLB()), Math.exp(v.getUB())), Math.max(Math.exp(v.getLB()), Math.exp(v.getUB())), p);
                    this.model.realIbexGenericConstraint("{0}=exp({1})", this.me, v).post();
                    break;
                }
                case LN: {
                    this.me = this.model.realVar(Math.min(Math.log(v.getLB()), Math.log(v.getUB())), Math.max(Math.log(v.getLB()), Math.log(v.getUB())), p);
                    this.model.realIbexGenericConstraint("{0}=ln({1})", this.me, v).post();
                    break;
                }
                case SQR: {
                    RealInterval res2 = RealUtils.iPower(v, 2);
                    this.me = this.model.realVar(res2.getLB(), res2.getUB(), p);
                    this.model.realIbexGenericConstraint("{0}={1}^2", this.me, v).post();
                    break;
                }
                case SQRT: {
                    RealInterval res2_ = RealUtils.iRoot(v, 2);
                    this.me = this.model.realVar(res2_.getLB(), res2_.getUB(), p);
                    this.model.realIbexGenericConstraint("{0}=sqrt({1})", this.me, v).post();
                    break;
                }
                case CUB: {
                    RealInterval res3 = RealUtils.iPower(v, 2);
                    this.me = this.model.realVar(res3.getLB(), res3.getUB(), p);
                    this.model.realIbexGenericConstraint("{0}={1}^3", this.me, v).post();
                    break;
                }
                case CBRT: {
                    RealInterval res3_ = RealUtils.iRoot(v, 3);
                    this.me = this.model.realVar(res3_.getLB(), res3_.getUB(), p);
                    this.model.realIbexGenericConstraint("{0}={1}^(1/3)", this.me, v).post();
                    break;
                }
                case COS: {
                    this.me = this.model.realVar(-1.0, 1.0, p);
                    this.model.realIbexGenericConstraint("{0}=cos({1})", this.me, v).post();
                    break;
                }
                case SIN: {
                    this.me = this.model.realVar(-1.0, 1.0, p);
                    this.model.realIbexGenericConstraint("{0}=sin({1})", this.me, v).post();
                    break;
                }
                case TAN: {
                    this.me = this.model.realVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=tan({1})", this.me, v).post();
                    break;
                }
                case ACOS: {
                    this.me = this.model.realVar(0.0, Math.PI, p);
                    this.model.realIbexGenericConstraint("{0}=acos({1})", this.me, v).post();
                    break;
                }
                case ASIN: {
                    this.me = this.model.realVar(-1.5707963267948966, 1.5707963267948966, p);
                    this.model.realIbexGenericConstraint("{0}=asin({1})", this.me, v).post();
                    break;
                }
                case ATAN: {
                    this.me = this.model.realVar(-1.5707963267948966, 1.5707963267948966, p);
                    this.model.realIbexGenericConstraint("{0}=atan({1})", this.me, v).post();
                    break;
                }
                case COSH: {
                    this.me = this.model.realVar(0.0, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=cosh({1})", this.me, v).post();
                    break;
                }
                case SINH: {
                    this.me = this.model.realVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=sinh({1})", this.me, v).post();
                    break;
                }
                case TANH: {
                    this.me = this.model.realVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=tanh({1})", this.me, v).post();
                    break;
                }
                case ACOSH: {
                    this.me = this.model.realVar(0.0, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=acosh({1})", this.me, v).post();
                    break;
                }
                case ASINH: {
                    this.me = this.model.realVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=asinh({1})", this.me, v).post();
                    break;
                }
                case ATANH: {
                    this.me = this.model.realVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, p);
                    this.model.realIbexGenericConstraint("{0}=atanh({1})", this.me, v).post();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public void tighten() {
        RealInterval res;
        switch (this.op) {
            case COS: {
                res = RealUtils.cos(this.e);
                break;
            }
            case SIN: {
                res = RealUtils.sin(this.e);
                break;
            }
            case NEG: {
                res = new RealIntervalConstant(-this.e.getUB(), -this.e.getLB());
                break;
            }
            case SQR: {
                res = RealUtils.iPower(this.e, 2);
                break;
            }
            case SQRT: {
                res = RealUtils.iRoot(this.e, 2);
                break;
            }
            case CUB: {
                res = RealUtils.iPower(this.e, 3);
                break;
            }
            case CBRT: {
                res = RealUtils.iRoot(this.e, 3);
                break;
            }
            case ABS: {
                double linf = this.e.getLB();
                double lsup = this.e.getUB();
                if (lsup < 0.0) {
                    res = new RealIntervalConstant(-lsup, -linf);
                    break;
                }
                if (linf < 0.0) {
                    res = new RealIntervalConstant(0.0, Math.max(-linf, lsup));
                    break;
                }
                res = new RealIntervalConstant(linf, lsup);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Equation does not support " + this.op.name() + ". Consider using Ibex instead.");
            }
        }
        this.l.set(res.getLB());
        this.u.set(res.getUB());
    }

    @Override
    public void project(ICause cause) throws ContradictionException {
        RealInterval res;
        switch (this.op) {
            case COS: {
                res = RealUtils.acos_wrt(this, this.e);
                break;
            }
            case SIN: {
                res = RealUtils.asin_wrt(this, this.e);
                break;
            }
            case NEG: {
                res = new RealIntervalConstant(-this.getUB(), -this.getLB());
                break;
            }
            case SQR: {
                res = RealUtils.iRoot(this, 2, this.e);
                break;
            }
            case SQRT: {
                res = RealUtils.iPower(this, 2);
                break;
            }
            case CUB: {
                res = RealUtils.iRoot(this, 3, this.e);
                break;
            }
            case CBRT: {
                res = RealUtils.iPower(this, 3);
                break;
            }
            case ABS: {
                res = new RealIntervalConstant(-this.getUB(), this.getUB());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Equation does not support " + this.op.name() + ". Consider using Ibex instead.");
            }
        }
        this.e.intersect(res, cause);
    }

    @Override
    public void collectVariables(TreeSet<RealVar> set) {
        this.e.collectVariables(set);
    }

    @Override
    public void subExps(List<CArExpression> list) {
        this.e.subExps(list);
        list.add(this);
    }

    @Override
    public boolean isolate(RealVar var, List<CArExpression> wx, List<CArExpression> wox) {
        boolean dependsOnX = this.e.isolate(var, wx, wox);
        if (dependsOnX) {
            wx.add(this);
        } else {
            wox.add(this);
        }
        return dependsOnX;
    }

    @Override
    public void init() {
        if (this.l == null && this.u == null) {
            this.l = this.model.getEnvironment().makeFloat(Double.NEGATIVE_INFINITY);
            this.u = this.model.getEnvironment().makeFloat(Double.POSITIVE_INFINITY);
        }
        this.e.init();
    }

    @Override
    public double getLB() {
        return this.l.get();
    }

    @Override
    public double getUB() {
        return this.u.get();
    }

    @Override
    public void intersect(double lb, double ub, ICause cause) throws ContradictionException {
        if (lb > this.getLB()) {
            this.l.set(lb);
        }
        if (ub < this.getUB()) {
            this.u.set(ub);
        }
        if (this.getLB() > this.getUB()) {
            this.model.getSolver().throwsException(cause, null, "");
        }
    }

    public String toString() {
        return this.op.name() + "(" + this.e.toString() + ")";
    }
}

