/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.timeseries.util;

import internal.toolkit.base.api.timeseries.util.ObsList;
import internal.toolkit.base.api.timeseries.util.TsDataCollector;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.function.Function;
import jdplus.toolkit.base.api.data.AggregationType;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.util.ObsCharacteristics;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import lombok.Generated;

public final class TsDataBuilderUtil {
    public static final TsData NO_DATA = TsData.empty("No data available");
    public static final TsData INVALID_AGGREGATION = TsData.empty("Invalid aggregation mode");
    public static final TsData GUESS_SINGLE = TsData.empty("Cannot guess frequency with a single observation");
    public static final TsData GUESS_DUPLICATION = TsData.empty("Cannot guess frequency with duplicated periods");
    public static final TsData DUPLICATION_WITHOUT_AGGREGATION = TsData.empty("Duplicated observations without aggregation");
    public static final TsData UNKNOWN = TsData.empty("Unexpected error");

    static boolean isOrdered(ObsCharacteristics[] characteristics) {
        return Arrays.binarySearch((Object[])characteristics, (Object)ObsCharacteristics.ORDERED) != -1;
    }

    static boolean isValid(ObsGathering gathering) {
        return !gathering.getUnit().equals(TsUnit.UNDEFINED) || gathering.getAggregationType() == AggregationType.None;
    }

    static Function<ObsList, TsData> getMaker(ObsGathering gathering) {
        if (gathering.getUnit().equals(TsUnit.UNDEFINED)) {
            return o -> TsDataBuilderUtil.makeFromUnknownFrequency(o);
        }
        if (gathering.getAggregationType() != AggregationType.None) {
            return o -> TsDataBuilderUtil.makeWithAggregation(o, gathering.getUnit(), TsPeriod.DEFAULT_EPOCH, gathering.getAggregationType(), gathering.isAllowPartialAggregation());
        }
        return o -> TsDataBuilderUtil.makeWithoutAggregation(o, gathering.getUnit(), TsPeriod.DEFAULT_EPOCH);
    }

    private static TsData makeFromUnknownFrequency(ObsList obs) {
        switch (obs.size()) {
            case 0: {
                return NO_DATA;
            }
            case 1: {
                return GUESS_SINGLE;
            }
        }
        TsData result = TsDataCollector.makeFromUnknownUnit(obs);
        return result != null ? result : GUESS_DUPLICATION;
    }

    private static TsData makeWithoutAggregation(ObsList obs, TsUnit unit, LocalDateTime reference) {
        switch (obs.size()) {
            case 0: {
                return NO_DATA;
            }
        }
        TsData result = TsDataCollector.makeWithoutAggregation(obs, unit, reference);
        return result != null ? result : DUPLICATION_WITHOUT_AGGREGATION;
    }

    private static TsData makeWithAggregation(ObsList obs, TsUnit unit, LocalDateTime reference, AggregationType aggregationType, boolean allowPartialAggregation) {
        switch (obs.size()) {
            case 0: {
                return NO_DATA;
            }
        }
        TsData result = TsDataCollector.makeFromUnknownUnit(obs);
        result = result != null && unit.contains(result.getTsUnit()) ? result.aggregate(unit, aggregationType, !allowPartialAggregation) : TsDataCollector.makeWithAggregation(obs, unit, reference, aggregationType);
        return result != null ? result : UNKNOWN;
    }

    @Generated
    private TsDataBuilderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

