/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.ami;

import jdplus.toolkit.base.api.DemetraException;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.regarima.GlsArimaProcessor;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.ami.MultiPeriodicAirlineMapping;
import jdplus.toolkit.base.core.stats.RobustStandardDeviationComputer;

public class GenericLogLevelModule {
    private final int[] periodicities;
    private final double abnormal;
    private final double logPreference;
    private double log;
    private double level;

    public static Builder builder() {
        return new Builder();
    }

    private GenericLogLevelModule(Builder builder) {
        this.periodicities = builder.periodicities;
        this.abnormal = builder.abnormal;
        this.logPreference = builder.logPreference;
    }

    public void process(DoubleSeq data) {
        RegArimaModel model;
        DoubleSeq ldata = data.log();
        int n = data.length();
        DoubleSeq d = data;
        DoubleSeq ld = ldata;
        int del = 1;
        d = d.delta(1);
        ld = ld.delta(1);
        for (int i = 0; i < this.periodicities.length; ++i) {
            d = d.delta(this.periodicities[i]);
            ld = ld.delta(this.periodicities[i]);
            del += this.periodicities[i];
        }
        double std = RobustStandardDeviationComputer.mad(50.0, true).compute(d);
        double lstd = RobustStandardDeviationComputer.mad(50.0, true).compute(ld);
        IntList missing = new IntList();
        for (int i = 0; i < d.length(); ++i) {
            double cur = d.get(i);
            double lcur = ld.get(i);
            if (!(Math.abs(cur) > this.abnormal * std) || !(Math.abs(lcur) < this.abnormal * lstd)) continue;
            missing.add(i + del);
        }
        MultiPeriodicAirlineMapping mapping = new MultiPeriodicAirlineMapping(this.periodicities);
        GlsArimaProcessor<ArimaModel> processor = GlsArimaProcessor.builder(ArimaModel.class).precision(1.0E-5).build();
        RegArimaEstimation<ArimaModel> e = processor.process(model = RegArimaModel.builder().y(data).missing(missing.toArray()).arima(mapping.map(mapping.getDefaultParameters())).build(), mapping);
        if (e != null) {
            this.level = Math.log(e.getConcentratedLikelihood().ssq() * e.getConcentratedLikelihood().factor());
        }
        double slog = 0.0;
        int m = 0;
        DoubleSeqCursor cursor = ldata.cursor();
        cursor.skip(del);
        for (int i = del; i < n; ++i) {
            double lx = cursor.getAndNext();
            if (lx <= 0.0) {
                throw new DemetraException();
            }
            if (missing.contains(i)) continue;
            slog += lx;
            ++m;
        }
        slog /= (double)m;
        RegArimaModel logModel = model.toBuilder().y(ldata).build();
        RegArimaEstimation<ArimaModel> el = processor.process(logModel, mapping);
        if (el != null) {
            this.log = Math.log(el.getConcentratedLikelihood().ssq() * el.getConcentratedLikelihood().factor()) + 2.0 * slog;
        }
    }

    public double getLog() {
        return this.log;
    }

    public double getLevel() {
        return this.level;
    }

    public boolean isChoosingLog() {
        return this.log + this.logPreference < this.level;
    }

    public static class Builder {
        private int[] periodicities = new int[]{12};
        private double abnormal = 5.0;
        private double logPreference = 0.0;

        public Builder periodicities(int[] periodicities) {
            this.periodicities = periodicities;
            return this;
        }

        public Builder abnormalityThreshold(double abnormal) {
            this.abnormal = abnormal;
            return this;
        }

        public Builder logPreference(double logPreference) {
            this.logPreference = logPreference;
            return this;
        }

        public GenericLogLevelModule build() {
            return new GenericLogLevelModule(this);
        }
    }
}

