/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import java.util.ArrayList;
import java.util.List;

public class ExternalLengthStatistic
extends TreeStatistic {
    private Tree tree = null;
    private List<NodeRef> leafSet = new ArrayList<NodeRef>();

    public ExternalLengthStatistic(String string, Tree tree, TaxonList taxonList) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        int n = taxonList.getTaxonCount();
        int n2 = tree.getExternalNodeCount();
        for (int i = 0; i < n; ++i) {
            Taxon taxon = taxonList.getTaxon(i);
            NodeRef nodeRef = null;
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                nodeRef = tree.getExternalNode(j);
                if (!tree.getNodeTaxon(nodeRef).getId().equals(taxon.getId())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new TreeUtils.MissingTaxonException(taxon);
            }
            this.leafSet.add(nodeRef);
        }
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return this.leafSet.size();
    }

    @Override
    public double getStatisticValue(int n) {
        NodeRef nodeRef = this.leafSet.get(n);
        return this.tree.getBranchLength(nodeRef);
    }
}

