/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

class StepSize {
    private final Options options;
    private final double mu;
    private double stepSize;
    private double logStepSize;
    private double averageLogStepSize;
    private double h;

    StepSize(double d) {
        this(d, new Options());
    }

    private StepSize(double d, Options options) {
        this.options = options;
        this.mu = Math.log(options.muFactor * d);
        this.stepSize = d;
        this.logStepSize = Math.log(this.stepSize);
        this.averageLogStepSize = 0.0;
        this.h = 0.0;
    }

    void update(long l, double d, double d2) {
        if (l <= (long)this.options.adaptLength) {
            this.h = (1.0 - 1.0 / ((double)l + this.options.t0)) * this.h + 1.0 / ((double)l + this.options.t0) * (this.options.targetAcceptRate - d / d2);
            this.logStepSize = this.mu - Math.sqrt(l) / this.options.gamma * this.h;
            this.averageLogStepSize = Math.pow(l, -this.options.kappa) * this.logStepSize + (1.0 - Math.pow(l, -this.options.kappa)) * this.averageLogStepSize;
            this.stepSize = Math.exp(this.logStepSize);
        }
    }

    double getStepSize() {
        return this.stepSize;
    }

    static class Options {
        double kappa = 0.75;
        double t0 = 10.0;
        double gamma = 0.05;
        double targetAcceptRate = 0.85;
        double muFactor = 10.0;
        int adaptLength = 1000;

        Options() {
        }
    }
}

