/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Permutator
implements Iterator {
    private final int size;
    private final Object[] elements;
    private final Object ar;
    private final int[] permutation;
    private boolean next = true;

    public Permutator(Object[] objectArray) {
        this.size = objectArray.length;
        this.elements = new Object[this.size];
        System.arraycopy(objectArray, 0, this.elements, 0, this.size);
        this.ar = Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        System.arraycopy(objectArray, 0, this.ar, 0, this.size);
        this.permutation = new int[this.size + 1];
        for (int i = 0; i < this.size + 1; ++i) {
            this.permutation[i] = i;
        }
    }

    private void formNextPermutation() {
        for (int i = 0; i < this.size; ++i) {
            Array.set(this.ar, i, this.elements[this.permutation[i + 1] - 1]);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void swap(int n, int n2) {
        int n3 = this.permutation[n];
        this.permutation[n] = this.permutation[n2];
        this.permutation[n2] = n3;
    }

    public Object next() throws NoSuchElementException {
        this.formNextPermutation();
        int n = this.size - 1;
        while (this.permutation[n] > this.permutation[n + 1]) {
            --n;
        }
        if (n == 0) {
            this.next = false;
            for (int i = 0; i < this.size + 1; ++i) {
                this.permutation[i] = i;
            }
            return this.ar;
        }
        int n2 = this.size;
        while (this.permutation[n] > this.permutation[n2]) {
            --n2;
        }
        this.swap(n, n2);
        int n3 = this.size;
        for (int i = n + 1; n3 > i; --n3, ++i) {
            this.swap(n3, i);
        }
        return this.ar;
    }

    public String toString() {
        int n = Array.getLength(this.ar);
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(Array.get(this.ar, i).toString());
            if (i >= n - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return new String(stringBuffer);
    }

    public static void main(String[] stringArray) {
        Permutator permutator = new Permutator(stringArray);
        while (permutator.hasNext()) {
            permutator.next();
            System.out.println(permutator);
        }
    }
}

