/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.BaseNode;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootedFromUnrooted
implements RootedTree {
    private Tree source;
    private Node root;
    private Map<Node, Node> parents;
    private Node topLeft;
    private Node topRight;
    private double rootToLeft;
    private double rootToRight;
    private boolean intentUnrooted;

    private void setParent(Node node, Node parent) {
        this.parents.put(node, parent);
        for (Node adj : this.source.getAdjacencies(node)) {
            if (adj == parent || node == this.topLeft && adj == this.topRight || node == this.topRight && adj == this.topLeft) continue;
            this.setParent(adj, node);
        }
    }

    public RootedFromUnrooted(Tree source, Node root, boolean intentUnrooted) {
        this.source = source;
        this.root = root;
        this.intentUnrooted = intentUnrooted;
        this.topRight = null;
        this.topLeft = null;
        this.rootToRight = 0.0;
        this.rootToLeft = 0.0;
        this.parents = new LinkedHashMap<Node, Node>();
        for (Node adj : source.getAdjacencies(root)) {
            this.setParent(adj, root);
        }
    }

    public RootedFromUnrooted(Tree source, Node left, Node right, double fromLeft) {
        this.source = source;
        this.intentUnrooted = false;
        this.topLeft = left;
        this.topRight = right;
        this.rootToLeft = fromLeft;
        try {
            this.rootToRight = source.getEdgeLength(left, right) - this.rootToLeft;
        }
        catch (Graph.NoEdgeException e) {
            // empty catch block
        }
        this.parents = new LinkedHashMap<Node, Node>();
        this.root = new BaseNode(){

            public int getDegree() {
                return 2;
            }
        };
        this.parents.put(this.root, null);
        this.setParent(left, this.root);
        this.setParent(right, this.root);
    }

    @Override
    public List<Node> getChildren(Node node) {
        ArrayList<Node> s = new ArrayList<Node>(this.getAdjacencies(node));
        if (node != this.root) {
            s.remove(this.getParent(node));
        }
        return s;
    }

    @Override
    public boolean hasHeights() {
        return false;
    }

    private double findNodeHeightFromTips(Node node) {
        if (this.isExternal(node)) {
            return 0.0;
        }
        double h = 0.0;
        for (Node n : this.getChildren(node)) {
            h = Math.max(h, this.getLength(n) + this.findNodeHeightFromTips(n));
        }
        return h;
    }

    @Override
    public double getHeight(Node node) {
        double hr = this.findNodeHeightFromTips(this.root);
        if (node == this.root) {
            return hr;
        }
        double toRoot = 0.0;
        while (node != this.root) {
            toRoot += this.getLength(node);
            node = this.getParent(node);
        }
        return hr - toRoot;
    }

    @Override
    public boolean hasLengths() {
        return true;
    }

    @Override
    public double getLength(Node node) {
        if (node == this.root) {
            return 0.0;
        }
        if (node == this.topLeft) {
            return this.rootToLeft;
        }
        if (node == this.topRight) {
            return this.rootToRight;
        }
        double l = 0.0;
        try {
            l = this.source.getEdgeLength(node, this.getParent(node));
        }
        catch (Graph.NoEdgeException e) {
            // empty catch block
        }
        return l;
    }

    @Override
    public Node getParent(Node node) {
        return this.parents.get(node);
    }

    @Override
    public Node getRootNode() {
        return this.root;
    }

    @Override
    public boolean conceptuallyUnrooted() {
        return this.intentUnrooted;
    }

    @Override
    public Set<Node> getExternalNodes() {
        return this.source.getExternalNodes();
    }

    @Override
    public Set<Node> getInternalNodes() {
        LinkedHashSet<Node> s = new LinkedHashSet<Node>(this.source.getInternalNodes());
        s.add(this.root);
        return s;
    }

    @Override
    public Set<Taxon> getTaxa() {
        return this.source.getTaxa();
    }

    @Override
    public Taxon getTaxon(Node node) {
        if (node == this.root) {
            return null;
        }
        return this.source.getTaxon(node);
    }

    @Override
    public boolean isExternal(Node node) {
        return node != this.root && this.source.isExternal(node);
    }

    @Override
    public Node getNode(Taxon taxon) {
        return this.source.getNode(taxon);
    }

    @Override
    public void renameTaxa(Taxon from, Taxon to) {
        this.source.renameTaxa(from, to);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        return this.source.getEdges(node);
    }

    @Override
    public Node[] getNodes(Edge edge) {
        return this.source.getNodes(edge);
    }

    @Override
    public List<Node> getAdjacencies(Node node) {
        if (this.topLeft != null) {
            if (node == this.root) {
                Node[] d = new Node[]{this.topLeft, this.topRight};
                return Arrays.asList(d);
            }
            if (node == this.topLeft || node == this.topRight) {
                ArrayList<Node> s = new ArrayList<Node>(this.source.getAdjacencies(node));
                s.remove(node == this.topLeft ? this.topRight : this.topLeft);
                s.add(this.root);
                return s;
            }
        }
        return this.source.getAdjacencies(node);
    }

    @Override
    public double getEdgeLength(Node node1, Node node2) throws Graph.NoEdgeException {
        if (this.topLeft != null) {
            if (node2 == this.root) {
                Node tmp = node1;
                node1 = node2;
                node2 = tmp;
            }
            if (node1 == this.root) {
                if (node2 != this.topLeft && node2 != this.topRight) {
                    throw new Graph.NoEdgeException();
                }
                return node2 == this.topLeft ? this.rootToLeft : this.rootToRight;
            }
        }
        return this.source.getEdgeLength(node1, node2);
    }

    @Override
    public Edge getEdge(Node node1, Node node2) throws Graph.NoEdgeException {
        return this.source.getEdge(node1, node2);
    }

    @Override
    public Set<Node> getNodes() {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(this.getInternalNodes());
        nodes.addAll(this.getExternalNodes());
        if (this.topLeft != null) {
            nodes.add(this.root);
        }
        return nodes;
    }

    @Override
    public Set<Edge> getEdges() {
        return this.source.getEdges();
    }

    @Override
    public Set<Edge> getExternalEdges() {
        return this.source.getExternalEdges();
    }

    @Override
    public Set<Edge> getInternalEdges() {
        return this.source.getInternalEdges();
    }

    @Override
    public Set<Node> getNodes(int degree) {
        Set<Node> nodes = this.source.getNodes(degree);
        if (degree == 2) {
            nodes.add(this.root);
        }
        return nodes;
    }

    @Override
    public boolean isRoot(Node node) {
        return node == this.root;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.source.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.source.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.source.removeAttribute(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.source.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.source.getAttributeMap();
    }
}

