/*
 * Decompiled with CFR 0.152.
 */
package core.explorer;

import core.explorer.ChordalysisModeller;
import core.model.ScoredGraphAction;
import core.stats.EntropyComputer;
import core.stats.scorer.GraphActionScorer;
import core.stats.scorer.GraphActionScorerEntropy;

public class ChordalysisModellingKL
extends ChordalysisModeller {
    int maxK;
    boolean normaliseByNumberParameters;

    public ChordalysisModellingKL(ChordalysisModeller.Data data, int maxK) {
        super(data);
        this.maxK = maxK;
        this.normaliseByNumberParameters = false;
    }

    public ChordalysisModellingKL(ChordalysisModeller.Data data, int maxK, boolean normaliseByNumberParameters) {
        super(data);
        this.maxK = maxK;
        this.normaliseByNumberParameters = normaliseByNumberParameters;
    }

    @Override
    protected GraphActionScorer initScorer() {
        EntropyComputer entropyComputer = new EntropyComputer(this.lattice);
        return new GraphActionScorerEntropy(entropyComputer, this.maxK, this.normaliseByNumberParameters);
    }

    @Override
    public void explore() {
        this.pq.processStoredModifications();
        int step = 0;
        while (!this.pq.isEmpty() && step < this.maxNSteps) {
            ScoredGraphAction todo = (ScoredGraphAction)this.pq.poll();
            if (todo.getScore() == Double.POSITIVE_INFINITY) break;
            this.operationsPerformed.add(todo);
            this.bestModel.performAction(todo, this.bestModel, this.pq);
            ++step;
        }
    }
}

